/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.hunspell;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import org.neo4j.shaded.lucene9.codecs.CodecUtil;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.store.IndexOutput;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.BytesRefComparator;
import org.neo4j.shaded.lucene9.util.IOUtils;
import org.neo4j.shaded.lucene9.util.OfflineSorter;

public abstract class SortingStrategy {
    abstract EntryAccumulator start() throws IOException;

    public static SortingStrategy offline(final Directory tempDir, final String tempFileNamePrefix) {
        return new SortingStrategy(){

            @Override
            EntryAccumulator start() throws IOException {
                final IndexOutput output = tempDir.createTempOutput(tempFileNamePrefix, "dat", IOContext.DEFAULT);
                final OfflineSorter.ByteSequencesWriter writer = new OfflineSorter.ByteSequencesWriter(output);
                return new EntryAccumulator(){
                    int wordCount = 0;

                    @Override
                    public void addEntry(String entry) throws IOException {
                        ++this.wordCount;
                        writer.write(entry.getBytes(StandardCharsets.UTF_8));
                    }

                    @Override
                    public EntrySupplier finishAndSort() throws IOException {
                        CodecUtil.writeFooter(output);
                        writer.close();
                        final String sortedFile = this.sortWordsOffline();
                        final OfflineSorter.ByteSequencesReader reader = new OfflineSorter.ByteSequencesReader(tempDir.openChecksumInput(sortedFile, IOContext.READONCE), sortedFile);
                        return new EntrySupplier(){
                            boolean success = false;

                            @Override
                            public int wordCount() {
                                return wordCount;
                            }

                            @Override
                            public String next() throws IOException {
                                BytesRef scratch = reader.next();
                                if (scratch == null) {
                                    this.success = true;
                                    return null;
                                }
                                return scratch.utf8ToString();
                            }

                            @Override
                            public void close() throws IOException {
                                reader.close();
                                if (this.success) {
                                    tempDir.deleteFile(sortedFile);
                                } else {
                                    IOUtils.deleteFilesIgnoringExceptions(tempDir, sortedFile);
                                }
                            }
                        };
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private String sortWordsOffline() throws IOException {
                        String sorted;
                        block5: {
                            block4: {
                                OfflineSorter sorter = new OfflineSorter(tempDir, tempFileNamePrefix, BytesRefComparator.NATURAL);
                                boolean success = false;
                                try {
                                    sorted = sorter.sort(output.getName());
                                    success = true;
                                    if (!success) break block4;
                                }
                                catch (Throwable throwable) {
                                    if (success) {
                                        tempDir.deleteFile(output.getName());
                                    } else {
                                        IOUtils.deleteFilesIgnoringExceptions(tempDir, output.getName());
                                    }
                                    throw throwable;
                                }
                                tempDir.deleteFile(output.getName());
                                break block5;
                            }
                            IOUtils.deleteFilesIgnoringExceptions(tempDir, output.getName());
                        }
                        return sorted;
                    }
                };
            }
        };
    }

    public static SortingStrategy inMemory() {
        return new SortingStrategy(){

            @Override
            EntryAccumulator start() {
                final ArrayList entries = new ArrayList();
                return new EntryAccumulator(){

                    @Override
                    public void addEntry(String entry) {
                        entries.add(entry);
                    }

                    @Override
                    public EntrySupplier finishAndSort() {
                        entries.sort(Comparator.naturalOrder());
                        return new EntrySupplier(){
                            int i = 0;

                            @Override
                            public int wordCount() {
                                return entries.size();
                            }

                            @Override
                            public String next() {
                                return this.i < entries.size() ? (String)entries.get(this.i++) : null;
                            }

                            @Override
                            public void close() {
                            }
                        };
                    }
                };
            }
        };
    }

    static interface EntrySupplier
    extends Closeable {
        public int wordCount();

        public String next() throws IOException;
    }

    static interface EntryAccumulator {
        public void addEntry(String var1) throws IOException;

        public EntrySupplier finishAndSort() throws IOException;
    }
}

