/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.id;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.LowerCaseFilter;
import org.neo4j.shaded.lucene9.analysis.StopFilter;
import org.neo4j.shaded.lucene9.analysis.StopwordAnalyzerBase;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.WordlistLoader;
import org.neo4j.shaded.lucene9.analysis.id.IndonesianStemFilter;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.neo4j.shaded.lucene9.analysis.standard.StandardTokenizer;
import org.neo4j.shaded.lucene9.util.IOUtils;

public final class IndonesianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final CharArraySet stemExclusionSet;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public IndonesianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public IndonesianAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public IndonesianAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        return new Analyzer.TokenStreamComponents(source, (TokenStream)new IndonesianStemFilter(result));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(IndonesianAnalyzer.class.getResourceAsStream(IndonesianAnalyzer.DEFAULT_STOPWORD_FILE), IndonesianAnalyzer.DEFAULT_STOPWORD_FILE), "#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

