/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.miscellaneous;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.PatternKeywordMarkerFilter;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.neo4j.shaded.lucene9.util.ResourceLoader;
import org.neo4j.shaded.lucene9.util.ResourceLoaderAware;

public class KeywordMarkerFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "keywordMarker";
    public static final String PROTECTED_TOKENS = "protected";
    public static final String PATTERN = "pattern";
    private final String wordFiles;
    private final String stringPattern;
    private final boolean ignoreCase;
    private Pattern pattern;
    private CharArraySet protectedWords;

    public KeywordMarkerFilterFactory(Map<String, String> args) {
        super(args);
        this.wordFiles = this.get(args, PROTECTED_TOKENS);
        this.stringPattern = this.get(args, PATTERN);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public KeywordMarkerFilterFactory() {
        throw KeywordMarkerFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.wordFiles != null) {
            this.protectedWords = this.getWordSet(loader, this.wordFiles, this.ignoreCase);
        }
        if (this.stringPattern != null) {
            this.pattern = this.ignoreCase ? Pattern.compile(this.stringPattern, 66) : Pattern.compile(this.stringPattern);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.pattern != null) {
            input = new PatternKeywordMarkerFilter(input, this.pattern);
        }
        if (this.protectedWords != null) {
            input = new SetKeywordMarkerFilter(input, this.protectedWords);
        }
        return input;
    }
}

