/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.miscellaneous;

import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.AnalyzerWrapper;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.LimitTokenCountFilter;

public final class LimitTokenCountAnalyzer
extends AnalyzerWrapper {
    private final Analyzer delegate;
    private final int maxTokenCount;
    private final boolean consumeAllTokens;

    public LimitTokenCountAnalyzer(Analyzer delegate, int maxTokenCount) {
        this(delegate, maxTokenCount, false);
    }

    public LimitTokenCountAnalyzer(Analyzer delegate, int maxTokenCount, boolean consumeAllTokens) {
        super(delegate.getReuseStrategy());
        this.delegate = delegate;
        this.maxTokenCount = maxTokenCount;
        this.consumeAllTokens = consumeAllTokens;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    @Override
    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)new LimitTokenCountFilter(components.getTokenStream(), this.maxTokenCount, this.consumeAllTokens));
    }

    public String toString() {
        return "LimitTokenCountAnalyzer(" + this.delegate.toString() + ", maxTokenCount=" + this.maxTokenCount + ", consumeAllTokens=" + this.consumeAllTokens + ")";
    }
}

