/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.payloads;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.payloads.DelimitedPayloadTokenFilter;
import org.neo4j.shaded.lucene9.analysis.payloads.FloatEncoder;
import org.neo4j.shaded.lucene9.analysis.payloads.IdentityEncoder;
import org.neo4j.shaded.lucene9.analysis.payloads.IntegerEncoder;
import org.neo4j.shaded.lucene9.analysis.payloads.PayloadEncoder;
import org.neo4j.shaded.lucene9.util.ResourceLoader;
import org.neo4j.shaded.lucene9.util.ResourceLoaderAware;

public class DelimitedPayloadTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "delimitedPayload";
    public static final String ENCODER_ATTR = "encoder";
    public static final String DELIMITER_ATTR = "delimiter";
    private final String encoderClass;
    private final char delimiter;
    private PayloadEncoder encoder;

    public DelimitedPayloadTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.encoderClass = this.require(args, ENCODER_ATTR);
        this.delimiter = this.getChar(args, DELIMITER_ATTR, '|');
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public DelimitedPayloadTokenFilterFactory() {
        throw DelimitedPayloadTokenFilterFactory.defaultCtorException();
    }

    @Override
    public DelimitedPayloadTokenFilter create(TokenStream input) {
        return new DelimitedPayloadTokenFilter(input, this.delimiter, this.encoder);
    }

    @Override
    public void inform(ResourceLoader loader) {
        this.encoder = this.encoderClass.equals("float") ? new FloatEncoder() : (this.encoderClass.equals("integer") ? new IntegerEncoder() : (this.encoderClass.equals("identity") ? new IdentityEncoder() : loader.newInstance(this.encoderClass, PayloadEncoder.class)));
    }
}

