/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.lucene90;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.neo4j.shaded.lucene9.codecs.CodecUtil;
import org.neo4j.shaded.lucene9.codecs.SegmentInfoFormat;
import org.neo4j.shaded.lucene9.index.CorruptIndexException;
import org.neo4j.shaded.lucene9.index.IndexFileNames;
import org.neo4j.shaded.lucene9.index.SegmentInfo;
import org.neo4j.shaded.lucene9.index.SortFieldProvider;
import org.neo4j.shaded.lucene9.search.Sort;
import org.neo4j.shaded.lucene9.search.SortField;
import org.neo4j.shaded.lucene9.store.ChecksumIndexInput;
import org.neo4j.shaded.lucene9.store.DataInput;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.util.Version;

public class Lucene90SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene90SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, segmentID, "");
                si = this.parseSegmentInfo(dir, input, segment, segmentID);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    private SegmentInfo parseSegmentInfo(Directory dir, DataInput input, String segment, byte[] segmentID) throws IOException {
        Sort indexSort;
        Version minVersion;
        Version version = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
        byte hasMinVersion = input.readByte();
        switch (hasMinVersion) {
            case 0: {
                minVersion = null;
                break;
            }
            case 1: {
                minVersion = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                break;
            }
            default: {
                throw new CorruptIndexException("Illegal boolean value " + hasMinVersion, input);
            }
        }
        int docCount = input.readInt();
        if (docCount < 0) {
            throw new CorruptIndexException("invalid docCount: " + docCount, input);
        }
        boolean isCompoundFile = input.readByte() == 1;
        Map<String, String> diagnostics = input.readMapOfStrings();
        Set<String> files = input.readSetOfStrings();
        Map<String, String> attributes = input.readMapOfStrings();
        int numSortFields = input.readVInt();
        if (numSortFields > 0) {
            SortField[] sortFields = new SortField[numSortFields];
            for (int i = 0; i < numSortFields; ++i) {
                String name = input.readString();
                sortFields[i] = SortFieldProvider.forName(name).readSortField(input);
            }
            indexSort = new Sort(sortFields);
        } else {
            if (numSortFields < 0) {
                throw new CorruptIndexException("invalid index sort field count: " + numSortFields, input);
            }
            indexSort = null;
        }
        SegmentInfo si = new SegmentInfo(dir, version, minVersion, segment, docCount, isCompoundFile, false, null, diagnostics, segmentID, attributes, indexSort);
        si.setFiles(files);
        return si;
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        throw new UnsupportedOperationException("Old formats can't be used for writing");
    }
}

