/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.lucene91;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.shaded.lucene9.backward_codecs.lucene91.Lucene91NeighborArray;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.hnsw.HnswGraph;

public final class Lucene91OnHeapHnswGraph
extends HnswGraph {
    private final int maxConn;
    private int numLevels;
    private int entryNode;
    private final List<int[]> nodesByLevel;
    private final List<List<Lucene91NeighborArray>> graph;
    private int upto;
    private Lucene91NeighborArray cur;

    Lucene91OnHeapHnswGraph(int maxConn, int levelOfFirstNode) {
        this.maxConn = maxConn;
        this.numLevels = levelOfFirstNode + 1;
        this.graph = new ArrayList<List<Lucene91NeighborArray>>(this.numLevels);
        this.entryNode = 0;
        for (int i = 0; i < this.numLevels; ++i) {
            this.graph.add(new ArrayList());
            this.graph.get(i).add(new Lucene91NeighborArray(Math.max(32, maxConn / 4)));
        }
        this.nodesByLevel = new ArrayList<int[]>(this.numLevels);
        this.nodesByLevel.add(null);
        for (int l = 1; l < this.numLevels; ++l) {
            this.nodesByLevel.add(new int[]{0});
        }
    }

    public Lucene91NeighborArray getNeighbors(int level, int node) {
        if (level == 0) {
            return this.graph.get(level).get(node);
        }
        int nodeIndex = Arrays.binarySearch(this.nodesByLevel.get(level), 0, this.graph.get(level).size(), node);
        assert (nodeIndex >= 0);
        return this.graph.get(level).get(nodeIndex);
    }

    @Override
    public int size() {
        return this.graph.get(0).size();
    }

    public void addNode(int level, int node) {
        if (level > 0) {
            if (level >= this.numLevels) {
                for (int i = this.numLevels; i <= level; ++i) {
                    this.graph.add(new ArrayList());
                    this.nodesByLevel.add(new int[]{node});
                }
                this.numLevels = level + 1;
                this.entryNode = node;
            } else {
                int[] nodes = this.nodesByLevel.get(level);
                int idx = this.graph.get(level).size();
                if (idx < nodes.length) {
                    nodes[idx] = node;
                } else {
                    nodes = ArrayUtil.grow(nodes);
                    nodes[idx] = node;
                    this.nodesByLevel.set(level, nodes);
                }
            }
        }
        this.graph.get(level).add(new Lucene91NeighborArray(this.maxConn + 1));
    }

    @Override
    public void seek(int level, int targetNode) {
        this.cur = this.getNeighbors(level, targetNode);
        this.upto = -1;
    }

    @Override
    public int nextNeighbor() {
        if (++this.upto < this.cur.size()) {
            return this.cur.node[this.upto];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int numLevels() {
        return this.numLevels;
    }

    @Override
    public int entryNode() {
        return this.entryNode;
    }

    @Override
    public HnswGraph.NodesIterator getNodesOnLevel(int level) {
        if (level == 0) {
            return new HnswGraph.ArrayNodesIterator(this.size());
        }
        return new HnswGraph.ArrayNodesIterator(this.nodesByLevel.get(level), this.graph.get(level).size());
    }
}

