/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.lucene95;

import java.util.Objects;
import org.neo4j.shaded.lucene9.backward_codecs.lucene90.Lucene90PostingsFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene90.Lucene90SegmentInfoFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene95.Lucene95HnswVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.Codec;
import org.neo4j.shaded.lucene9.codecs.CompoundFormat;
import org.neo4j.shaded.lucene9.codecs.DocValuesFormat;
import org.neo4j.shaded.lucene9.codecs.FieldInfosFormat;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.LiveDocsFormat;
import org.neo4j.shaded.lucene9.codecs.NormsFormat;
import org.neo4j.shaded.lucene9.codecs.PointsFormat;
import org.neo4j.shaded.lucene9.codecs.PostingsFormat;
import org.neo4j.shaded.lucene9.codecs.SegmentInfoFormat;
import org.neo4j.shaded.lucene9.codecs.StoredFieldsFormat;
import org.neo4j.shaded.lucene9.codecs.TermVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.lucene90.Lucene90CompoundFormat;
import org.neo4j.shaded.lucene9.codecs.lucene90.Lucene90DocValuesFormat;
import org.neo4j.shaded.lucene9.codecs.lucene90.Lucene90LiveDocsFormat;
import org.neo4j.shaded.lucene9.codecs.lucene90.Lucene90NormsFormat;
import org.neo4j.shaded.lucene9.codecs.lucene90.Lucene90PointsFormat;
import org.neo4j.shaded.lucene9.codecs.lucene90.Lucene90StoredFieldsFormat;
import org.neo4j.shaded.lucene9.codecs.lucene90.Lucene90TermVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.lucene94.Lucene94FieldInfosFormat;
import org.neo4j.shaded.lucene9.codecs.perfield.PerFieldDocValuesFormat;
import org.neo4j.shaded.lucene9.codecs.perfield.PerFieldKnnVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.perfield.PerFieldPostingsFormat;

public class Lucene95Codec
extends Codec {
    private final TermVectorsFormat vectorsFormat = new Lucene90TermVectorsFormat();
    private final FieldInfosFormat fieldInfosFormat = new Lucene94FieldInfosFormat();
    private final SegmentInfoFormat segmentInfosFormat = new Lucene90SegmentInfoFormat();
    private final LiveDocsFormat liveDocsFormat = new Lucene90LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene90CompoundFormat();
    private final NormsFormat normsFormat = new Lucene90NormsFormat();
    private final PostingsFormat defaultPostingsFormat;
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        @Override
        public PostingsFormat getPostingsFormatForField(String field) {
            return Lucene95Codec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat defaultDVFormat;
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        @Override
        public DocValuesFormat getDocValuesFormatForField(String field) {
            return Lucene95Codec.this.getDocValuesFormatForField(field);
        }
    };
    private final KnnVectorsFormat defaultKnnVectorsFormat;
    private final KnnVectorsFormat knnVectorsFormat = new PerFieldKnnVectorsFormat(){

        @Override
        public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
            return Lucene95Codec.this.getKnnVectorsFormatForField(field);
        }
    };
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene95Codec() {
        this(Mode.BEST_SPEED);
    }

    public Lucene95Codec(Mode mode) {
        super("Lucene95");
        this.storedFieldsFormat = new Lucene90StoredFieldsFormat(Objects.requireNonNull(mode).storedMode);
        this.defaultPostingsFormat = new Lucene90PostingsFormat();
        this.defaultDVFormat = new Lucene90DocValuesFormat();
        this.defaultKnnVectorsFormat = new Lucene95HnswVectorsFormat();
    }

    @Override
    public final StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    @Override
    public final TermVectorsFormat termVectorsFormat() {
        return this.vectorsFormat;
    }

    @Override
    public final PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    @Override
    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    @Override
    public SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    @Override
    public final LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    @Override
    public final CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    @Override
    public final PointsFormat pointsFormat() {
        return new Lucene90PointsFormat();
    }

    @Override
    public KnnVectorsFormat knnVectorsFormat() {
        return this.knnVectorsFormat;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultPostingsFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        return this.defaultKnnVectorsFormat;
    }

    @Override
    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    @Override
    public final NormsFormat normsFormat() {
        return this.normsFormat;
    }

    public static enum Mode {
        BEST_SPEED(Lucene90StoredFieldsFormat.Mode.BEST_SPEED),
        BEST_COMPRESSION(Lucene90StoredFieldsFormat.Mode.BEST_COMPRESSION);

        private final Lucene90StoredFieldsFormat.Mode storedMode;

        private Mode(Lucene90StoredFieldsFormat.Mode storedMode) {
            this.storedMode = Objects.requireNonNull(storedMode);
        }
    }
}

