/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.codecs.lucene912;

import java.io.IOException;
import org.neo4j.shaded.lucene9.codecs.lucene912.ForUtil;
import org.neo4j.shaded.lucene9.codecs.lucene912.PForUtil;
import org.neo4j.shaded.lucene9.internal.vectorization.PostingDecodingUtil;
import org.neo4j.shaded.lucene9.store.DataOutput;
import org.neo4j.shaded.lucene9.store.IndexInput;
import org.neo4j.shaded.lucene9.util.packed.PackedInts;

public final class ForDeltaUtil {
    private static final int ONE_BLOCK_SIZE_FOURTH = 32;
    private static final int TWO_BLOCK_SIZE_FOURTHS = 64;
    private static final int THREE_BLOCK_SIZE_FOURTHS = 96;
    private static final int ONE_BLOCK_SIZE_EIGHT = 16;
    private static final int TWO_BLOCK_SIZE_EIGHTS = 32;
    private static final int THREE_BLOCK_SIZE_EIGHTS = 48;
    private static final int FOUR_BLOCK_SIZE_EIGHTS = 64;
    private static final int FIVE_BLOCK_SIZE_EIGHTS = 80;
    private static final int SIX_BLOCK_SIZE_EIGHTS = 96;
    private static final int SEVEN_BLOCK_SIZE_EIGHTS = 112;
    private static final long[] IDENTITY_PLUS_ONE = new long[128];
    private final long[] tmp = new long[64];

    private static void prefixSumOfOnes(long[] arr, long base) {
        System.arraycopy(IDENTITY_PLUS_ONE, 0, arr, 0, 128);
        int i = 0;
        while (i < 128) {
            int n = i++;
            arr[n] = arr[n] + base;
        }
    }

    private static void prefixSum8(long[] arr, long base) {
        ForDeltaUtil.innerPrefixSum8(arr);
        ForUtil.expand8(arr);
        long l0 = base;
        long l1 = l0 + arr[15];
        long l2 = l1 + arr[31];
        long l3 = l2 + arr[47];
        long l4 = l3 + arr[63];
        long l5 = l4 + arr[79];
        long l6 = l5 + arr[95];
        long l7 = l6 + arr[111];
        for (int i = 0; i < 16; ++i) {
            int n = i;
            arr[n] = arr[n] + l0;
            int n2 = 16 + i;
            arr[n2] = arr[n2] + l1;
            int n3 = 32 + i;
            arr[n3] = arr[n3] + l2;
            int n4 = 48 + i;
            arr[n4] = arr[n4] + l3;
            int n5 = 64 + i;
            arr[n5] = arr[n5] + l4;
            int n6 = 80 + i;
            arr[n6] = arr[n6] + l5;
            int n7 = 96 + i;
            arr[n7] = arr[n7] + l6;
            int n8 = 112 + i;
            arr[n8] = arr[n8] + l7;
        }
    }

    private static void prefixSum16(long[] arr, long base) {
        ForDeltaUtil.innerPrefixSum16(arr);
        ForUtil.expand16(arr);
        long l0 = base;
        long l1 = l0 + arr[31];
        long l2 = l1 + arr[63];
        long l3 = l2 + arr[95];
        for (int i = 0; i < 32; ++i) {
            int n = i;
            arr[n] = arr[n] + l0;
            int n2 = 32 + i;
            arr[n2] = arr[n2] + l1;
            int n3 = 64 + i;
            arr[n3] = arr[n3] + l2;
            int n4 = 96 + i;
            arr[n4] = arr[n4] + l3;
        }
    }

    private static void prefixSum32(long[] arr, long base) {
        arr[0] = arr[0] + (base << 32);
        ForDeltaUtil.innerPrefixSum32(arr);
        ForUtil.expand32(arr);
        long l = arr[63];
        int i = 64;
        while (i < 128) {
            int n = i++;
            arr[n] = arr[n] + l;
        }
    }

    private static void innerPrefixSum8(long[] arr) {
        arr[1] = arr[1] + arr[0];
        arr[2] = arr[2] + arr[1];
        arr[3] = arr[3] + arr[2];
        arr[4] = arr[4] + arr[3];
        arr[5] = arr[5] + arr[4];
        arr[6] = arr[6] + arr[5];
        arr[7] = arr[7] + arr[6];
        arr[8] = arr[8] + arr[7];
        arr[9] = arr[9] + arr[8];
        arr[10] = arr[10] + arr[9];
        arr[11] = arr[11] + arr[10];
        arr[12] = arr[12] + arr[11];
        arr[13] = arr[13] + arr[12];
        arr[14] = arr[14] + arr[13];
        arr[15] = arr[15] + arr[14];
    }

    private static void innerPrefixSum16(long[] arr) {
        arr[1] = arr[1] + arr[0];
        arr[2] = arr[2] + arr[1];
        arr[3] = arr[3] + arr[2];
        arr[4] = arr[4] + arr[3];
        arr[5] = arr[5] + arr[4];
        arr[6] = arr[6] + arr[5];
        arr[7] = arr[7] + arr[6];
        arr[8] = arr[8] + arr[7];
        arr[9] = arr[9] + arr[8];
        arr[10] = arr[10] + arr[9];
        arr[11] = arr[11] + arr[10];
        arr[12] = arr[12] + arr[11];
        arr[13] = arr[13] + arr[12];
        arr[14] = arr[14] + arr[13];
        arr[15] = arr[15] + arr[14];
        arr[16] = arr[16] + arr[15];
        arr[17] = arr[17] + arr[16];
        arr[18] = arr[18] + arr[17];
        arr[19] = arr[19] + arr[18];
        arr[20] = arr[20] + arr[19];
        arr[21] = arr[21] + arr[20];
        arr[22] = arr[22] + arr[21];
        arr[23] = arr[23] + arr[22];
        arr[24] = arr[24] + arr[23];
        arr[25] = arr[25] + arr[24];
        arr[26] = arr[26] + arr[25];
        arr[27] = arr[27] + arr[26];
        arr[28] = arr[28] + arr[27];
        arr[29] = arr[29] + arr[28];
        arr[30] = arr[30] + arr[29];
        arr[31] = arr[31] + arr[30];
    }

    private static void innerPrefixSum32(long[] arr) {
        arr[1] = arr[1] + arr[0];
        arr[2] = arr[2] + arr[1];
        arr[3] = arr[3] + arr[2];
        arr[4] = arr[4] + arr[3];
        arr[5] = arr[5] + arr[4];
        arr[6] = arr[6] + arr[5];
        arr[7] = arr[7] + arr[6];
        arr[8] = arr[8] + arr[7];
        arr[9] = arr[9] + arr[8];
        arr[10] = arr[10] + arr[9];
        arr[11] = arr[11] + arr[10];
        arr[12] = arr[12] + arr[11];
        arr[13] = arr[13] + arr[12];
        arr[14] = arr[14] + arr[13];
        arr[15] = arr[15] + arr[14];
        arr[16] = arr[16] + arr[15];
        arr[17] = arr[17] + arr[16];
        arr[18] = arr[18] + arr[17];
        arr[19] = arr[19] + arr[18];
        arr[20] = arr[20] + arr[19];
        arr[21] = arr[21] + arr[20];
        arr[22] = arr[22] + arr[21];
        arr[23] = arr[23] + arr[22];
        arr[24] = arr[24] + arr[23];
        arr[25] = arr[25] + arr[24];
        arr[26] = arr[26] + arr[25];
        arr[27] = arr[27] + arr[26];
        arr[28] = arr[28] + arr[27];
        arr[29] = arr[29] + arr[28];
        arr[30] = arr[30] + arr[29];
        arr[31] = arr[31] + arr[30];
        arr[32] = arr[32] + arr[31];
        arr[33] = arr[33] + arr[32];
        arr[34] = arr[34] + arr[33];
        arr[35] = arr[35] + arr[34];
        arr[36] = arr[36] + arr[35];
        arr[37] = arr[37] + arr[36];
        arr[38] = arr[38] + arr[37];
        arr[39] = arr[39] + arr[38];
        arr[40] = arr[40] + arr[39];
        arr[41] = arr[41] + arr[40];
        arr[42] = arr[42] + arr[41];
        arr[43] = arr[43] + arr[42];
        arr[44] = arr[44] + arr[43];
        arr[45] = arr[45] + arr[44];
        arr[46] = arr[46] + arr[45];
        arr[47] = arr[47] + arr[46];
        arr[48] = arr[48] + arr[47];
        arr[49] = arr[49] + arr[48];
        arr[50] = arr[50] + arr[49];
        arr[51] = arr[51] + arr[50];
        arr[52] = arr[52] + arr[51];
        arr[53] = arr[53] + arr[52];
        arr[54] = arr[54] + arr[53];
        arr[55] = arr[55] + arr[54];
        arr[56] = arr[56] + arr[55];
        arr[57] = arr[57] + arr[56];
        arr[58] = arr[58] + arr[57];
        arr[59] = arr[59] + arr[58];
        arr[60] = arr[60] + arr[59];
        arr[61] = arr[61] + arr[60];
        arr[62] = arr[62] + arr[61];
        arr[63] = arr[63] + arr[62];
    }

    void encodeDeltas(long[] longs, DataOutput out) throws IOException {
        if (longs[0] == 1L && PForUtil.allEqual(longs)) {
            out.writeByte((byte)0);
        } else {
            int primitiveSize;
            long or = 0L;
            for (long l : longs) {
                or |= l;
            }
            assert (or != 0L);
            int bitsPerValue = PackedInts.bitsRequired(or);
            out.writeByte((byte)bitsPerValue);
            if (bitsPerValue <= 4) {
                primitiveSize = 8;
                ForUtil.collapse8(longs);
            } else if (bitsPerValue <= 11) {
                primitiveSize = 16;
                ForUtil.collapse16(longs);
            } else {
                primitiveSize = 32;
                ForUtil.collapse32(longs);
            }
            ForUtil.encode(longs, bitsPerValue, primitiveSize, out, this.tmp);
        }
    }

    void decodeAndPrefixSum(PostingDecodingUtil pdu, long base, long[] longs) throws IOException {
        int bitsPerValue = Byte.toUnsignedInt(pdu.in.readByte());
        if (bitsPerValue == 0) {
            ForDeltaUtil.prefixSumOfOnes(longs, base);
        } else {
            this.decodeAndPrefixSum(bitsPerValue, pdu, base, longs);
        }
    }

    void skip(IndexInput in) throws IOException {
        int bitsPerValue = Byte.toUnsignedInt(in.readByte());
        in.skipBytes(ForUtil.numBytes(bitsPerValue));
    }

    void decodeAndPrefixSum(int bitsPerValue, PostingDecodingUtil pdu, long base, long[] longs) throws IOException {
        switch (bitsPerValue) {
            case 1: {
                ForUtil.decode1(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum8(longs, base);
                break;
            }
            case 2: {
                ForUtil.decode2(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum8(longs, base);
                break;
            }
            case 3: {
                ForUtil.decode3(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum8(longs, base);
                break;
            }
            case 4: {
                ForUtil.decode4(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum8(longs, base);
                break;
            }
            case 5: {
                ForDeltaUtil.decode5To16(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum16(longs, base);
                break;
            }
            case 6: {
                ForDeltaUtil.decode6To16(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum16(longs, base);
                break;
            }
            case 7: {
                ForDeltaUtil.decode7To16(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum16(longs, base);
                break;
            }
            case 8: {
                ForDeltaUtil.decode8To16(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum16(longs, base);
                break;
            }
            case 9: {
                ForUtil.decode9(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum16(longs, base);
                break;
            }
            case 10: {
                ForUtil.decode10(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum16(longs, base);
                break;
            }
            case 11: {
                ForUtil.decode11(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum16(longs, base);
                break;
            }
            case 12: {
                ForDeltaUtil.decode12To32(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 13: {
                ForDeltaUtil.decode13To32(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 14: {
                ForDeltaUtil.decode14To32(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 15: {
                ForDeltaUtil.decode15To32(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 16: {
                ForDeltaUtil.decode16To32(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 17: {
                ForUtil.decode17(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 18: {
                ForUtil.decode18(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 19: {
                ForUtil.decode19(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 20: {
                ForUtil.decode20(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 21: {
                ForUtil.decode21(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 22: {
                ForUtil.decode22(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 23: {
                ForUtil.decode23(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            case 24: {
                ForUtil.decode24(pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
                break;
            }
            default: {
                ForUtil.decodeSlow(bitsPerValue, pdu, this.tmp, longs);
                ForDeltaUtil.prefixSum32(longs, base);
            }
        }
    }

    private static void decode5To16(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(10, longs, 11, 5, ForUtil.MASK16_5, tmp, 0, ForUtil.MASK16_1);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 30;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 4;
            l0 |= tmp[tmpIdx + 1] << 3;
            l0 |= tmp[tmpIdx + 2] << 2;
            l0 |= tmp[tmpIdx + 3] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 4] << 0;
            ++iter;
            tmpIdx += 5;
            ++longsIdx;
        }
    }

    private static void decode6To16(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(12, longs, 10, 6, ForUtil.MASK16_6, tmp, 0, ForUtil.MASK16_4);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 24;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 2 & ForUtil.MASK16_2;
            long l1 = (tmp[tmpIdx + 1] & ForUtil.MASK16_2) << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            longsIdx += 2;
        }
    }

    private static void decode7To16(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(14, longs, 9, 7, ForUtil.MASK16_7, tmp, 0, ForUtil.MASK16_2);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 28;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 5;
            l0 |= tmp[tmpIdx + 1] << 3;
            l0 |= tmp[tmpIdx + 2] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 3] >>> 1 & ForUtil.MASK16_1;
            long l1 = (tmp[tmpIdx + 3] & ForUtil.MASK16_1) << 6;
            l1 |= tmp[tmpIdx + 4] << 4;
            l1 |= tmp[tmpIdx + 5] << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            longsIdx += 2;
        }
    }

    private static void decode8To16(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(16, longs, 8, 8, ForUtil.MASK16_8, longs, 16, ForUtil.MASK16_8);
    }

    private static void decode12To32(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(24, longs, 20, 12, ForUtil.MASK32_12, tmp, 0, ForUtil.MASK32_8);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 48;
        while (iter < 8) {
            long l0 = tmp[tmpIdx + 0] << 4;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 4 & ForUtil.MASK32_4;
            long l1 = (tmp[tmpIdx + 1] & ForUtil.MASK32_4) << 8;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            longsIdx += 2;
        }
    }

    private static void decode13To32(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(26, longs, 19, 13, ForUtil.MASK32_13, tmp, 0, ForUtil.MASK32_6);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 52;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 7;
            l0 |= tmp[tmpIdx + 1] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 5 & ForUtil.MASK32_1;
            long l1 = (tmp[tmpIdx + 2] & ForUtil.MASK32_5) << 8;
            l1 |= tmp[tmpIdx + 3] << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 4 & ForUtil.MASK32_2;
            long l2 = (tmp[tmpIdx + 4] & ForUtil.MASK32_4) << 9;
            l2 |= tmp[tmpIdx + 5] << 3;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 3 & ForUtil.MASK32_3;
            long l3 = (tmp[tmpIdx + 6] & ForUtil.MASK32_3) << 10;
            l3 |= tmp[tmpIdx + 7] << 4;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 2 & ForUtil.MASK32_4;
            long l4 = (tmp[tmpIdx + 8] & ForUtil.MASK32_2) << 11;
            l4 |= tmp[tmpIdx + 9] << 5;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 10] >>> 1 & ForUtil.MASK32_5;
            long l5 = (tmp[tmpIdx + 10] & ForUtil.MASK32_1) << 12;
            l5 |= tmp[tmpIdx + 11] << 6;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 12] << 0;
            ++iter;
            tmpIdx += 13;
            longsIdx += 6;
        }
    }

    private static void decode14To32(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(28, longs, 18, 14, ForUtil.MASK32_14, tmp, 0, ForUtil.MASK32_4);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 56;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 10;
            l0 |= tmp[tmpIdx + 1] << 6;
            l0 |= tmp[tmpIdx + 2] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 3] >>> 2 & ForUtil.MASK32_2;
            long l1 = (tmp[tmpIdx + 3] & ForUtil.MASK32_2) << 12;
            l1 |= tmp[tmpIdx + 4] << 8;
            l1 |= tmp[tmpIdx + 5] << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            longsIdx += 2;
        }
    }

    private static void decode15To32(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(30, longs, 17, 15, ForUtil.MASK32_15, tmp, 0, ForUtil.MASK32_2);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 60;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 13;
            l0 |= tmp[tmpIdx + 1] << 11;
            l0 |= tmp[tmpIdx + 2] << 9;
            l0 |= tmp[tmpIdx + 3] << 7;
            l0 |= tmp[tmpIdx + 4] << 5;
            l0 |= tmp[tmpIdx + 5] << 3;
            l0 |= tmp[tmpIdx + 6] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 7] >>> 1 & ForUtil.MASK32_1;
            long l1 = (tmp[tmpIdx + 7] & ForUtil.MASK32_1) << 14;
            l1 |= tmp[tmpIdx + 8] << 12;
            l1 |= tmp[tmpIdx + 9] << 10;
            l1 |= tmp[tmpIdx + 10] << 8;
            l1 |= tmp[tmpIdx + 11] << 6;
            l1 |= tmp[tmpIdx + 12] << 4;
            l1 |= tmp[tmpIdx + 13] << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 14] << 0;
            ++iter;
            tmpIdx += 15;
            longsIdx += 2;
        }
    }

    private static void decode16To32(PostingDecodingUtil pdu, long[] tmp, long[] longs) throws IOException {
        pdu.splitLongs(32, longs, 16, 16, ForUtil.MASK32_16, longs, 32, ForUtil.MASK32_16);
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ForDeltaUtil.IDENTITY_PLUS_ONE[i] = i + 1;
        }
    }
}

