/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.codecs.lucene912;

import java.io.IOException;
import org.neo4j.shaded.lucene9.codecs.lucene912.ForDeltaUtil;
import org.neo4j.shaded.lucene9.codecs.lucene912.ForUtil;
import org.neo4j.shaded.lucene9.internal.vectorization.PostingDecodingUtil;
import org.neo4j.shaded.lucene9.internal.vectorization.VectorizationProvider;
import org.neo4j.shaded.lucene9.store.IndexInput;

public final class PostingIndexInput {
    private static final VectorizationProvider VECTORIZATION_PROVIDER = VectorizationProvider.getInstance();
    public final ForUtil forUtil;
    public final ForDeltaUtil forDeltaUtil;
    private final PostingDecodingUtil postingDecodingUtil;

    public PostingIndexInput(IndexInput in, ForUtil forUtil, ForDeltaUtil forDeltaUtil) throws IOException {
        this.forUtil = forUtil;
        this.forDeltaUtil = forDeltaUtil;
        this.postingDecodingUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(in);
    }

    public void decode(int bitsPerValue, long[] longs) throws IOException {
        this.forUtil.decode(bitsPerValue, this.postingDecodingUtil, longs);
    }

    public void decodeAndPrefixSum(int bitsPerValue, long base, long[] longs) throws IOException {
        this.forDeltaUtil.decodeAndPrefixSum(bitsPerValue, this.postingDecodingUtil, base, longs);
    }
}

