/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import org.neo4j.shaded.lucene9.document.Field;
import org.neo4j.shaded.lucene9.document.FieldType;
import org.neo4j.shaded.lucene9.document.XYDocValuesPointInGeometryQuery;
import org.neo4j.shaded.lucene9.document.XYPointSortField;
import org.neo4j.shaded.lucene9.geo.XYCircle;
import org.neo4j.shaded.lucene9.geo.XYEncodingUtils;
import org.neo4j.shaded.lucene9.geo.XYGeometry;
import org.neo4j.shaded.lucene9.geo.XYPolygon;
import org.neo4j.shaded.lucene9.geo.XYRectangle;
import org.neo4j.shaded.lucene9.index.DocValuesType;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.SortField;

public class XYDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public XYDocValuesField(String name, float x, float y) {
        super(name, TYPE);
        this.setLocationValue(x, y);
    }

    public void setLocationValue(float x, float y) {
        int xEncoded = XYEncodingUtils.encode(x);
        int yEncoded = XYEncodingUtils.encode(y);
        this.fieldsData = (long)xEncoded << 32 | (long)yEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + fieldInfo.getDocValuesType() + " but this type has docValuesType=" + TYPE.docValuesType() + ", is the field really a XYDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(XYEncodingUtils.decode((int)(currentValue >> 32)));
        result.append(',');
        result.append(XYEncodingUtils.decode((int)(currentValue & 0xFFFFFFFFFFFFFFFFL)));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, float x, float y) {
        return new XYPointSortField(field, x, y);
    }

    public static Query newSlowBoxQuery(String field, float minX, float maxX, float minY, float maxY) {
        XYRectangle rectangle = new XYRectangle(minX, maxX, minY, maxY);
        return new XYDocValuesPointInGeometryQuery(field, rectangle);
    }

    public static Query newSlowDistanceQuery(String field, float x, float y, float radius) {
        XYCircle circle = new XYCircle(x, y, radius);
        return new XYDocValuesPointInGeometryQuery(field, circle);
    }

    public static Query newSlowPolygonQuery(String field, XYPolygon ... polygons) {
        return XYDocValuesField.newSlowGeometryQuery(field, polygons);
    }

    public static Query newSlowGeometryQuery(String field, XYGeometry ... geometries) {
        return new XYDocValuesPointInGeometryQuery(field, geometries);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

