/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.geo;

import org.neo4j.shaded.lucene9.geo.Component2D;
import org.neo4j.shaded.lucene9.geo.GeoUtils;
import org.neo4j.shaded.lucene9.geo.LatLonGeometry;
import org.neo4j.shaded.lucene9.geo.Polygon;
import org.neo4j.shaded.lucene9.geo.Rectangle2D;
import org.neo4j.shaded.lucene9.util.SloppyMath;

public class Rectangle
extends LatLonGeometry {
    public final double minLat;
    public final double minLon;
    public final double maxLat;
    public final double maxLon;
    public static final double AXISLAT_ERROR = Math.toDegrees(1.5696101447687296E-8);

    public Rectangle(double minLat, double maxLat, double minLon, double maxLon) {
        GeoUtils.checkLatitude(minLat);
        GeoUtils.checkLatitude(maxLat);
        GeoUtils.checkLongitude(minLon);
        GeoUtils.checkLongitude(maxLon);
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
        assert (maxLat >= minLat);
    }

    @Override
    protected Component2D toComponent2D() {
        return Rectangle2D.create(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Rectangle(lat=");
        b.append(this.minLat);
        b.append(" TO ");
        b.append(this.maxLat);
        b.append(" lon=");
        b.append(this.minLon);
        b.append(" TO ");
        b.append(this.maxLon);
        if (this.maxLon < this.minLon) {
            b.append(" [crosses dateline!]");
        }
        b.append(")");
        return b.toString();
    }

    public boolean crossesDateline() {
        return this.maxLon < this.minLon;
    }

    public static boolean containsPoint(double lat, double lon, double minLat, double maxLat, double minLon, double maxLon) {
        return lat >= minLat && lat <= maxLat && lon >= minLon && lon <= maxLon;
    }

    public static Rectangle fromPointDistance(double centerLat, double centerLon, double radiusMeters) {
        double maxLon;
        double minLon;
        GeoUtils.checkLatitude(centerLat);
        GeoUtils.checkLongitude(centerLon);
        double radLat = Math.toRadians(centerLat);
        double radLon = Math.toRadians(centerLon);
        double radDistance = (radiusMeters + 0.07) / 6371008.7714;
        double minLat = radLat - radDistance;
        double maxLat = radLat + radDistance;
        if (minLat > GeoUtils.MIN_LAT_RADIANS && maxLat < GeoUtils.MAX_LAT_RADIANS) {
            double deltaLon = SloppyMath.asin(GeoUtils.sloppySin(radDistance) / SloppyMath.cos(radLat));
            minLon = radLon - deltaLon;
            if (minLon < GeoUtils.MIN_LON_RADIANS) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > GeoUtils.MAX_LON_RADIANS) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, GeoUtils.MIN_LAT_RADIANS);
            maxLat = Math.min(maxLat, GeoUtils.MAX_LAT_RADIANS);
            minLon = GeoUtils.MIN_LON_RADIANS;
            maxLon = GeoUtils.MAX_LON_RADIANS;
        }
        return new Rectangle(Math.toDegrees(minLat), Math.toDegrees(maxLat), Math.toDegrees(minLon), Math.toDegrees(maxLon));
    }

    public static double axisLat(double centerLat, double radiusMeters) {
        double PIO2 = 1.5707963267948966;
        double l1 = Math.toRadians(centerLat);
        double r = (radiusMeters + 0.07) / 6371008.7714;
        if (Math.abs(l1) + r >= GeoUtils.MAX_LAT_RADIANS) {
            return centerLat >= 0.0 ? 90.0 : -90.0;
        }
        l1 = centerLat >= 0.0 ? 1.5707963267948966 - l1 : l1 + 1.5707963267948966;
        double l2 = Math.acos(Math.cos(l1) / Math.cos(r));
        assert (!Double.isNaN(l2));
        l2 = centerLat >= 0.0 ? 1.5707963267948966 - l2 : l2 - 1.5707963267948966;
        return Math.toDegrees(l2);
    }

    public static Rectangle fromPolygon(Polygon[] polygons) {
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < polygons.length; ++i) {
            minLat = Math.min(polygons[i].minLat, minLat);
            maxLat = Math.max(polygons[i].maxLat, maxLat);
            minLon = Math.min(polygons[i].minLon, minLon);
            maxLon = Math.max(polygons[i].maxLon, maxLon);
        }
        return new Rectangle(minLat, maxLat, minLon, maxLon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        if (Double.compare(rectangle.minLat, this.minLat) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minLon, this.minLon) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxLat, this.maxLat) != 0) {
            return false;
        }
        return Double.compare(rectangle.maxLon, this.maxLon) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minLat);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

