/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.util.List;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.ReaderUtil;
import org.neo4j.shaded.lucene9.util.Bits;

public final class MultiBits
implements Bits {
    private final Bits[] subs;
    private final int[] starts;
    private final boolean defaultValue;

    private MultiBits(Bits[] subs, int[] starts, boolean defaultValue) {
        assert (starts.length == 1 + subs.length);
        this.subs = subs;
        this.starts = starts;
        this.defaultValue = defaultValue;
    }

    public static Bits getLiveDocs(IndexReader reader) {
        if (reader.hasDeletions()) {
            List<LeafReaderContext> leaves = reader.leaves();
            int size = leaves.size();
            assert (size > 0) : "A reader with deletions must have at least one leave";
            if (size == 1) {
                return leaves.get(0).reader().getLiveDocs();
            }
            Bits[] liveDocs = new Bits[size];
            int[] starts = new int[size + 1];
            for (int i = 0; i < size; ++i) {
                LeafReaderContext ctx = leaves.get(i);
                liveDocs[i] = ctx.reader().getLiveDocs();
                starts[i] = ctx.docBase;
            }
            starts[size] = reader.maxDoc();
            return new MultiBits(liveDocs, starts, true);
        }
        return null;
    }

    private boolean checkLength(int reader, int doc) {
        int length = this.starts[1 + reader] - this.starts[reader];
        assert (doc - this.starts[reader] < length) : "doc=" + doc + " reader=" + reader + " starts[reader]=" + this.starts[reader] + " length=" + length;
        return true;
    }

    @Override
    public boolean get(int doc) {
        int reader = ReaderUtil.subIndex(doc, this.starts);
        assert (reader != -1);
        Bits bits = this.subs[reader];
        if (bits == null) {
            return this.defaultValue;
        }
        assert (this.checkLength(reader, doc));
        return bits.get(doc - this.starts[reader]);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.subs.length).append(" subs: ");
        for (int i = 0; i < this.subs.length; ++i) {
            if (i != 0) {
                b.append("; ");
            }
            if (this.subs[i] == null) {
                b.append("s=").append(this.starts[i]).append(" l=null");
                continue;
            }
            b.append("s=").append(this.starts[i]).append(" l=").append(this.subs[i].length()).append(" b=").append(this.subs[i]);
        }
        b.append(" end=").append(this.starts[this.subs.length]);
        return b.toString();
    }

    @Override
    public int length() {
        return this.starts[this.starts.length - 1];
    }
}

