/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.util.concurrent.TimeUnit;
import org.neo4j.shaded.lucene9.index.QueryTimeout;

public class QueryTimeoutImpl
implements QueryTimeout {
    private Long timeoutAt;

    public QueryTimeoutImpl(long timeAllowed) {
        if (timeAllowed < 0L) {
            timeAllowed = Long.MAX_VALUE;
        }
        this.timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAllowed, TimeUnit.MILLISECONDS);
    }

    public Long getTimeoutAt() {
        return this.timeoutAt;
    }

    @Override
    public boolean shouldExit() {
        return this.timeoutAt != null && System.nanoTime() - this.timeoutAt > 0L;
    }

    public void reset() {
        this.timeoutAt = null;
    }

    public String toString() {
        return "timeoutAt: " + this.timeoutAt + " (System.nanoTime(): " + System.nanoTime() + ")";
    }
}

