/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import org.neo4j.shaded.lucene9.index.BufferedUpdates;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.SegmentInfo;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.util.FixedBitSet;
import org.neo4j.shaded.lucene9.util.InfoStream;

public class SegmentWriteState {
    public final InfoStream infoStream;
    public final Directory directory;
    public final SegmentInfo segmentInfo;
    public final FieldInfos fieldInfos;
    public int delCountOnFlush;
    public int softDelCountOnFlush;
    public final BufferedUpdates segUpdates;
    public FixedBitSet liveDocs;
    public final String segmentSuffix;
    public final IOContext context;

    public SegmentWriteState(InfoStream infoStream, Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates segUpdates, IOContext context) {
        this(infoStream, directory, segmentInfo, fieldInfos, segUpdates, context, "");
    }

    public SegmentWriteState(InfoStream infoStream, Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates segUpdates, IOContext context, String segmentSuffix) {
        this.infoStream = infoStream;
        this.segUpdates = segUpdates;
        this.directory = directory;
        this.segmentInfo = segmentInfo;
        this.fieldInfos = fieldInfos;
        assert (this.assertSegmentSuffix(segmentSuffix));
        this.segmentSuffix = segmentSuffix;
        this.context = context;
    }

    public SegmentWriteState(SegmentWriteState state, String segmentSuffix) {
        this.infoStream = state.infoStream;
        this.directory = state.directory;
        this.segmentInfo = state.segmentInfo;
        this.fieldInfos = state.fieldInfos;
        this.context = state.context;
        this.segmentSuffix = segmentSuffix;
        this.segUpdates = state.segUpdates;
        this.delCountOnFlush = state.delCountOnFlush;
        this.liveDocs = state.liveDocs;
    }

    private boolean assertSegmentSuffix(String segmentSuffix) {
        assert (segmentSuffix != null);
        if (!segmentSuffix.isEmpty()) {
            int numParts = segmentSuffix.split("_").length;
            if (numParts == 2) {
                return true;
            }
            if (numParts == 1) {
                Long.parseLong(segmentSuffix, 36);
                return true;
            }
            return false;
        }
        return true;
    }
}

