/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.ext;

import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.queryparser.classic.ParseException;
import org.neo4j.shaded.lucene9.queryparser.classic.QueryParser;
import org.neo4j.shaded.lucene9.queryparser.ext.ExtensionQuery;
import org.neo4j.shaded.lucene9.queryparser.ext.Extensions;
import org.neo4j.shaded.lucene9.queryparser.ext.ParserExtension;
import org.neo4j.shaded.lucene9.search.Query;

public class ExtendableQueryParser
extends QueryParser {
    private final String defaultField;
    private final Extensions extensions;
    private static final Extensions DEFAULT_EXTENSION = new Extensions();

    public ExtendableQueryParser(String f, Analyzer a) {
        this(f, a, DEFAULT_EXTENSION);
    }

    public ExtendableQueryParser(String f, Analyzer a, Extensions ext) {
        super(f, a);
        this.defaultField = f;
        this.extensions = ext;
    }

    public char getExtensionFieldDelimiter() {
        return this.extensions.getExtensionFieldDelimiter();
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        Extensions.Pair<String, String> splitExtensionField = this.extensions.splitExtensionField(this.defaultField, field);
        ParserExtension extension = this.extensions.getExtension((String)splitExtensionField.cud);
        if (extension != null) {
            return extension.parse(new ExtensionQuery(this, (String)splitExtensionField.cur, queryText));
        }
        return super.getFieldQuery(field, queryText, quoted);
    }
}

