/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.config;

import java.text.NumberFormat;

public class PointsConfig {
    private NumberFormat format;
    private Class<? extends Number> type;

    public PointsConfig(NumberFormat format, Class<? extends Number> type) {
        this.setNumberFormat(format);
        this.setType(type);
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    public Class<? extends Number> getType() {
        return this.type;
    }

    public void setType(Class<? extends Number> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null!");
        }
        if (!(Integer.class.equals(type) || Long.class.equals(type) || Float.class.equals(type) || Double.class.equals(type))) {
            throw new IllegalArgumentException("unsupported numeric type: " + type);
        }
        this.type = type;
    }

    public void setNumberFormat(NumberFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null!");
        }
        this.format = format;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.format.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointsConfig other = (PointsConfig)obj;
        if (!this.format.equals(other.format)) {
            return false;
        }
        return this.type.equals(other.type);
    }
}

