/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.surround.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.queries.spans.SpanOrQuery;
import org.neo4j.shaded.lucene9.queries.spans.SpanQuery;
import org.neo4j.shaded.lucene9.queries.spans.SpanTermQuery;
import org.neo4j.shaded.lucene9.queryparser.surround.query.BasicQueryFactory;
import org.neo4j.shaded.lucene9.search.MatchNoDocsQuery;
import org.neo4j.shaded.lucene9.search.Query;

public class SpanNearClauseFactory {
    private IndexReader reader;
    private String fieldName;
    private HashMap<SpanQuery, Float> weightBySpanQuery;
    private BasicQueryFactory qf;

    public SpanNearClauseFactory(IndexReader reader, String fieldName, BasicQueryFactory qf) {
        this.reader = reader;
        this.fieldName = fieldName;
        this.weightBySpanQuery = new HashMap();
        this.qf = qf;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BasicQueryFactory getBasicQueryFactory() {
        return this.qf;
    }

    public int size() {
        return this.weightBySpanQuery.size();
    }

    public void clear() {
        this.weightBySpanQuery.clear();
    }

    protected void addSpanQueryWeighted(SpanQuery sq, float weight) {
        Float w = this.weightBySpanQuery.get(sq);
        w = w != null ? Float.valueOf(w.floatValue() + weight) : Float.valueOf(weight);
        this.weightBySpanQuery.put(sq, w);
    }

    public void addTermWeighted(Term t, float weight) throws IOException {
        SpanTermQuery stq = this.qf.newSpanTermQuery(t);
        this.addSpanQueryWeighted((SpanQuery)stq, weight);
    }

    public void addSpanQuery(Query q) {
        if (q.getClass() == MatchNoDocsQuery.class) {
            return;
        }
        if (!(q instanceof SpanQuery)) {
            throw new AssertionError((Object)("Expected SpanQuery: " + q.toString(this.getFieldName())));
        }
        float boost = 1.0f;
        this.addSpanQueryWeighted((SpanQuery)q, boost);
    }

    public SpanQuery makeSpanClause() {
        SpanQuery[] spanQueries = new SpanQuery[this.size()];
        Iterator<SpanQuery> sqi = this.weightBySpanQuery.keySet().iterator();
        int i = 0;
        while (sqi.hasNext()) {
            SpanQuery sq = sqi.next();
            spanQueries[i++] = sq;
        }
        if (spanQueries.length == 1) {
            return spanQueries[0];
        }
        return new SpanOrQuery(spanQueries);
    }
}

