/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.xml.builders;

import java.io.IOException;
import java.util.ArrayList;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.TermToBytesRefAttribute;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.queries.spans.SpanOrQuery;
import org.neo4j.shaded.lucene9.queries.spans.SpanQuery;
import org.neo4j.shaded.lucene9.queries.spans.SpanTermQuery;
import org.neo4j.shaded.lucene9.queryparser.xml.DOMUtils;
import org.neo4j.shaded.lucene9.queryparser.xml.ParserException;
import org.neo4j.shaded.lucene9.queryparser.xml.builders.SpanBuilderBase;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.w3c.dom.Element;

public class SpanOrTermsBuilder
extends SpanBuilderBase {
    private final Analyzer analyzer;

    public SpanOrTermsBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        SpanOrQuery spanOrQuery;
        block9: {
            String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
            String value = DOMUtils.getNonBlankTextOrFail(e);
            ArrayList<SpanTermQuery> clausesList = new ArrayList<SpanTermQuery>();
            TokenStream ts = this.analyzer.tokenStream(fieldName, value);
            try {
                TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
                ts.reset();
                while (ts.incrementToken()) {
                    SpanTermQuery stq = new SpanTermQuery(new Term(fieldName, BytesRef.deepCopyOf(termAtt.getBytesRef())));
                    clausesList.add(stq);
                }
                ts.end();
                spanOrQuery = new SpanOrQuery(clausesList.toArray(new SpanQuery[clausesList.size()]));
                if (ts == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new ParserException("IOException parsing value:" + value, ioe);
                }
            }
            ts.close();
        }
        return spanOrQuery;
    }
}

