/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.List;
import org.neo4j.shaded.lucene9.search.IndriDisjunctionScorer;
import org.neo4j.shaded.lucene9.search.IndriScorer;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.Weight;

public class IndriAndScorer
extends IndriDisjunctionScorer {
    protected IndriAndScorer(Weight weight, List<Scorer> subScorers, ScoreMode scoreMode, float boost) throws IOException {
        super(weight, subScorers, scoreMode, boost);
    }

    @Override
    public float score(List<Scorer> subScorers) throws IOException {
        int docId = this.docID();
        return this.scoreDoc(subScorers, docId);
    }

    @Override
    public float smoothingScore(List<Scorer> subScorers, int docId) throws IOException {
        return this.scoreDoc(subScorers, docId);
    }

    private float scoreDoc(List<Scorer> subScorers, int docId) throws IOException {
        double score = 0.0;
        double boostSum = 0.0;
        for (Scorer scorer : subScorers) {
            if (!(scorer instanceof IndriScorer)) continue;
            IndriScorer indriScorer = (IndriScorer)scorer;
            int scorerDocId = indriScorer.docID();
            double tempScore = 0.0;
            tempScore = docId == scorerDocId ? (double)indriScorer.score() : (double)indriScorer.smoothingScore(docId);
            score += (tempScore *= (double)indriScorer.getBoost());
            boostSum += (double)indriScorer.getBoost();
        }
        if (boostSum == 0.0) {
            return 0.0f;
        }
        return (float)(score / boostSum);
    }
}

