/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.List;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.PostingsEnum;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.TermStates;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.search.AbstractMultiTermQueryConstantScoreWrapper;
import org.neo4j.shaded.lucene9.search.ConstantScoreQuery;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.MultiTermQuery;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.TermQuery;
import org.neo4j.shaded.lucene9.search.Weight;
import org.neo4j.shaded.lucene9.util.DocIdSetBuilder;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends AbstractMultiTermQueryConstantScoreWrapper<Q> {
    MultiTermQueryConstantScoreWrapper(Q query) {
        super(query);
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new AbstractMultiTermQueryConstantScoreWrapper.RewritingWeight(this.query, boost, scoreMode, searcher){

            @Override
            protected AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator rewriteInner(LeafReaderContext context, int fieldDocCount, Terms terms, TermsEnum termsEnum, List<AbstractMultiTermQueryConstantScoreWrapper.TermAndState> collectedTerms) throws IOException {
                DocIdSetBuilder builder = new DocIdSetBuilder(context.reader().maxDoc(), terms);
                PostingsEnum docs = null;
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (AbstractMultiTermQueryConstantScoreWrapper.TermAndState t : collectedTerms) {
                        termsEnum2.seekExact(t.term, t.state);
                        docs = termsEnum2.postings(docs, 0);
                        builder.add(docs);
                    }
                }
                do {
                    docs = termsEnum.postings(docs, 0);
                    int docFreq = termsEnum.docFreq();
                    if (fieldDocCount == docFreq) {
                        TermStates termStates = new TermStates(searcher.getTopReaderContext());
                        termStates.register(termsEnum.termState(), context.ord, docFreq, termsEnum.totalTermFreq());
                        ConstantScoreQuery q = new ConstantScoreQuery(new TermQuery(new Term(MultiTermQueryConstantScoreWrapper.this.query.field, termsEnum.term()), termStates));
                        Weight weight = searcher.rewrite(q).createWeight(searcher, scoreMode, this.score());
                        return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(weight);
                    }
                    builder.add(docs);
                } while (termsEnum.next() != null);
                return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(builder.build().iterator());
            }
        };
    }
}

