/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.ImpactsDISI;
import org.neo4j.shaded.lucene9.search.LeafSimScorer;
import org.neo4j.shaded.lucene9.search.MaxScoreCache;
import org.neo4j.shaded.lucene9.search.PhraseMatcher;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.TwoPhaseIterator;
import org.neo4j.shaded.lucene9.search.Weight;

class PhraseScorer
extends Scorer {
    final DocIdSetIterator approximation;
    final ImpactsDISI impactsApproximation;
    final MaxScoreCache maxScoreCache;
    final PhraseMatcher matcher;
    final ScoreMode scoreMode;
    private final LeafSimScorer simScorer;
    final float matchCost;
    private float minCompetitiveScore = 0.0f;
    private float freq = 0.0f;

    PhraseScorer(Weight weight, PhraseMatcher matcher, ScoreMode scoreMode, LeafSimScorer simScorer) {
        super(weight);
        this.matcher = matcher;
        this.scoreMode = scoreMode;
        this.simScorer = simScorer;
        this.matchCost = matcher.getMatchCost();
        this.approximation = matcher.approximation();
        this.impactsApproximation = matcher.impactsApproximation();
        this.maxScoreCache = this.impactsApproximation.getMaxScoreCache();
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.approximation){

            @Override
            public boolean matches() throws IOException {
                PhraseScorer.this.matcher.reset();
                if (PhraseScorer.this.scoreMode == ScoreMode.TOP_SCORES && PhraseScorer.this.minCompetitiveScore > 0.0f) {
                    float maxFreq = PhraseScorer.this.matcher.maxFreq();
                    if (PhraseScorer.this.simScorer.score(PhraseScorer.this.docID(), maxFreq) < PhraseScorer.this.minCompetitiveScore) {
                        return false;
                    }
                }
                PhraseScorer.this.freq = 0.0f;
                return PhraseScorer.this.matcher.nextMatch();
            }

            @Override
            public float matchCost() {
                return PhraseScorer.this.matchCost;
            }
        };
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public float score() throws IOException {
        if (this.freq == 0.0f) {
            this.freq = this.matcher.sloppyWeight();
            while (this.matcher.nextMatch()) {
                this.freq += this.matcher.sloppyWeight();
            }
        }
        return this.simScorer.score(this.docID(), this.freq);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        this.minCompetitiveScore = minScore;
        this.impactsApproximation.setMinCompetitiveScore(minScore);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }

    public String toString() {
        return "PhraseScorer(" + this.weight + ")";
    }
}

