/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.CollectionTerminatedException;
import org.neo4j.shaded.lucene9.search.Collector;
import org.neo4j.shaded.lucene9.search.DocIdStream;
import org.neo4j.shaded.lucene9.search.LeafCollector;
import org.neo4j.shaded.lucene9.search.Scorable;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Weight;

public class TotalHitCountCollector
implements Collector {
    private Weight weight;
    private int totalHits;

    public int getTotalHits() {
        return this.totalHits;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        int leafCount;
        int n = leafCount = this.weight == null ? -1 : this.weight.count(context);
        if (leafCount != -1) {
            this.totalHits += leafCount;
            throw new CollectionTerminatedException();
        }
        return new LeafCollector(){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
            }

            @Override
            public void collect(int doc) throws IOException {
                ++TotalHitCountCollector.this.totalHits;
            }

            @Override
            public void collect(DocIdStream stream) throws IOException {
                TotalHitCountCollector.this.totalHits += stream.count();
            }
        };
    }
}

