/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.search.BooleanQuery;
import org.neo4j.shaded.lucene9.search.BoostQuery;
import org.neo4j.shaded.lucene9.search.ConstantScoreQuery;
import org.neo4j.shaded.lucene9.search.DisjunctionMaxQuery;
import org.neo4j.shaded.lucene9.search.FieldExistsQuery;
import org.neo4j.shaded.lucene9.search.MatchAllDocsQuery;
import org.neo4j.shaded.lucene9.search.MatchNoDocsQuery;
import org.neo4j.shaded.lucene9.search.MultiTermQuery;
import org.neo4j.shaded.lucene9.search.MultiTermQueryConstantScoreBlendedWrapper;
import org.neo4j.shaded.lucene9.search.MultiTermQueryConstantScoreWrapper;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryCachingPolicy;
import org.neo4j.shaded.lucene9.search.TermInSetQuery;
import org.neo4j.shaded.lucene9.search.TermQuery;
import org.neo4j.shaded.lucene9.util.FrequencyTrackingRingBuffer;

public class UsageTrackingQueryCachingPolicy
implements QueryCachingPolicy {
    private static final int SENTINEL = Integer.MIN_VALUE;
    private final FrequencyTrackingRingBuffer recentlyUsedFilters;

    private static boolean isPointQuery(Query query) {
        for (Class<?> clazz = query.getClass(); clazz != Query.class; clazz = clazz.getSuperclass()) {
            String simpleName = clazz.getSimpleName();
            if (!simpleName.startsWith("Point") || !simpleName.endsWith("Query")) continue;
            return true;
        }
        return false;
    }

    static boolean isCostly(Query query) {
        return query instanceof MultiTermQuery || query instanceof MultiTermQueryConstantScoreBlendedWrapper || query instanceof MultiTermQueryConstantScoreWrapper || query instanceof TermInSetQuery || UsageTrackingQueryCachingPolicy.isPointQuery(query);
    }

    private static boolean shouldNeverCache(Query query) {
        DisjunctionMaxQuery dmq;
        BooleanQuery bq;
        if (query instanceof TermQuery) {
            return true;
        }
        if (query instanceof FieldExistsQuery) {
            return true;
        }
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        if (query instanceof MatchNoDocsQuery) {
            return true;
        }
        if (query instanceof BooleanQuery && (bq = (BooleanQuery)query).clauses().isEmpty()) {
            return true;
        }
        return query instanceof DisjunctionMaxQuery && (dmq = (DisjunctionMaxQuery)query).getDisjuncts().isEmpty();
    }

    public UsageTrackingQueryCachingPolicy(int historySize) {
        this.recentlyUsedFilters = new FrequencyTrackingRingBuffer(historySize, Integer.MIN_VALUE);
    }

    public UsageTrackingQueryCachingPolicy() {
        this(256);
    }

    protected int minFrequencyToCache(Query query) {
        if (UsageTrackingQueryCachingPolicy.isCostly(query)) {
            return 2;
        }
        int minFrequency = 5;
        if (query instanceof BooleanQuery || query instanceof DisjunctionMaxQuery) {
            --minFrequency;
        }
        return minFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUse(Query query) {
        assert (!(query instanceof BoostQuery));
        assert (!(query instanceof ConstantScoreQuery));
        if (UsageTrackingQueryCachingPolicy.shouldNeverCache(query)) {
            return;
        }
        int hashCode = query.hashCode();
        UsageTrackingQueryCachingPolicy usageTrackingQueryCachingPolicy = this;
        synchronized (usageTrackingQueryCachingPolicy) {
            this.recentlyUsedFilters.add(hashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int frequency(Query query) {
        assert (!(query instanceof BoostQuery));
        assert (!(query instanceof ConstantScoreQuery));
        int hashCode = query.hashCode();
        UsageTrackingQueryCachingPolicy usageTrackingQueryCachingPolicy = this;
        synchronized (usageTrackingQueryCachingPolicy) {
            return this.recentlyUsedFilters.frequency(hashCode);
        }
    }

    @Override
    public boolean shouldCache(Query query) throws IOException {
        int minFrequency;
        if (UsageTrackingQueryCachingPolicy.shouldNeverCache(query)) {
            return false;
        }
        int frequency = this.frequency(query);
        return frequency >= (minFrequency = this.minFrequencyToCache(query));
    }
}

