/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search.similarities;

import org.neo4j.shaded.lucene9.search.CollectionStatistics;
import org.neo4j.shaded.lucene9.search.Explanation;
import org.neo4j.shaded.lucene9.search.TermStatistics;
import org.neo4j.shaded.lucene9.search.similarities.Similarity;

public class BooleanSimilarity
extends Similarity {
    @Override
    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return new BooleanWeight(boost);
    }

    private static class BooleanWeight
    extends Similarity.SimScorer {
        final float boost;

        BooleanWeight(float boost) {
            this.boost = boost;
        }

        @Override
        public float score(float freq, long norm) {
            return this.boost;
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            Explanation queryBoostExpl = Explanation.match((Number)Float.valueOf(this.boost), "boost, query boost", new Explanation[0]);
            return Explanation.match(queryBoostExpl.getValue(), "score(" + this.getClass().getSimpleName() + "), computed from:", queryBoostExpl);
        }
    }
}

