/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted;

import java.io.Serializable;
import org.neo4j.cypher.internal.physicalplanning.RefSlot;
import org.neo4j.cypher.internal.physicalplanning.SlotAllocation$;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.ResourceLinenumber;
import org.neo4j.cypher.internal.runtime.RuntimeMetadataValue;
import org.neo4j.cypher.internal.runtime.slotted.SlottedRow;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InternalException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.ModuleSerializationProxy;

public final class SlottedRow$
implements Serializable {
    public static final SlottedRow$ MODULE$ = new SlottedRow$();
    private static final long INSTANCE_SIZE = HeapEstimator.shallowSizeOfInstance(SlottedRow.class);

    public final long INSTANCE_SIZE() {
        return INSTANCE_SIZE;
    }

    public final boolean DEBUG() {
        return false;
    }

    public long getNodeId(ReadableRow row, int offset, boolean isReference) {
        if (isReference) {
            AnyValue anyValue = row.getRefAt(offset);
            if (anyValue instanceof VirtualNodeValue) {
                VirtualNodeValue virtualNodeValue = (VirtualNodeValue)anyValue;
                return virtualNodeValue.id();
            }
            Value value = Values.NO_VALUE;
            AnyValue anyValue2 = anyValue;
            if (!(value != null ? !value.equals(anyValue2) : anyValue2 != null)) {
                return -1L;
            }
            if (anyValue == null) {
                throw CypherTypeException.expectedNodeButGotNull();
            }
            if (anyValue instanceof Value) {
                Value value2 = (Value)anyValue;
                throw CypherTypeException.expectedANodeButGot((String)value2.prettyPrint(), (String)value2.getTypeName(), (String)CypherTypeValueMapper.valueType((AnyValue)value2));
            }
            throw CypherTypeException.expectedANodeButGot((String)String.valueOf(anyValue), (String)anyValue.getTypeName(), (String)CypherTypeValueMapper.valueType((AnyValue)anyValue));
        }
        return row.getLongAt(offset);
    }

    public Option<ResourceLinenumber> getLinenumber(ReadableRow row, SlotConfiguration slots) {
        Some some;
        RefSlot refSlot;
        Option option = slots.getMetaDataSlot(SlotAllocation$.MODULE$.LOAD_CSV_METADATA_KEY(), slots.getMetaDataSlot$default$2());
        if (option instanceof Some && (refSlot = (RefSlot)(some = (Some)option).value()) != null) {
            RuntimeMetadataValue runtimeMetadataValue;
            Measurable l;
            int offset = refSlot.offset();
            AnyValue anyValue = row.getRefAt(offset);
            if (anyValue instanceof RuntimeMetadataValue && (l = (runtimeMetadataValue = (RuntimeMetadataValue)anyValue).value()) instanceof ResourceLinenumber) {
                ResourceLinenumber resourceLinenumber = (ResourceLinenumber)l;
                return new Some((Object)resourceLinenumber);
            }
            Value value = Values.NO_VALUE;
            AnyValue anyValue2 = anyValue;
            if (!(value != null ? !value.equals(anyValue2) : anyValue2 != null)) {
                return None$.MODULE$;
            }
            if (anyValue == null) {
                return None$.MODULE$;
            }
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"Wrong type of linenumber");
        }
        return None$.MODULE$;
    }

    public SlottedRow apply(SlotConfiguration slots) {
        return new SlottedRow(slots);
    }

    public Option<SlotConfiguration> unapply(SlottedRow x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.slots());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SlottedRow$.class);
    }

    private SlottedRow$() {
    }
}

