/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.ASTCachedProperty;
import org.neo4j.cypher.internal.physicalplanning.LegacySlotView;
import org.neo4j.cypher.internal.physicalplanning.LongSlot;
import org.neo4j.cypher.internal.physicalplanning.RefSlot;
import org.neo4j.cypher.internal.physicalplanning.Slot;
import org.neo4j.cypher.internal.physicalplanning.SlotAccessor;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.physicalplanning.SlotConfigurationUtils$;
import org.neo4j.cypher.internal.physicalplanning.SlotType;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.EntityById;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.ResourceLinenumber;
import org.neo4j.cypher.internal.runtime.WritableRow;
import org.neo4j.cypher.internal.runtime.slotted.SlottedCompatible;
import org.neo4j.cypher.internal.runtime.slotted.SlottedRow$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.NullChecker$;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.exceptions.InternalException;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dr!\u0002(P\u0011\u0003af!\u00020P\u0011\u0003y\u0006\"\u00028\u0002\t\u0003y\u0007b\u00029\u0002\u0005\u0004%)!\u001d\u0005\u0007k\u0006\u0001\u000bQ\u0002:\t\u000fY\f!\u0019!C\u0003o\"1!0\u0001Q\u0001\u000eaDQa_\u0001\u0005\u0002qDq!a\u0007\u0002\t\u0003\ti\u0002C\u0005\u0002>\u0005\t\t\u0011\"!\u0002@!IA1C\u0001\u0002\u0002\u0013\u0005EQ\u0003\u0005\n\t;\t\u0011\u0011!C\u0005\t?1QAX(C\u0003\u0007B!\"a\f\r\u0005+\u0007I\u0011AA4\u0011)\tI\u0007\u0004B\tB\u0003%\u0011\u0011\u0007\u0005\u0007]2!\t!a\u001b\t\u0013\u0005=DB1A\u0005\u0002\u0005E\u0004\u0002CA=\u0019\u0001\u0006I!a\u001d\t\u0013\u0005mDB1A\u0005\u0002\u0005u\u0004\u0002CAG\u0019\u0001\u0006I!a \t\u000f\u0005=E\u0002\"\u0011\u0002\u0012\"9\u00111\u0015\u0007\u0005B\u0005\u0015\u0006bBAY\u0019\u0011\u0005\u00131\u0017\u0005\b\u0003\u007fcA\u0011IAa\u0011\u001d\t\t\u000e\u0004C!\u0003'Dq!!8\r\t\u0003\ty\u000eC\u0004\u0002l2!I!!<\t\u000f\u0005EH\u0002\"\u0011\u0002t\"9!q\u0001\u0007\u0005\n\t%\u0001b\u0002B\f\u0019\u0011\u0005#\u0011\u0004\u0005\b\u0005CaA\u0011\tB\u0012\u0011\u001d\u00119\u0003\u0004C!\u0005SAqAa\f\r\t\u0003\u0012\t\u0004C\u0004\u000361!\tEa\u000e\t\u000f\tuB\u0002\"\u0011\u0003@!9!\u0011\t\u0007\u0005B\t\r\u0003b\u0002B$\u0019\u0011\u0005#\u0011\n\u0005\b\u00057bA\u0011\tB/\u0011\u001d\u0011y\u0006\u0004C!\u0005CBqAa\u001a\r\t\u0003\u0012I\u0007C\u0004\u0003p1!\tE!\u001d\t\u000f\t5E\u0002\"\u0011\u0003\u0010\"9!1\u0013\u0007\u0005B\tU\u0005b\u0002BM\u0019\u0011\u0005#1\u0014\u0005\b\u0005;cA\u0011\tBP\u0011\u001d\u0011)\u000b\u0004C\u0005\u0005OCqAa,\r\t\u0003\u0012\t\fC\u0004\u0002\u001c1!\tEa.\t\u000f\teF\u0002\"\u0011\u0003<\"9!\u0011\u0018\u0007\u0005B\tM\u0007b\u0002B]\u0019\u0011\u0005#\u0011\u001c\u0005\b\u0005scA\u0011\tBv\u0011\u001d\u0011i\u0010\u0004C!\u0005\u007fDqA!@\r\t\u0003\u001a)\u0001C\u0004\u0003~2!\tea\u0004\t\u000f\tuH\u0002\"\u0011\u0004\u001e!91\u0011\u0005\u0007\u0005\u0002\r\r\u0002bBB\u0014\u0019\u0011\u00051\u0011\u0006\u0005\t\u0007[aA\u0011A(\u00040!A1Q\r\u0007\u0005\u0002=\u001b9\u0007C\u0004\u0004p1!Ia!\u001d\t\u000f\r=D\u0002\"\u0011\u0004|!I11\u0012\u0007\u0012\u0002\u0013\u00051Q\u0012\u0005\b\u0007GcA\u0011BBS\u0011\u001d\u0019\u0019\f\u0004C!\u0007kCqaa.\r\t\u0003\u001aI\fC\u0004\u0004>2!Iaa0\t\u000f\r\u001dG\u0002\"\u0011\u0003^!I1\u0011\u001a\u0007\u0002\u0002\u0013\u000511\u001a\u0005\n\u0007\u001fd\u0011\u0013!C\u0001\u0007#D\u0011b!6\r\u0003\u0003%\tea6\t\u0013\r\rH\"!A\u0005\u0002\t}\u0002\"CBs\u0019\u0005\u0005I\u0011ABt\u0011%\u0019\u0019\u0010DA\u0001\n\u0003\u001a)\u0010C\u0005\u0004|2\t\t\u0011\"\u0001\u0004~\"IA\u0011\u0001\u0007\u0002\u0002\u0013\u0005C1\u0001\u0005\n\t\u000fa\u0011\u0011!C!\t\u0013A\u0011\u0002b\u0003\r\u0003\u0003%\t\u0005\"\u0004\u0002\u0015Mcw\u000e\u001e;fIJ{wO\u0003\u0002Q#\u000691\u000f\\8ui\u0016$'B\u0001*T\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001V+\u0002\u0011%tG/\u001a:oC2T!AV,\u0002\r\rL\b\u000f[3s\u0015\tA\u0016,A\u0003oK>$$NC\u0001[\u0003\ry'oZ\u0002\u0001!\ti\u0016!D\u0001P\u0005)\u0019Fn\u001c;uK\u0012\u0014vn^\n\u0004\u0003\u00014\u0007CA1e\u001b\u0005\u0011'\"A2\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0014'AB!osJ+g\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006\u0011\u0011n\u001c\u0006\u0002W\u0006!!.\u0019<b\u0013\ti\u0007N\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u00029\u0006i\u0011JT*U\u0003:\u001bUiX*J5\u0016+\u0012A\u001d\t\u0003CNL!\u0001\u001e2\u0003\t1{gnZ\u0001\u000f\u0013:\u001bF+\u0011(D\u000b~\u001b\u0016JW#!\u0003\u0015!UIQ+H+\u0005Ax\"A=\u001a\u0003\u0001\ta\u0001R#C+\u001e\u0003\u0013!C4fi:{G-Z%e)\u0019\u0011X0a\u0002\u0002\u0012!)ap\u0002a\u0001\u007f\u0006\u0019!o\\<\u0011\t\u0005\u0005\u00111A\u0007\u0002#&\u0019\u0011QA)\u0003\u0017I+\u0017\rZ1cY\u0016\u0014vn\u001e\u0005\b\u0003\u00139\u0001\u0019AA\u0006\u0003\u0019ygMZ:fiB\u0019\u0011-!\u0004\n\u0007\u0005=!MA\u0002J]RDq!a\u0005\b\u0001\u0004\t)\"A\u0006jgJ+g-\u001a:f]\u000e,\u0007cA1\u0002\u0018%\u0019\u0011\u0011\u00042\u0003\u000f\t{w\u000e\\3b]\u0006iq-\u001a;MS:,g.^7cKJ$b!a\b\u0002,\u00055\u0002#B1\u0002\"\u0005\u0015\u0012bAA\u0012E\n1q\n\u001d;j_:\u0004B!!\u0001\u0002(%\u0019\u0011\u0011F)\u0003%I+7o\\;sG\u0016d\u0015N\\3ok6\u0014WM\u001d\u0005\u0006}\"\u0001\ra \u0005\b\u0003_A\u0001\u0019AA\u0019\u0003\u0015\u0019Hn\u001c;t!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c'\u0006\u0001\u0002\u000f[=tS\u000e\fG\u000e\u001d7b]:LgnZ\u0005\u0005\u0003w\t)DA\tTY>$8i\u001c8gS\u001e,(/\u0019;j_:\fQ!\u00199qYf$B!!\u0011\u0005\u0012A\u0011Q\fD\n\t\u0019\u0001\f)%a\u0013\u0002RA!\u0011\u0011AA$\u0013\r\tI%\u0015\u0002\n\u0007f\u0004\b.\u001a:S_^\u00042!YA'\u0013\r\tyE\u0019\u0002\b!J|G-^2u!\u0011\t\u0019&a\u0019\u000f\t\u0005U\u0013q\f\b\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111L.\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0017bAA1E\u00069\u0001/Y2lC\u001e,\u0017bA7\u0002f)\u0019\u0011\u0011\r2\u0016\u0005\u0005E\u0012AB:m_R\u001c\b\u0005\u0006\u0003\u0002B\u00055\u0004bBA\u0018\u001f\u0001\u0007\u0011\u0011G\u0001\u0006Y>twm]\u000b\u0003\u0003g\u0002B!YA;e&\u0019\u0011q\u000f2\u0003\u000b\u0005\u0013(/Y=\u0002\r1|gnZ:!\u0003\u0011\u0011XMZ:\u0016\u0005\u0005}\u0004#B1\u0002v\u0005\u0005\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001du+\u0001\u0004wC2,Xm]\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005B]f4\u0016\r\\;f\u0003\u0015\u0011XMZ:!\u0003!!xn\u0015;sS:<GCAAJ!\u0011\t)*!(\u000f\t\u0005]\u0015\u0011\u0014\t\u0004\u0003/\u0012\u0017bAANE\u00061\u0001K]3eK\u001aLA!a(\u0002\"\n11\u000b\u001e:j]\u001eT1!a'c\u0003-\u0019w\u000e]=BY24%o\\7\u0015\t\u0005\u001d\u0016Q\u0016\t\u0004C\u0006%\u0016bAAVE\n!QK\\5u\u0011\u0019\ty+\u0006a\u0001\u007f\u0006)\u0011N\u001c9vi\u0006A1m\u001c9z\rJ|W\u000e\u0006\u0005\u0002(\u0006U\u0016qWA^\u0011\u0019\tyK\u0006a\u0001\u007f\"9\u0011\u0011\u0018\fA\u0002\u0005-\u0011A\u00028M_:<7\u000fC\u0004\u0002>Z\u0001\r!a\u0003\u0002\u000b9\u0014VMZ:\u0002\u001b\r|\u0007/\u001f'p]\u001e\u001chI]8n))\t9+a1\u0002F\u0006%\u0017Q\u001a\u0005\u0007\u0003_;\u0002\u0019A@\t\u000f\u0005\u001dw\u00031\u0001\u0002\f\u0005QaM]8n\u001f\u001a47/\u001a;\t\u000f\u0005-w\u00031\u0001\u0002\f\u0005AAo\\(gMN,G\u000fC\u0004\u0002P^\u0001\r!a\u0003\u0002\r1,gn\u001a;i\u00031\u0019w\u000e]=SK\u001a\u001chI]8n))\t9+!6\u0002X\u0006e\u00171\u001c\u0005\u0007\u0003_C\u0002\u0019A@\t\u000f\u0005\u001d\u0007\u00041\u0001\u0002\f!9\u00111\u001a\rA\u0002\u0005-\u0001bBAh1\u0001\u0007\u00111B\u0001\u000bG>\u0004\u00180T1qa\u0016$G\u0003BA#\u0003CDq!a9\u001a\u0001\u0004\t)/\u0001\u0003gk:\u001c\u0007cB1\u0002h\u0006\u0005\u0015\u0011Q\u0005\u0004\u0003S\u0014'!\u0003$v]\u000e$\u0018n\u001c82\u00035!(/\u00198tM>\u0014XNU3ggR!\u0011qUAx\u0011\u001d\t\u0019O\u0007a\u0001\u0003K\fabY8qs\u001a\u0013x.\\(gMN,G\u000f\u0006\u0007\u0002(\u0006U\u0018q_A~\u0003\u007f\u0014\u0019\u0001\u0003\u0004\u00020n\u0001\ra \u0005\b\u0003s\\\u0002\u0019AA\u0006\u0003A\u0019x.\u001e:dK2{gnZ(gMN,G\u000fC\u0004\u0002~n\u0001\r!a\u0003\u0002\u001fM|WO]2f%\u00164wJ\u001a4tKRDqA!\u0001\u001c\u0001\u0004\tY!\u0001\tuCJ<W\r\u001e'p]\u001e|eMZ:fi\"9!QA\u000eA\u0002\u0005-\u0011a\u0004;be\u001e,GOU3g\u001f\u001a47/\u001a;\u0002\u001f\r|\u0007/\u001f$s_6\u001cFn\u001c;uK\u0012$B\"a*\u0003\f\t=!\u0011\u0003B\n\u0005+AqA!\u0004\u001d\u0001\u0004\t\t%A\u0003pi\",'\u000fC\u0004\u0002zr\u0001\r!a\u0003\t\u000f\u0005uH\u00041\u0001\u0002\f!9!\u0011\u0001\u000fA\u0002\u0005-\u0001b\u0002B\u00039\u0001\u0007\u00111B\u0001\ng\u0016$Hj\u001c8h\u0003R$b!a*\u0003\u001c\tu\u0001bBA\u0005;\u0001\u0007\u00111\u0002\u0005\u0007\u0005?i\u0002\u0019\u0001:\u0002\u000bY\fG.^3\u0002\u0013\u001d,G\u000fT8oO\u0006#Hc\u0001:\u0003&!9\u0011\u0011\u0002\u0010A\u0002\u0005-\u0011\u0001C:fiJ+g-\u0011;\u0015\r\u0005\u001d&1\u0006B\u0017\u0011\u001d\tIa\ba\u0001\u0003\u0017AqAa\b \u0001\u0004\t\t)\u0001\u0005hKR\u0014VMZ!u)\u0011\t\tIa\r\t\u000f\u0005%\u0001\u00051\u0001\u0002\f\u0005Iq-\u001a;Cs:\u000bW.\u001a\u000b\u0005\u0003\u0003\u0013I\u0004C\u0004\u0003<\u0005\u0002\r!a%\u0002\t9\fW.Z\u0001\u0010]Vl'-\u001a:PM\u000e{G.^7ogV\u0011\u00111B\u0001\rG>tG/Y5og:\u000bW.\u001a\u000b\u0005\u0003+\u0011)\u0005C\u0004\u0003<\r\u0002\r!a%\u0002'M,GoQ1dQ\u0016$\u0007K]8qKJ$\u00180\u0011;\u0015\r\u0005\u001d&1\nB'\u0011\u001d\tI\u0001\na\u0001\u0003\u0017AqAa\b%\u0001\u0004\u0011y\u0005\u0005\u0003\u0003R\t]SB\u0001B*\u0015\u0011\u0011)&!\"\u0002\u0011M$xN]1cY\u0016LAA!\u0017\u0003T\t)a+\u00197vK\u0006Q\u0012N\u001c<bY&$\u0017\r^3DC\u000eDW\r\u001a)s_B,'\u000f^5fgR\u0011\u0011qU\u0001\u001fS:4\u0018\r\\5eCR,7)Y2iK\u0012tu\u000eZ3Qe>\u0004XM\u001d;jKN$B!a*\u0003d!1!Q\r\u0014A\u0002I\fAA\\8eK\u00061\u0013N\u001c<bY&$\u0017\r^3DC\u000eDW\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004\bK]8qKJ$\u0018.Z:\u0015\t\u0005\u001d&1\u000e\u0005\u0007\u0005[:\u0003\u0019\u0001:\u0002\u0007I,G.A\ttKR\u001c\u0015m\u00195fIB\u0013x\u000e]3sif$b!a*\u0003t\t-\u0005b\u0002B;Q\u0001\u0007!qO\u0001\u0004W\u0016L\b\u0003\u0002B=\u0005\u000bsAAa\u001f\u0003\u00026\u0011!Q\u0010\u0006\u0004\u0005\u007f\u001a\u0016aC3yaJ,7o]5p]NLAAa!\u0003~\u0005\t\u0012i\u0015+DC\u000eDW\r\u001a)s_B,'\u000f^=\n\t\t\u001d%\u0011\u0012\u0002\u000b%VtG/[7f\u0017\u0016L(\u0002\u0002BB\u0005{BqAa\b)\u0001\u0004\u0011y%A\nhKR\u001c\u0015m\u00195fIB\u0013x\u000e]3sif\fE\u000f\u0006\u0003\u0003P\tE\u0005bBA\u0005S\u0001\u0007\u00111B\u0001\u0012O\u0016$8)Y2iK\u0012\u0004&o\u001c9feRLH\u0003\u0002B(\u0005/CqA!\u001e+\u0001\u0004\u00119(\u0001\nfgRLW.\u0019;fI\"+\u0017\r]+tC\u001e,G#\u0001:\u0002=\u0011,G-\u001e9mS\u000e\fG/\u001a3FgRLW.\u0019;fI\"+\u0017\r]+tC\u001e,Gc\u0001:\u0003\"\"9!1\u0015\u0017A\u0002\u0005\u0015\u0013\u0001\u00039sKZLw.^:\u0002\t\u0019\f\u0017\u000e\u001c\u000b\u0003\u0005S\u00032!\u0019BV\u0013\r\u0011iK\u0019\u0002\b\u001d>$\b.\u001b8h\u00035\u0019X\r\u001e'j]\u0016tW/\u001c2feR!\u0011q\u0015BZ\u0011\u001d\u0011)L\fa\u0001\u0003?\tA\u0001\\5oKV\u0011\u0011qD\u0001\u0004g\u0016$H\u0003BAT\u0005{CqAa01\u0001\u0004\u0011\t-\u0001\u0006oK^,e\u000e\u001e:jKN\u0004bAa1\u0003J\n5WB\u0001Bc\u0015\r\u00119MY\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bf\u0005\u000b\u00141aU3r!\u001d\t'qZAJ\u0003\u0003K1A!5c\u0005\u0019!V\u000f\u001d7feQ1\u0011q\u0015Bk\u0005/DqA!\u001e2\u0001\u0004\t\u0019\nC\u0004\u0003 E\u0002\r!!!\u0015\u0015\u0005\u001d&1\u001cBp\u0005G\u00149\u000fC\u0004\u0003^J\u0002\r!a%\u0002\t-,\u00170\r\u0005\b\u0005C\u0014\u0004\u0019AAA\u0003\u00191\u0018\r\\;fc!9!Q\u001d\u001aA\u0002\u0005M\u0015\u0001B6fsJBqA!;3\u0001\u0004\t\t)\u0001\u0004wC2,XM\r\u000b\u000f\u0003O\u0013iOa<\u0003r\nM(Q\u001fB}\u0011\u001d\u0011in\ra\u0001\u0003'CqA!94\u0001\u0004\t\t\tC\u0004\u0003fN\u0002\r!a%\t\u000f\t%8\u00071\u0001\u0002\u0002\"9!q_\u001aA\u0002\u0005M\u0015\u0001B6fsNBqAa?4\u0001\u0004\t\t)\u0001\u0004wC2,XmM\u0001\tG>\u0004\u0018pV5uQR1\u0011QIB\u0001\u0007\u0007AqA!85\u0001\u0004\t\u0019\nC\u0004\u0003bR\u0002\r!!!\u0015\u0015\u0005\u00153qAB\u0005\u0007\u0017\u0019i\u0001C\u0004\u0003^V\u0002\r!a%\t\u000f\t\u0005X\u00071\u0001\u0002\u0002\"9!Q]\u001bA\u0002\u0005M\u0005b\u0002Buk\u0001\u0007\u0011\u0011\u0011\u000b\u000f\u0003\u000b\u001a\tba\u0005\u0004\u0016\r]1\u0011DB\u000e\u0011\u001d\u0011iN\u000ea\u0001\u0003'CqA!97\u0001\u0004\t\t\tC\u0004\u0003fZ\u0002\r!a%\t\u000f\t%h\u00071\u0001\u0002\u0002\"9!q\u001f\u001cA\u0002\u0005M\u0005b\u0002B~m\u0001\u0007\u0011\u0011\u0011\u000b\u0005\u0003\u000b\u001ay\u0002C\u0004\u0003@^\u0002\rA!1\u0002!%\u001c(+\u001a4J]&$\u0018.\u00197ju\u0016$G\u0003BA\u000b\u0007KAq!!\u00039\u0001\u0004\tY!\u0001\u0012hKR\u0014VMZ!u/&$\bn\\;u\u0007\",7m[5oO&s\u0017\u000e^5bY&TX\r\u001a\u000b\u0005\u0003\u0003\u001bY\u0003C\u0004\u0002\ne\u0002\r!a\u0003\u0002!M,G\u000f\u0015:j[&$\u0018N^3O_\u0012,GCBAT\u0007c\u0019)\u0006C\u0004\u0003vi\u0002\raa\r\u0011\t\rU2q\n\b\u0005\u0007o\u0019YE\u0004\u0003\u0004:\r%c\u0002BB\u001e\u0007\u000frAa!\u0010\u0004F9!1qHB\"\u001d\u0011\t9f!\u0011\n\u0003iK!\u0001W-\n\u0005Y;\u0016B\u0001+V\u0013\r\t9dU\u0005\u0005\u0007\u001b\n)$A\tTY>$8i\u001c8gS\u001e,(/\u0019;j_:LAa!\u0015\u0004T\t91\u000b\\8u\u0017\u0016L(\u0002BB'\u0003kAaAa\b;\u0001\u0004\u0011\bf\u0001\u001e\u0004ZA!11LB1\u001b\t\u0019iFC\u0002\u0004`]\u000bA!\u001e;jY&!11MB/\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0010g\u0016$\bK]5nSRLg/\u001a*fYR1\u0011qUB5\u0007WBqA!\u001e<\u0001\u0004\u0019\u0019\u0004\u0003\u0004\u0003 m\u0002\rA\u001d\u0015\u0004w\re\u0013!C7fe\u001e,w+\u001b;i)\u0019\t9ka\u001d\u0004x!91Q\u000f\u001fA\u0002\u0005\u0005\u0013\u0001C8uQ\u0016\u0014(k\\<\t\u000f\reD\b1\u0001\u0002\u0016\u0005Ia.\u001e7m\u0007\",7m\u001b\u000b\t\u0003O\u001biha \u0004\n\"1!QB\u001fA\u0002}Dqa!!>\u0001\u0004\u0019\u0019)\u0001\u0006f]RLG/\u001f\"z\u0013\u0012\u0004B!!\u0001\u0004\u0006&\u00191qQ)\u0003\u0015\u0015sG/\u001b;z\u0005fLE\rC\u0005\u0004zu\u0002\n\u00111\u0001\u0002\u0016\u0005\u0019R.\u001a:hK^KG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\u0012\u0016\u0005\u0003+\u0019\tj\u000b\u0002\u0004\u0014B!1QSBP\u001b\t\u00199J\u0003\u0003\u0004\u001a\u000em\u0015!C;oG\",7m[3e\u0015\r\u0019iJY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBQ\u0007/\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m\u0019\u0007.Z2l\u0007>l\u0007/\u0019;jE2,g*\u001e7mC\nd\u0017\u000e\\5usR1\u0011QCBT\u0007SCqA!\u001e@\u0001\u0004\u0019\u0019\u0004C\u0004\u0004,~\u0002\ra!,\u0002\u0013=$\b.\u001a:TY>$\b\u0003BB\u001b\u0007_KAa!-\u0004T\tI1*Z=fINcw\u000e^\u0001\fGJ,\u0017\r^3DY>tW\r\u0006\u0002\u0002F\u00051\u0011n\u001d(vY2$B!!\u0006\u0004<\"9!QO!A\u0002\u0005M\u0015\u0001C5uKJ\fGo\u001c:\u0016\u0005\r\u0005\u0007CBA*\u0007\u0007\u0014i-\u0003\u0003\u0004F\u0006\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u000f\r|W\u000e]1di\u0006!1m\u001c9z)\u0011\t\te!4\t\u0013\u0005=B\t%AA\u0002\u0005E\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0007'TC!!\r\u0004\u0012\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"a!7\u0011\t\rm7\u0011]\u0007\u0003\u0007;T1aa8k\u0003\u0011a\u0017M\\4\n\t\u0005}5Q\\\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019Ioa<\u0011\u0007\u0005\u001cY/C\u0002\u0004n\n\u00141!\u00118z\u0011%\u0019\t\u0010SA\u0001\u0002\u0004\tY!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007o\u0004bAa1\u0004z\u000e%\u0018\u0002BBc\u0005\u000b\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003+\u0019y\u0010C\u0005\u0004r*\u000b\t\u00111\u0001\u0004j\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0019I\u000e\"\u0002\t\u0013\rE8*!AA\u0002\u0005-\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005-\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0016\u0011=\u0001\"CBy\u001b\u0006\u0005\t\u0019ABu\u0011\u001d\ty#\u0003a\u0001\u0003c\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0005\u0018\u0011e\u0001#B1\u0002\"\u0005E\u0002\"\u0003C\u000e\u0015\u0005\u0005\t\u0019AA!\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\tC\u0001Baa7\u0005$%!AQEBo\u0005\u0019y%M[3di\u0002")
public final class SlottedRow
implements CypherRow,
Product,
Serializable {
    private final SlotConfiguration slots;
    private final long[] longs;
    private final AnyValue[] refs;

    public static Option<SlotConfiguration> unapply(SlottedRow x$0) {
        return SlottedRow$.MODULE$.unapply(x$0);
    }

    public static SlottedRow apply(SlotConfiguration slots) {
        return SlottedRow$.MODULE$.apply(slots);
    }

    public static long getNodeId(ReadableRow row, int offset, boolean isReference) {
        return SlottedRow$.MODULE$.getNodeId(row, offset, isReference);
    }

    public static boolean DEBUG() {
        return SlottedRow$.MODULE$.DEBUG();
    }

    public static long INSTANCE_SIZE() {
        return SlottedRow$.MODULE$.INSTANCE_SIZE();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SlotConfiguration slots() {
        return this.slots;
    }

    public long[] longs() {
        return this.longs;
    }

    public AnyValue[] refs() {
        return this.refs;
    }

    public String toString() {
        Iterator<Tuple2<String, AnyValue>> iter = this.iterator();
        StringBuilder s = package$.MODULE$.StringBuilder().newBuilder();
        s.$plus$plus$eq("\nSlottedExecutionContext {\n    " + this.slots());
        while (iter.hasNext()) {
            Tuple2 slotValue = (Tuple2)iter.next();
            s.$plus$plus$eq(StringOps$.MODULE$.format$extension("\n    %-40s = %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{slotValue._1(), slotValue._2()})));
        }
        s.$plus$plus$eq("\n}\n");
        return s.result();
    }

    public void copyAllFrom(ReadableRow input) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            this.copyFromSlotted(slottedRow, 0, 0, 0, 0);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyAllToSlottedRow(this);
            return;
        }
        throw this.fail();
    }

    public void copyFrom(ReadableRow input, int nLongs, int nRefs) {
        if (nLongs > this.slots().numberOfLongs() || nRefs > this.slots().numberOfReferences()) {
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"A bug has occurred in the slotted runtime: The target slotted execution context cannot hold the data to copy.");
        }
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            System.arraycopy(slottedRow.longs(), 0, this.longs(), 0, nLongs);
            System.arraycopy(slottedRow.refs(), 0, this.refs(), 0, nRefs);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyLongsToSlottedRow(this, 0, 0, nLongs);
            ((SlottedCompatible)readableRow2).copyRefsToSlottedRow(this, 0, 0, nRefs);
            return;
        }
        throw this.fail();
    }

    public void copyLongsFrom(ReadableRow input, int fromOffset, int toOffset, int length) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            System.arraycopy(slottedRow.longs(), fromOffset, this.longs(), toOffset, length);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyLongsToSlottedRow(this, fromOffset, toOffset, length);
            return;
        }
        throw this.fail();
    }

    public void copyRefsFrom(ReadableRow input, int fromOffset, int toOffset, int length) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            System.arraycopy(slottedRow.refs(), fromOffset, this.refs(), toOffset, length);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyRefsToSlottedRow(this, fromOffset, toOffset, length);
            return;
        }
        throw this.fail();
    }

    public CypherRow copyMapped(Function1<AnyValue, AnyValue> func) {
        SlottedRow clone = new SlottedRow(this.slots());
        clone.copyAllFrom((ReadableRow)this);
        clone.transformRefs(func);
        return clone;
    }

    private void transformRefs(Function1<AnyValue, AnyValue> func) {
        ArraySeq allSlots = this.slots().slots();
        for (int i = 0; i < allSlots.length(); ++i) {
            SlotConfiguration.KeyedSlot slot = (SlotConfiguration.KeyedSlot)allSlots.apply(i);
            if (!SlotType.isRefSlot((int)slot.slotType())) continue;
            this.setRefAt(slot.offset(), (AnyValue)func.apply((Object)this.getRefAt(slot.offset())));
        }
    }

    public void copyFromOffset(ReadableRow input, int sourceLongOffset, int sourceRefOffset, int targetLongOffset, int targetRefOffset) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            this.copyFromSlotted(slottedRow, sourceLongOffset, sourceRefOffset, targetLongOffset, targetRefOffset);
            return;
        }
        throw this.fail();
    }

    private void copyFromSlotted(SlottedRow other, int sourceLongOffset, int sourceRefOffset, int targetLongOffset, int targetRefOffset) {
        SlotConfiguration otherPipeline = other.slots();
        if (otherPipeline.numberOfLongs() > this.slots().numberOfLongs() || otherPipeline.numberOfReferences() > this.slots().numberOfReferences()) {
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A bug has occurred in the slotted runtime: The target slotted execution context cannot hold the data to copy\n           |From : " + otherPipeline + "\n           |To :   " + this.slots())));
        }
        System.arraycopy(other.longs(), sourceLongOffset, this.longs(), targetLongOffset, other.slots().numberOfLongs() - sourceLongOffset);
        System.arraycopy(other.refs(), sourceRefOffset, this.refs(), targetRefOffset, other.slots().numberOfReferences() - sourceRefOffset);
    }

    public void setLongAt(int offset, long value) {
        this.longs()[offset] = value;
    }

    public long getLongAt(int offset) {
        return this.longs()[offset];
    }

    public void setRefAt(int offset, AnyValue value) {
        this.refs()[offset] = value;
    }

    public AnyValue getRefAt(int offset) {
        AnyValue value = this.refs()[offset];
        if (false && value == null) {
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("Reference value not initialised at offset " + offset + " in " + this));
        }
        return value;
    }

    public AnyValue getByName(String name) {
        return SlotAccessor.getValue((ReadableRow)this, (SlotConfiguration.KeyedSlot)this.slots().getOrElse((SlotConfiguration.SlotKey)new SlotConfiguration.VariableSlotKey(name), (Function0 & Serializable)() -> {
            throw new NotFoundException("Unknown variable `" + name + "`");
        }));
    }

    public int numberOfColumns() {
        return this.refs().length + this.longs().length;
    }

    public boolean containsName(String name) {
        return this.getByName(name) != null;
    }

    public void setCachedPropertyAt(int offset, Value value) {
        this.refs()[offset] = value;
    }

    public void invalidateCachedProperties() {
        ArraySeq offsets = this.slots().cachedPropertyOffsets();
        for (int i = 0; i < offsets.length(); ++i) {
            this.setCachedPropertyAt(BoxesRunTime.unboxToInt((Object)offsets.apply(i)), null);
        }
    }

    public void invalidateCachedNodeProperties(long node) {
        SlotAccessor.invalidateCachedNodeProperties((CypherRow)this, (SlotConfiguration)this.slots(), (long)node);
    }

    public void invalidateCachedRelationshipProperties(long rel) {
        SlotAccessor.invalidateCachedRelProperties((CypherRow)this, (SlotConfiguration)this.slots(), (long)rel);
    }

    public void setCachedProperty(ASTCachedProperty.RuntimeKey key, Value value) {
        this.setCachedPropertyAt(this.slots().cachedPropOffset(key), value);
    }

    public Value getCachedPropertyAt(int offset) {
        return (Value)this.refs()[offset];
    }

    public Value getCachedProperty(ASTCachedProperty.RuntimeKey key) {
        throw this.fail();
    }

    public long estimatedHeapUsage() {
        long usage = SlottedRow$.MODULE$.INSTANCE_SIZE() + HeapEstimator.sizeOf((long[])this.longs()) + HeapEstimator.shallowSizeOf((Object[])this.refs());
        for (int i = 0; i < this.refs().length; ++i) {
            AnyValue ref = this.refs()[i];
            if (ref == null) continue;
            usage += ref.estimatedHeapUsage();
        }
        return usage;
    }

    public long deduplicatedEstimatedHeapUsage(CypherRow previous) {
        if (previous == null) {
            return this.estimatedHeapUsage();
        }
        long usage = SlottedRow$.MODULE$.INSTANCE_SIZE() + HeapEstimator.sizeOf((long[])this.longs()) + HeapEstimator.shallowSizeOf((Object[])this.refs());
        for (int i = 0; i < this.refs().length; ++i) {
            AnyValue ref = this.refs()[i];
            if (ref == null || ref == previous.getRefAt(i)) continue;
            usage += ref.estimatedHeapUsage();
        }
        return usage;
    }

    private Nothing$ fail() {
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"Tried using a slotted context as a map");
    }

    public void setLinenumber(Option<ResourceLinenumber> line) {
        throw this.fail();
    }

    public Option<ResourceLinenumber> getLinenumber() {
        return SlottedRow$.MODULE$.getLinenumber((ReadableRow)this, this.slots());
    }

    public void set(Seq<Tuple2<String, AnyValue>> newEntries) {
        newEntries.foreach((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$set$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void set(String key, AnyValue value) {
        SlotAccessor.setValue((WritableRow)this, (SlotConfiguration.KeyedSlot)this.slots().apply((SlotConfiguration.SlotKey)new SlotConfiguration.VariableSlotKey(key)), (AnyValue)value);
    }

    public void set(String key1, AnyValue value1, String key2, AnyValue value2) {
        this.set(key1, value1);
        this.set(key2, value2);
    }

    public void set(String key1, AnyValue value1, String key2, AnyValue value2, String key3, AnyValue value3) {
        this.set(key1, value1);
        this.set(key2, value2);
        this.set(key3, value3);
    }

    public CypherRow copyWith(String key1, AnyValue value1) {
        SlottedRow newCopy = new SlottedRow(this.slots());
        newCopy.copyAllFrom((ReadableRow)this);
        newCopy.set(key1, value1);
        return newCopy;
    }

    public CypherRow copyWith(String key1, AnyValue value1, String key2, AnyValue value2) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    public CypherRow copyWith(String key1, AnyValue value1, String key2, AnyValue value2, String key3, AnyValue value3) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    public CypherRow copyWith(Seq<Tuple2<String, AnyValue>> newEntries) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    public boolean isRefInitialized(int offset) {
        return this.refs()[offset] != null;
    }

    public AnyValue getRefAtWithoutCheckingInitialized(int offset) {
        return this.refs()[offset];
    }

    @VisibleForTesting
    public void setPrimitiveNode(SlotConfiguration.SlotKey key, long value) {
        SlotConfiguration.KeyedSlot slot = this.slots().apply(key);
        int offset = slot.offset();
        int n = slot.slotType();
        switch (n) {
            case 1: {
                if (AssertionRunner.ASSERTIONS_ENABLED && value == SlotConfigurationUtils$.MODULE$.PRIMITIVE_NULL()) {
                    throw new AssertionError((Object)"assertion failed");
                }
                this.setLongAt(offset, value);
                return;
            }
            case 2: {
                this.setLongAt(offset, value);
                return;
            }
            case 7: {
                if (AssertionRunner.ASSERTIONS_ENABLED && value == SlotConfigurationUtils$.MODULE$.PRIMITIVE_NULL()) {
                    throw new AssertionError((Object)"assertion failed");
                }
                this.setRefAt(offset, (AnyValue)VirtualValues.node((long)value));
                return;
            }
            case 8: {
                this.setRefAt(offset, SlotAccessor.nullableNode((long)value));
                return;
            }
            case 11: {
                if (!slot.slot().typ().isAssignableFrom((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode())) break;
                if (AssertionRunner.ASSERTIONS_ENABLED && value == SlotConfigurationUtils$.MODULE$.PRIMITIVE_NULL()) {
                    throw new AssertionError((Object)"assertion failed");
                }
                this.setRefAt(offset, SlotAccessor.nullableNode((long)value));
                return;
            }
            case 12: {
                if (!slot.slot().typ().isAssignableFrom((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode())) break;
                this.setRefAt(offset, SlotAccessor.nullableNode((long)value));
                return;
            }
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("Do not know how to make a primitive Node setter for slot " + slot.slot()));
    }

    @VisibleForTesting
    public void setPrimitiveRel(SlotConfiguration.SlotKey key, long value) {
        SlotConfiguration.KeyedSlot slot = this.slots().apply(key);
        int offset = slot.offset();
        int n = slot.slotType();
        switch (n) {
            case 3: {
                if (AssertionRunner.ASSERTIONS_ENABLED && value == SlotConfigurationUtils$.MODULE$.PRIMITIVE_NULL()) {
                    throw new AssertionError((Object)"assertion failed");
                }
                this.setLongAt(offset, value);
                return;
            }
            case 4: {
                this.setLongAt(offset, value);
                return;
            }
            case 9: {
                if (AssertionRunner.ASSERTIONS_ENABLED && value == SlotConfigurationUtils$.MODULE$.PRIMITIVE_NULL()) {
                    throw new AssertionError((Object)"assertion failed");
                }
                this.setRefAt(offset, (AnyValue)VirtualValues.relationship((long)value));
                return;
            }
            case 10: {
                this.setRefAt(offset, SlotAccessor.nullableRel((long)value));
                return;
            }
            case 11: {
                if (!slot.slot().typ().isAssignableFrom((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship())) break;
                if (AssertionRunner.ASSERTIONS_ENABLED && value == SlotConfigurationUtils$.MODULE$.PRIMITIVE_NULL()) {
                    throw new AssertionError((Object)"assertion failed");
                }
                this.setRefAt(offset, SlotAccessor.nullableRel((long)value));
                return;
            }
            case 12: {
                if (!slot.slot().typ().isAssignableFrom((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship())) break;
                this.setRefAt(offset, SlotAccessor.nullableRel((long)value));
                return;
            }
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("Do not know how to make a primitive Relationship setter for slot " + slot.slot()));
    }

    private void mergeWith(SlottedRow otherRow, boolean nullCheck) {
        ArraySeq otherSlots = otherRow.slots().slots();
        block4: for (int i = 0; i < otherSlots.length(); ++i) {
            SlotConfiguration.KeyedSlot otherSlot = (SlotConfiguration.KeyedSlot)otherSlots.apply(i);
            SlotConfiguration.SlotKey key = otherSlot.key();
            int otherOffset = otherSlot.offset();
            SlotConfiguration.SlotKey slotKey = key;
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                int n = otherSlot.slotType();
                switch (n) {
                    case 1: 
                    case 2: {
                        this.setPrimitiveNode(key, otherRow.getLongAt(otherOffset));
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.setPrimitiveRel(key, otherRow.getLongAt(otherOffset));
                        break;
                    }
                    default: {
                        if (!SlotType.isRefSlot((int)n) || !otherRow.isRefInitialized(otherOffset)) continue block4;
                        if (AssertionRunner.ASSERTIONS_ENABLED && nullCheck && !this.checkCompatibleNullablility(key, otherSlot)) {
                            throw new AssertionError((Object)"assertion failed");
                        }
                        SlotAccessor.setValue((WritableRow)this, (SlotConfiguration.KeyedSlot)this.slots().apply(key), (AnyValue)otherRow.getRefAtWithoutCheckingInitialized(otherOffset));
                        break;
                    }
                }
                continue;
            }
            if (slotKey instanceof SlotConfiguration.CachedPropertySlotKey) {
                SlotConfiguration.CachedPropertySlotKey cachedPropertySlotKey = (SlotConfiguration.CachedPropertySlotKey)slotKey;
                this.setCachedProperty(cachedPropertySlotKey.property(), otherRow.getCachedPropertyAt(otherOffset));
                continue;
            }
            if (slotKey instanceof SlotConfiguration.MetaDataSlotKey) {
                SlotConfiguration.MetaDataSlotKey metaDataSlotKey = (SlotConfiguration.MetaDataSlotKey)slotKey;
                int thisOffset = this.slots().metaDataOffset(metaDataSlotKey);
                if (!this.isRefInitialized(thisOffset) || this.getRefAtWithoutCheckingInitialized(thisOffset) == Values.NO_VALUE) {
                    this.setRefAt(thisOffset, otherRow.getRefAt(otherOffset));
                }
                continue;
            }
            if (slotKey instanceof SlotConfiguration.DuplicatedSlotKey) {
                continue;
            }
            if (slotKey instanceof SlotConfiguration.PlanningSlotKey) {
                throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"PlanningSlotKey encountered during execution");
            }
            throw new MatchError((Object)slotKey);
        }
    }

    public void mergeWith(ReadableRow other, EntityById entityById, boolean nullCheck) {
        ReadableRow readableRow = other;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            this.mergeWith(slottedRow, nullCheck);
            return;
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"Well well, isn't this a delicate situation?");
    }

    public boolean mergeWith$default$3() {
        return true;
    }

    private boolean checkCompatibleNullablility(SlotConfiguration.SlotKey key, SlotConfiguration.KeyedSlot otherSlot) {
        SlotConfiguration.KeyedSlot thisSlot = this.slots().apply(key);
        if (!SlotType.isNullable((int)thisSlot.slotType()) && SlotType.isNullable((int)otherSlot.slotType())) {
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("Tried to merge slot " + otherSlot + " into " + thisSlot + " but its nullability is incompatible"));
        }
        return true;
    }

    public CypherRow createClone() {
        SlottedRow clone = new SlottedRow(this.slots());
        clone.copyAllFrom((ReadableRow)this);
        return clone;
    }

    public boolean isNull(String key) {
        SlotConfiguration.KeyedSlot slot = (SlotConfiguration.KeyedSlot)this.slots().apply(key);
        int n = slot.slotType();
        switch (n) {
            case 2: 
            case 4: {
                return NullChecker$.MODULE$.entityIsNull(this.getLongAt(slot.offset()));
            }
            case 8: 
            case 10: {
                return this.isRefInitialized(slot.offset()) && this.getRefAtWithoutCheckingInitialized(slot.offset()) == Values.NO_VALUE;
            }
        }
        return false;
    }

    private Iterator<Tuple2<String, AnyValue>> iterator() {
        LegacySlotView qual$1 = this.slots().legacyView();
        SlotConfiguration.Size x$1 = qual$1.keyedSlotsOrdered$default$1();
        return qual$1.keyedSlotsOrdered(x$1).iterator().map((Function1 & Serializable)x0$1 -> {
            SlotConfiguration.SlotWithKeyAndAliases slotWithKeyAndAliases = x0$1;
            if (slotWithKeyAndAliases != null) {
                SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
                Slot slot = slotWithKeyAndAliases.slot();
                Set aliases = slotWithKeyAndAliases.aliases();
                if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                    SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                    String key = variableSlotKey.name();
                    if (slot instanceof RefSlot) {
                        RefSlot refSlot = (RefSlot)slot;
                        int offset = refSlot.offset();
                        return new Tuple2((Object)SlottedRow.prettyKey$1(key, aliases), (Object)this.refs()[offset]);
                    }
                }
            }
            if (slotWithKeyAndAliases != null) {
                SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
                Slot slot = slotWithKeyAndAliases.slot();
                Set aliases = slotWithKeyAndAliases.aliases();
                if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                    SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                    String key = variableSlotKey.name();
                    if (slot instanceof LongSlot) {
                        LongSlot longSlot = (LongSlot)slot;
                        int offset = longSlot.offset();
                        return new Tuple2((Object)SlottedRow.prettyKey$1(key, aliases), (Object)Values.longValue((long)this.longs()[offset]));
                    }
                }
            }
            if (slotWithKeyAndAliases != null) {
                SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
                Slot slot = slotWithKeyAndAliases.slot();
                if (slotKey instanceof SlotConfiguration.CachedPropertySlotKey) {
                    SlotConfiguration.CachedPropertySlotKey cachedPropertySlotKey = (SlotConfiguration.CachedPropertySlotKey)slotKey;
                    ASTCachedProperty.RuntimeKey cachedProperty = cachedPropertySlotKey.property();
                    return new Tuple2((Object)cachedProperty.asCanonicalStringVal(), (Object)this.refs()[slot.offset()]);
                }
            }
            if (slotWithKeyAndAliases != null) {
                SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
                Slot slot = slotWithKeyAndAliases.slot();
                if (slotKey instanceof SlotConfiguration.MetaDataSlotKey) {
                    SlotConfiguration.MetaDataSlotKey metaDataSlotKey = (SlotConfiguration.MetaDataSlotKey)slotKey;
                    String key = metaDataSlotKey.name();
                    int id = metaDataSlotKey.planId();
                    return new Tuple2((Object)("MetaData(" + key + ", " + new Id(id) + ")"), (Object)this.refs()[slot.offset()]);
                }
            }
            if (slotWithKeyAndAliases != null) {
                SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
                Slot slot = slotWithKeyAndAliases.slot();
                if (slotKey instanceof SlotConfiguration.ApplyPlanSlotKey) {
                    SlotConfiguration.ApplyPlanSlotKey applyPlanSlotKey = (SlotConfiguration.ApplyPlanSlotKey)slotKey;
                    int id = applyPlanSlotKey.applyPlanId();
                    return new Tuple2((Object)("Apply-Plan(" + new Id(id) + ")"), (Object)Values.longValue((long)this.longs()[slot.offset()]));
                }
            }
            if (slotWithKeyAndAliases != null) {
                SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
                Slot slot = slotWithKeyAndAliases.slot();
                if (slotKey instanceof SlotConfiguration.OuterNestedApplyPlanSlotKey) {
                    SlotConfiguration.OuterNestedApplyPlanSlotKey outerNestedApplyPlanSlotKey = (SlotConfiguration.OuterNestedApplyPlanSlotKey)slotKey;
                    int id = outerNestedApplyPlanSlotKey.applyPlanId();
                    return new Tuple2((Object)("Nested-Apply-Plan(" + new Id(id) + ")"), (Object)Values.longValue((long)this.longs()[slot.offset()]));
                }
            }
            if (slotWithKeyAndAliases != null) {
                SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
                Slot slot = slotWithKeyAndAliases.slot();
                if (slotKey instanceof SlotConfiguration.DuplicatedSlotKey) {
                    SlotConfiguration.DuplicatedSlotKey duplicatedSlotKey = (SlotConfiguration.DuplicatedSlotKey)slotKey;
                    String key = duplicatedSlotKey.name();
                    int id = duplicatedSlotKey.slotId();
                    return new Tuple2((Object)("DuplicatedSlot(" + key + ", " + id + ")"), slot.isLongSlot() ? Values.longValue((long)this.longs()[slot.offset()]) : this.refs()[slot.offset()]);
                }
            }
            throw new MatchError((Object)slotWithKeyAndAliases);
        });
    }

    public void compact() {
        if (this.refs().length > 0 && this.slots().discardedRefSlotOffsets().nonEmpty()) {
            ArraySeq discard = this.slots().discardedRefSlotOffsets();
            for (int i = 0; i < discard.length(); ++i) {
                this.refs()[BoxesRunTime.unboxToInt((Object)discard.apply((int)i))] = null;
            }
            return;
        }
    }

    public SlottedRow copy(SlotConfiguration slots) {
        return new SlottedRow(slots);
    }

    public SlotConfiguration copy$default$1() {
        return this.slots();
    }

    public String productPrefix() {
        return "SlottedRow";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.slots();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SlottedRow;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "slots";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SlottedRow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SlottedRow slottedRow = (SlottedRow)x$1;
        SlotConfiguration slotConfiguration = this.slots();
        SlotConfiguration slotConfiguration2 = slottedRow.slots();
        if (slotConfiguration != null) {
            if (!slotConfiguration.equals(slotConfiguration2)) return false;
            return true;
        }
        if (slotConfiguration2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$set$1(SlottedRow $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            AnyValue v = (AnyValue)tuple2._2();
            $this.set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String prettyKey$1(String key, Set aliases) {
        String string = key;
        return ((IterableOnceOps)aliases.toSeq().$plus$colon((Object)string)).mkString(",");
    }

    public SlottedRow(SlotConfiguration slots) {
        this.slots = slots;
        CypherRow.$init$((CypherRow)this);
        Product.$init$((Product)this);
        this.longs = new long[slots.numberOfLongs()];
        this.refs = new AnyValue[slots.numberOfReferences()];
    }
}

