/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout.recordstorage;

import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.PlainDatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;

public class RecordDatabaseLayout
extends PlainDatabaseLayout {
    private RecordDatabaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        super(neo4jLayout, databaseName);
    }

    public static RecordDatabaseLayout of(Neo4jLayout neo4jLayout, String databaseName) {
        return new RecordDatabaseLayout(neo4jLayout, databaseName);
    }

    public static RecordDatabaseLayout ofFlat(Path databaseDirectory) {
        Path canonical = FileUtils.getCanonicalFile((Path)databaseDirectory);
        Path home = canonical.getParent();
        String dbName = canonical.getFileName().toString();
        return RecordDatabaseLayout.of(Neo4jLayout.ofFlat(home), dbName);
    }

    public static RecordDatabaseLayout cast(DatabaseLayout layout) {
        if (layout instanceof RecordDatabaseLayout) {
            RecordDatabaseLayout rdl = (RecordDatabaseLayout)layout;
            return rdl;
        }
        throw new IllegalArgumentException(layout.toString() + " does not describe a record storage database.");
    }

    public static RecordDatabaseLayout convert(DatabaseLayout layout) {
        RecordDatabaseLayout rdl;
        return layout instanceof RecordDatabaseLayout ? (rdl = (RecordDatabaseLayout)layout) : RecordDatabaseLayout.of(layout.getNeo4jLayout(), layout.getDatabaseName());
    }

    public static RecordDatabaseLayout of(Config config) {
        return RecordDatabaseLayout.of(Neo4jLayout.of((Configuration)config), (String)config.get(GraphDatabaseSettings.initial_default_database));
    }

    @Override
    public Path pathForExistsMarker() {
        return this.file(RecordDatabaseFile.EXISTS_MARKER);
    }

    @Override
    public Path pathForStore(CommonDatabaseStores store) {
        return switch (store) {
            default -> throw new MatchException(null, null);
            case CommonDatabaseStores.NODE -> this.nodeStore();
            case CommonDatabaseStores.COUNTS -> this.countStore();
            case CommonDatabaseStores.LABEL_TOKENS -> this.labelTokenStore();
            case CommonDatabaseStores.RELATIONSHIP_TYPE_TOKENS -> this.relationshipTypeTokenStore();
            case CommonDatabaseStores.PROPERTY_KEY_TOKENS -> this.propertyKeyTokenStore();
            case CommonDatabaseStores.SCHEMAS -> this.schemaStore();
            case CommonDatabaseStores.INDEX_STATISTICS -> this.indexStatisticsStore();
            case CommonDatabaseStores.METADATA -> this.metadataStore();
        };
    }

    public Path countStore() {
        return this.file(RecordDatabaseFile.COUNTS_STORE);
    }

    public Path relationshipGroupDegreesStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_GROUP_DEGREES_STORE);
    }

    public Path propertyStringStore() {
        return this.file(RecordDatabaseFile.PROPERTY_STRING_STORE);
    }

    public Path relationshipStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_STORE);
    }

    public Path propertyStore() {
        return this.file(RecordDatabaseFile.PROPERTY_STORE);
    }

    public Path nodeStore() {
        return this.file(RecordDatabaseFile.NODE_STORE);
    }

    public Path nodeLabelStore() {
        return this.file(RecordDatabaseFile.NODE_LABEL_STORE);
    }

    public Path propertyArrayStore() {
        return this.file(RecordDatabaseFile.PROPERTY_ARRAY_STORE);
    }

    public Path propertyKeyTokenStore() {
        return this.file(RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE);
    }

    public Path propertyKeyTokenNamesStore() {
        return this.file(RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE);
    }

    public Path relationshipTypeTokenStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE);
    }

    public Path relationshipTypeTokenNamesStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE);
    }

    public Path labelTokenStore() {
        return this.file(RecordDatabaseFile.LABEL_TOKEN_STORE);
    }

    public Path schemaStore() {
        return this.file(RecordDatabaseFile.SCHEMA_STORE);
    }

    public Path relationshipGroupStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_GROUP_STORE);
    }

    public Path labelTokenNamesStore() {
        return this.file(RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE);
    }

    @Override
    public Path indexStatisticsStore() {
        return this.file(RecordDatabaseFile.INDEX_STATISTICS_STORE);
    }

    @Override
    public Path metadataStore() {
        return this.file(RecordDatabaseFile.METADATA_STORE);
    }

    public Path idNodeStore() {
        return this.idFile(RecordDatabaseFile.NODE_STORE).get();
    }

    public Path idNodeLabelStore() {
        return this.idFile(RecordDatabaseFile.NODE_LABEL_STORE).get();
    }

    public Path idPropertyStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_STORE).get();
    }

    public Path idPropertyKeyTokenStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE).get();
    }

    public Path idPropertyKeyTokenNamesStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE).get();
    }

    public Path idPropertyStringStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_STRING_STORE).get();
    }

    public Path idPropertyArrayStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_ARRAY_STORE).get();
    }

    public Path idRelationshipStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_STORE).get();
    }

    public Path idRelationshipGroupStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_GROUP_STORE).get();
    }

    public Path idRelationshipTypeTokenStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE).get();
    }

    public Path idRelationshipTypeTokenNamesStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE).get();
    }

    public Path idLabelTokenStore() {
        return this.idFile(RecordDatabaseFile.LABEL_TOKEN_STORE).get();
    }

    public Path idLabelTokenNamesStore() {
        return this.idFile(RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE).get();
    }

    public Path idSchemaStore() {
        return this.idFile(RecordDatabaseFile.SCHEMA_STORE).get();
    }

    @Override
    public boolean isRecoverableStore(DatabaseFile file) {
        assert (file instanceof RecordDatabaseFile);
        return RecordDatabaseFile.RECOVERABLE_STORE_FILES.contains(file);
    }
}

