/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.Objects;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;

class RoutedErrorMapper
extends ErrorMapper {
    private final BoltServerAddress address;
    private final AccessMode accessMode;

    RoutedErrorMapper(BoltServerAddress address, AccessMode accessMode) {
        this.address = Objects.requireNonNull(address);
        this.accessMode = Objects.requireNonNull(accessMode);
    }

    @Override
    protected Neo4jException mapBoltFailureException(BoltFailureException boltFailureException) {
        Neo4jException result;
        if ("Neo.ClientError.Cluster.NotALeader".equals(boltFailureException.code()) || "Neo.ClientError.General.ForbiddenOnReadOnlyDatabase".equals(boltFailureException.code())) {
            result = switch (this.accessMode) {
                default -> throw new IncompatibleClassChangeError();
                case AccessMode.READ -> {
                    String message = "Write queries cannot be performed in READ access mode.";
                    yield new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, boltFailureException.gqlCause().map(this::mapGqlCause).orElse(null));
                }
                case AccessMode.WRITE -> new SessionExpiredException(String.format("Server at %s no longer accepts writes", this.address), (Throwable)boltFailureException);
            };
        } else {
            result = super.mapBoltFailureException(boltFailureException);
        }
        return result;
    }

    @Override
    protected Throwable mapServiceUnavailable(BoltServiceUnavailableException boltServiceUnavailableException) {
        return new SessionExpiredException(String.format("Server at %s is no longer available", this.address), (Throwable)boltServiceUnavailableException);
    }
}

