/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.locker.Locker;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.internal.Version;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="%n", synopsisHeading="%n@|bold,underline USAGE|@%n%n", descriptionHeading="%n@|bold,underline DESCRIPTION|@%n%n", optionListHeading="%n@|bold,underline OPTIONS|@%n%n", parameterListHeading="%n@|bold,underline PARAMETERS|@%n%n", exitCodeOnSuccess=0, exitCodeOnUsageHelp=0, exitCodeOnInvalidInput=64, exitCodeOnExecutionException=70, showDefaultValues=true)
public abstract class AbstractCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--verbose"}, description={"Enable verbose output."})
    protected boolean verbose;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, fallbackValue="true", description={"Show this help message and exit."})
    private boolean helpRequested;
    @CommandLine.Option(names={"--expand-commands"}, fallbackValue="true", description={"Allow command expansion in config value evaluation."})
    protected boolean allowCommandExpansion;
    protected final ExecutionContext ctx;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected AbstractCommand(ExecutionContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    protected abstract void execute() throws Exception;

    protected List<Path> configFiles() {
        ArrayList<Path> config = new ArrayList<Path>();
        Path defaultConf = this.ctx.confDir().resolve("neo4j.conf");
        if (this.ctx.fs().fileExists(defaultConf)) {
            config.add(defaultConf);
        }
        return config;
    }

    protected void wrappedExecute() throws Exception {
        this.execute();
    }

    @Override
    public Integer call() throws Exception {
        if (this.verbose) {
            this.printVerboseHeader();
            this.printConfigInformation();
        }
        try {
            this.wrappedExecute();
        }
        catch (Throwable e) {
            Integer n;
            Path problematicFile = this.findFileForPotentialPermissionProblems(e);
            problematicFile = problematicFile != null ? problematicFile : this.ctx.homeDir();
            this.collectAndPrintPermissionProblems(problematicFile);
            if (this.verbose) {
                e.printStackTrace(this.ctx.err());
            } else {
                this.ctx.err().println(e.getMessage());
                this.ctx.err().println("Run with '--verbose' for a more detailed error message.");
            }
            if (e instanceof CommandFailedException) {
                CommandFailedException cfe = (CommandFailedException)e;
                n = cfe.getExitCode();
            } else {
                n = 1;
            }
            return n;
        }
        return 0;
    }

    private void collectAndPrintPermissionProblems(Path file) {
        String problems = Locker.tryCollectPermissionInformation((FileSystemAbstraction)this.ctx.fs(), (Path)file);
        if (problems != null) {
            this.ctx.err().println(problems);
        }
    }

    private Path findFileForPotentialPermissionProblems(Throwable e) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        for (Throwable t = e; t != null && seen.add(t); t = t.getCause()) {
            if (t instanceof IOException) {
                return this.ctx.homeDir();
            }
            if (!(t instanceof CannotWriteException)) continue;
            CannotWriteException cwe = (CannotWriteException)t;
            return cwe.getFile();
        }
        return null;
    }

    private void printVerboseHeader() {
        PrintStream out = this.ctx.out();
        out.println("neo4j " + Version.getNeo4jVersion());
        SystemDiagnostics.JAVA_VIRTUAL_MACHINE.dump(out::println);
    }

    private void printConfigInformation() {
        PrintStream out = this.ctx.out();
        out.println("Configuration files used (ordered by priority):");
        this.configFiles().forEach(file -> out.println(file.toAbsolutePath()));
        out.println("--------------------");
    }
}

