/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.consistency.checker.DynamicNodeLabelsCache;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.store.synthetic.CountsEntry;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.recordstorage.RelationshipCounter;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;

class CountsState
implements AutoCloseable {
    private static final long COUNT_VISITED_MARK = 0x4000000000000000L;
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final long highNodeId;
    private final CacheAccess cacheAccess;
    private final LongArray nodeCounts;
    private final ConcurrentMap<CountsKey, AtomicLong> nodeCountsStray = new ConcurrentHashMap<CountsKey, AtomicLong>();
    private final LongArray relationshipLabelCounts;
    private final LongArray relationshipWildcardCounts;
    private final ConcurrentMap<CountsKey, AtomicLong> relationshipCountsStray = new ConcurrentHashMap<CountsKey, AtomicLong>();
    private final DynamicNodeLabelsCache dynamicNodeLabelsCache;

    CountsState(NeoStores neoStores, CacheAccess cacheAccess, MemoryTracker memoryTracker) {
        this((int)neoStores.getLabelTokenStore().getIdGenerator().getHighId(), (int)neoStores.getRelationshipTypeTokenStore().getIdGenerator().getHighId(), neoStores.getNodeStore().getIdGenerator().getHighId(), cacheAccess, memoryTracker);
    }

    CountsState(int highLabelId, int highRelationshipTypeId, long highNodeId, CacheAccess cacheAccess, MemoryTracker memoryTracker) {
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.highNodeId = highNodeId;
        this.cacheAccess = cacheAccess;
        NumberArrayFactory arrayFactory = NumberArrayFactories.OFF_HEAP;
        this.nodeCounts = arrayFactory.newLongArray((long)(highLabelId + 1), 0L, memoryTracker);
        this.relationshipLabelCounts = arrayFactory.newLongArray(RelationshipCounter.labelsCountsLength(highLabelId, highRelationshipTypeId), 0L, memoryTracker);
        this.relationshipWildcardCounts = arrayFactory.newLongArray(RelationshipCounter.wildcardCountsLength(highRelationshipTypeId), 0L, memoryTracker);
        this.dynamicNodeLabelsCache = new DynamicNodeLabelsCache(memoryTracker);
    }

    @Override
    public void close() {
        this.nodeCounts.close();
        this.relationshipLabelCounts.close();
        this.relationshipWildcardCounts.close();
        this.dynamicNodeLabelsCache.close();
    }

    RelationshipCounter instantiateRelationshipCounter() {
        return new RelationshipCounter(this.nodeLabelsLookup(), this.highLabelId, this.highRelationshipTypeId, this.relationshipWildcardCounts, this.relationshipLabelCounts, (array, index) -> array.getAndAdd(index, 1L));
    }

    long cacheDynamicNodeLabels(int[] labelIds) {
        return this.dynamicNodeLabelsCache.put(labelIds);
    }

    void clearDynamicNodeLabelsCache() {
        this.dynamicNodeLabelsCache.clear();
    }

    RelationshipCounter.NodeLabelsLookup nodeLabelsLookup() {
        return new RelationshipCounter.NodeLabelsLookup(){
            private final CacheAccess.Client cacheAccessClient;
            private final int[] labelsHolder;
            {
                this.cacheAccessClient = CountsState.this.cacheAccess.client();
                this.labelsHolder = new int[20];
            }

            @Override
            public int[] nodeLabels(long nodeId) {
                if (nodeId >= CountsState.this.highNodeId) {
                    return ArrayUtils.EMPTY_INT_ARRAY;
                }
                boolean hasSingleLabel = this.cacheAccessClient.getBooleanFromCache(nodeId, 6);
                long labelField = this.cacheAccessClient.getFromCache(nodeId, 1);
                if (hasSingleLabel) {
                    this.labelsHolder[0] = (int)labelField;
                    this.labelsHolder[1] = -1;
                    return this.labelsHolder;
                }
                boolean hasInlinedLabels = this.cacheAccessClient.getBooleanFromCache(nodeId, 4);
                return hasInlinedLabels ? InlineNodeLabels.parseInlined(labelField) : CountsState.this.dynamicNodeLabelsCache.get(labelField, this.labelsHolder);
            }
        };
    }

    void incrementNodeLabel(int label, long increment) {
        if (this.isValidLabelId(label)) {
            this.nodeCounts.getAndAdd(this.labelIdArrayPos(label), increment);
        } else {
            this.nodeCountsStray.computeIfAbsent(GBPTreeCountsStore.nodeKey((int)label), k -> new AtomicLong()).addAndGet(increment);
        }
    }

    private boolean isValidLabelId(int label) {
        return label == -1 || label >= 0 && label < this.highLabelId;
    }

    void incrementRelationshipTypeCounts(RelationshipCounter counter, RelationshipRecord relationship) {
        counter.processRelationshipTypeCounts(relationship, (s, t, e) -> this.relationshipCountsStray.computeIfAbsent(GBPTreeCountsStore.relationshipKey((int)s, (long)t, (int)e), k -> new AtomicLong()).incrementAndGet());
    }

    void incrementRelationshipNodeCounts(RelationshipCounter counter, RelationshipRecord relationship, boolean processStartNode, boolean processEndNode) {
        counter.processRelationshipNodeCounts(relationship, (s, t, e) -> this.relationshipCountsStray.computeIfAbsent(GBPTreeCountsStore.relationshipKey((int)s, (long)t, (int)e), k -> new AtomicLong()).incrementAndGet(), processStartNode, processEndNode);
    }

    private static boolean hasVisitedCountMark(long countValue) {
        return (countValue & 0x4000000000000000L) != 0L;
    }

    private static long markCountVisited(long countValue) {
        return countValue | 0x4000000000000000L;
    }

    private static long unmarkCountVisited(long countValue) {
        return countValue & 0xBFFFFFFFFFFFFFFFL;
    }

    CountsChecker checker(final ConsistencyReporter reporter) {
        return new CountsChecker(){
            final RelationshipCounter relationshipCounter;
            {
                this.relationshipCounter = CountsState.this.instantiateRelationshipCounter();
            }

            public void visitNodeCount(int labelId, long count) {
                if (CountsState.this.isValidLabelId(labelId)) {
                    long pos = CountsState.this.labelIdArrayPos(labelId);
                    long expected = CountsState.unmarkCountVisited(CountsState.this.nodeCounts.get(pos));
                    if (expected != count) {
                        reporter.forCounts(new CountsEntry(GBPTreeCountsStore.nodeKey((int)labelId), count)).inconsistentNodeCount(expected);
                    }
                    CountsState.this.nodeCounts.set(pos, CountsState.markCountVisited(expected));
                } else {
                    AtomicLong expected = (AtomicLong)CountsState.this.nodeCountsStray.remove(GBPTreeCountsStore.nodeKey((int)labelId));
                    if (expected != null) {
                        if (expected.longValue() != count) {
                            reporter.forCounts(new CountsEntry(GBPTreeCountsStore.nodeKey((int)labelId), count)).inconsistentNodeCount(expected.longValue());
                        }
                    } else {
                        reporter.forCounts(new CountsEntry(GBPTreeCountsStore.nodeKey((int)labelId), count)).inconsistentNodeCount(0L);
                    }
                }
            }

            public void visitRelationshipCount(int startLabelId, int relTypeId, int endLabelId, long count) {
                CountsKey countsKey = GBPTreeCountsStore.relationshipKey((int)startLabelId, (long)relTypeId, (int)endLabelId);
                if (this.relationshipCounter.isValid(startLabelId, relTypeId, endLabelId)) {
                    long expected = CountsState.unmarkCountVisited(this.relationshipCounter.get(startLabelId, relTypeId, endLabelId));
                    if (expected != count) {
                        reporter.forCounts(new CountsEntry(countsKey, count)).inconsistentRelationshipCount(expected);
                    }
                    this.relationshipCounter.set(startLabelId, relTypeId, endLabelId, CountsState.markCountVisited(expected));
                } else {
                    AtomicLong expected = (AtomicLong)CountsState.this.relationshipCountsStray.remove(countsKey);
                    if (expected != null) {
                        if (expected.longValue() != count) {
                            reporter.forCounts(new CountsEntry(countsKey, count)).inconsistentRelationshipCount(expected.longValue());
                        }
                    } else {
                        reporter.forCounts(new CountsEntry(countsKey, count)).inconsistentRelationshipCount(0L);
                    }
                }
            }

            @Override
            public void close() {
                for (int labelId = 0; labelId < CountsState.this.highLabelId; ++labelId) {
                    long count2 = CountsState.this.nodeCounts.get((long)labelId);
                    if (CountsState.hasVisitedCountMark(count2) || count2 <= 0L) continue;
                    reporter.forCounts(new CountsEntry(GBPTreeCountsStore.nodeKey((int)labelId), 0L)).inconsistentNodeCount(count2);
                }
                for (int type = -1; type < CountsState.this.highRelationshipTypeId; ++type) {
                    this.reportRelationshipIfNeeded(-1, type, -1);
                }
                for (int label = 0; label < CountsState.this.highLabelId; ++label) {
                    for (int type = -1; type < CountsState.this.highRelationshipTypeId; ++type) {
                        this.reportRelationshipIfNeeded(-1, type, label);
                        this.reportRelationshipIfNeeded(label, type, -1);
                    }
                }
                CountsState.this.nodeCountsStray.forEach((countsKey, count) -> reporter.forCounts(new CountsEntry((CountsKey)countsKey, count.get())).inconsistentNodeCount(0L));
                CountsState.this.relationshipCountsStray.forEach((countsKey, count) -> reporter.forCounts(new CountsEntry((CountsKey)countsKey, count.get())).inconsistentRelationshipCount(0L));
            }

            private void reportRelationshipIfNeeded(int labelStart, int relType, int labelEnd) {
                long count = this.relationshipCounter.get(labelStart, relType, labelEnd);
                if (!CountsState.hasVisitedCountMark(count) && count > 0L) {
                    reporter.forCounts(new CountsEntry(GBPTreeCountsStore.relationshipKey((int)labelStart, (long)relType, (int)labelEnd), 0L)).inconsistentRelationshipCount(count);
                }
            }
        };
    }

    private long labelIdArrayPos(int labelId) {
        return labelId == -1 ? (long)this.highLabelId : (long)labelId;
    }

    static interface CountsChecker
    extends CountsVisitor,
    AutoCloseable {
        @Override
        public void close();
    }
}

