/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.util.VisibleForTesting;

class FreeIdCache {
    private static final int MAX_CACHE_SIZE = 100000;
    private static final int BLOOM_FILTER_SIZE_FACTOR = 10;
    private final IdGenerator idGenerator;
    private final int maxItemsInCache;
    private final long highId;
    private volatile LongSet cache;
    private volatile FreeIdsBloomFilter bloomFilter;

    FreeIdCache(IdGenerator idGenerator) {
        this(idGenerator, 100000);
    }

    @VisibleForTesting
    FreeIdCache(IdGenerator idGenerator, int maxItemsInCache) {
        this.idGenerator = idGenerator;
        this.maxItemsInCache = maxItemsInCache;
        this.highId = idGenerator.getHighId();
    }

    void initialize() {
        this.buildCache(this.maxItemsInCache);
    }

    boolean isIdFree(long id) {
        assert (this.cache != null || this.bloomFilter != null) : "Must be initialized before use";
        if (id >= this.highId) {
            return true;
        }
        if (this.cache != null) {
            return this.cache.contains(id);
        }
        if (this.bloomFilter.idMayBeFree(id)) {
            boolean bl;
            block12: {
                PrimitiveLongResourceIterator freeId = this.idGenerator.notUsedIdsIterator(id, id);
                try {
                    boolean bl2 = bl = freeId.hasNext() && freeId.next() == id;
                    if (freeId == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (freeId != null) {
                            try {
                                freeId.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                freeId.close();
            }
            return bl;
        }
        return false;
    }

    private void buildCache(int maxItemsInCache) {
        try {
            MutableLongSet ids = LongSets.mutable.empty();
            try (PrimitiveLongResourceIterator freeIdsIterator = this.idGenerator.notUsedIdsIterator();){
                while (freeIdsIterator.hasNext() && ids.size() < maxItemsInCache) {
                    ids.add(freeIdsIterator.next());
                }
                if (!freeIdsIterator.hasNext()) {
                    this.cache = ids;
                } else {
                    this.cache = null;
                    this.bloomFilter = new FreeIdsBloomFilter(maxItemsInCache * 10, 7);
                    ids.forEach(this.bloomFilter::add);
                    while (freeIdsIterator.hasNext()) {
                        this.bloomFilter.add(freeIdsIterator.next());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static class FreeIdsBloomFilter {
        private final int filterSize;
        private final int numHashes;
        private final long[] data;

        FreeIdsBloomFilter(int filterSize, int numHashes) {
            this.numHashes = numHashes;
            this.filterSize = filterSize;
            this.data = new long[filterSize];
        }

        private static long hash64(long x) {
            x += 5653741133630908297L;
            x = (x ^ x >>> 33) * -49064778989728563L;
            x = (x ^ x >>> 33) * -4265267296055464877L;
            x ^= x >>> 33;
            return x;
        }

        void add(long id) {
            long hash = FreeIdsBloomFilter.hash64(id);
            long a = hash >>> 32 | hash << 32;
            for (int i = 0; i < this.numHashes; ++i) {
                int n = this.reduce((int)(a >>> 32));
                this.data[n] = this.data[n] | 1L << (int)a;
                a += hash;
            }
        }

        boolean idMayBeFree(long id) {
            long hash = FreeIdsBloomFilter.hash64(id);
            long a = hash >>> 32 | hash << 32;
            for (int i = 0; i < this.numHashes; ++i) {
                if ((this.data[this.reduce((int)(a >>> 32))] & 1L << (int)a) == 0L) {
                    return false;
                }
                a += hash;
            }
            return true;
        }

        private int reduce(int hash) {
            return (int)(((long)hash & 0xFFFFFFFFL) * (long)this.filterSize >>> 32);
        }
    }
}

