/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.EntityBasedMemoryLimiter;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.index.IndexAccessor;

class IndexSizes {
    private static final String SIZE_CALCULATOR_TAG = "sizeCalculator";
    private static final double SMALL_INDEX_FACTOR_THRESHOLD = 0.05;
    private static final int INEFFICIENT_AMOUNT_OF_RELATIONSHIP_ROUNDS = 3;
    private final ParallelExecution execution;
    private final IndexAccessors indexAccessors;
    private final ConcurrentMap<IndexDescriptor, Long> nodeIndexSizes = new ConcurrentHashMap<IndexDescriptor, Long>();
    private final ConcurrentMap<IndexDescriptor, Long> relationshipIndexSizes = new ConcurrentHashMap<IndexDescriptor, Long>();
    private final long highNodeId;
    private final long highRelationshipId;
    private final CursorContextFactory contextFactory;
    private final boolean shouldLetRelationshipIndexesBeLarge;

    IndexSizes(ParallelExecution execution, IndexAccessors indexAccessors, long highNodeId, long highRelationshipId, CursorContextFactory contextFactory, EntityBasedMemoryLimiter limiter) {
        this.execution = execution;
        this.indexAccessors = indexAccessors;
        this.highNodeId = highNodeId;
        this.highRelationshipId = highRelationshipId;
        this.contextFactory = contextFactory;
        this.shouldLetRelationshipIndexesBeLarge = (long)limiter.numberOfRelationshipRanges() / Long.max(1L, limiter.numberOfNodeRanges()) <= 3L;
    }

    void initialize() throws Exception {
        this.calculateSizes(EntityType.NODE, this.nodeIndexSizes);
        this.calculateSizes(EntityType.RELATIONSHIP, this.relationshipIndexSizes);
    }

    private void calculateSizes(EntityType entityType, ConcurrentMap<IndexDescriptor, Long> indexSizes) throws Exception {
        List indexes = this.indexAccessors.onlineRules(entityType);
        this.execution.run("Estimate index sizes", (ParallelExecution.ThrowingRunnable[])indexes.stream().map(index -> () -> {
            try (CursorContext cursorContext = this.contextFactory.create(SIZE_CALCULATOR_TAG);){
                IndexAccessor accessor = this.indexAccessors.accessorFor(index);
                indexSizes.put((IndexDescriptor)index, accessor.estimateNumberOfEntries(cursorContext));
            }
        }).toArray(ParallelExecution.ThrowingRunnable[]::new));
    }

    private List<IndexDescriptor> getAllIndexes(EntityType entityType) {
        return new ArrayList<IndexDescriptor>(this.indexAccessors.onlineRules(entityType));
    }

    List<IndexDescriptor> smallIndexes(EntityType entityType) {
        List<IndexDescriptor> smallIndexes = this.getAllIndexes(entityType);
        smallIndexes.removeAll(this.largeIndexes(entityType));
        return smallIndexes;
    }

    List<IndexDescriptor> largeIndexes(EntityType entityType) {
        if (entityType == EntityType.RELATIONSHIP && !this.shouldLetRelationshipIndexesBeLarge) {
            return Collections.emptyList();
        }
        List<IndexDescriptor> indexes = this.getAllIndexes(entityType);
        indexes.sort(Comparator.comparingLong(this::getEstimatedIndexSize).reversed());
        int threshold = 0;
        for (IndexDescriptor index : indexes) {
            if (!index.schema().isFulltextSchemaDescriptor() && !IndexSizes.hasValues(index) || !(this.getSizeFactor(index, entityType) > 0.05) && threshold % 5 == 0) continue;
            ++threshold;
        }
        return indexes.subList(0, threshold);
    }

    static boolean hasValues(IndexDescriptor index) {
        return index.getCapability().supportsReturningValues() && !index.schema().isFulltextSchemaDescriptor();
    }

    private double getSizeFactor(IndexDescriptor index, EntityType entityType) {
        if (entityType == EntityType.RELATIONSHIP) {
            return (double)this.getEstimatedIndexSize(index) / (double)this.highRelationshipId;
        }
        return (double)this.getEstimatedIndexSize(index) / (double)this.highNodeId;
    }

    long getEstimatedIndexSize(IndexDescriptor index) {
        EntityType entityType = index.schema().entityType();
        ConcurrentMap<IndexDescriptor, Long> map = entityType == EntityType.NODE ? this.nodeIndexSizes : this.relationshipIndexSizes;
        return (Long)map.get(index);
    }
}

