/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Function;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checker.SafePropertyChainReader;
import org.neo4j.consistency.checking.SchemaRuleKey;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;

class SchemaChecker {
    private static final String CONSISTENCY_TOKEN_CHECKER_TAG = "consistencyTokenChecker";
    private static final String CONSTRAINT_INDEX_RULE = "CONSTRAINT_INDEX_RULE";
    private static final String UNIQUENESS_CONSTRAINT = "UNIQUENESS_CONSTRAINT";
    private final NeoStores neoStores;
    private final TokenHolders tokenHolders;
    private final IndexAccessors indexAccessors;
    private final CheckerContext context;
    private final SchemaStore schemaStore;
    private final ConsistencyReport.Reporter reporter;
    private final ParallelExecution execution;

    SchemaChecker(CheckerContext context) {
        this.neoStores = context.neoStores;
        this.tokenHolders = context.tokenHolders;
        this.indexAccessors = context.indexAccessors;
        this.context = context;
        this.schemaStore = this.neoStores.getSchemaStore();
        this.reporter = context.reporter;
        this.execution = context.execution;
    }

    void check(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties, MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedNodePropertyTypes, MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedRelationshipPropertyTypes, CursorContext cursorContext, StoreCursors storeCursors) throws Exception {
        this.checkSchema(mandatoryNodeProperties, mandatoryRelationshipProperties, allowedNodePropertyTypes, allowedRelationshipPropertyTypes, cursorContext, storeCursors);
        this.checkTokens();
    }

    private void checkSchema(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties, MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedNodePropertyTypes, MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedRelationshipPropertyTypes, CursorContext cursorContext, StoreCursors storeCursors) {
        long highId = this.schemaStore.getIdGenerator().getHighId();
        try (RecordReader<SchemaRecord> schemaReader = new RecordReader<SchemaRecord>(this.schemaStore, true, cursorContext, this.context.memoryTracker);){
            MutableLongObjectMap indexObligations = LongObjectMaps.mutable.empty();
            MutableLongObjectMap constraintObligations = LongObjectMaps.mutable.empty();
            HashMap<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords = new HashMap<SchemaRuleKey, SchemaRecord>();
            SchemaStorage schemaStorage = new SchemaStorage(this.schemaStore, this.tokenHolders, (String)this.neoStores.getConfig().get(GraphDatabaseSettings.db_format));
            this.buildObligationsMap(highId, schemaReader, schemaStorage, (MutableLongObjectMap<SchemaRecord>)indexObligations, (MutableLongObjectMap<ConstraintObligation>)constraintObligations, verifiedRulesWithRecords, storeCursors);
            this.performSchemaCheck(highId, schemaReader, (MutableLongObjectMap<SchemaRecord>)indexObligations, (MutableLongObjectMap<ConstraintObligation>)constraintObligations, schemaStorage, mandatoryNodeProperties, mandatoryRelationshipProperties, allowedNodePropertyTypes, allowedRelationshipPropertyTypes, storeCursors, cursorContext);
        }
    }

    private void buildObligationsMap(long highId, RecordReader<SchemaRecord> reader, SchemaStorage schemaStorage, MutableLongObjectMap<SchemaRecord> indexObligations, MutableLongObjectMap<ConstraintObligation> constraintObligations, Map<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords, StoreCursors storeCursors) {
        for (long id = (long)this.schemaStore.getNumberOfReservedLowIds(); id < highId && !this.context.isCancelled(); ++id) {
            try {
                ConstraintDescriptor rule;
                Object previousObligation;
                SchemaRule schemaRule;
                SchemaRecord record = reader.read(id);
                if (!record.inUse() || (schemaRule = schemaStorage.loadSingleSchemaRule(id, storeCursors, this.context.memoryTracker)).schema().isRelationshipEndpointLabelDescriptor() || schemaRule.schema().isNodeLabelExistenceSchemaDescriptor()) continue;
                SchemaRecord previousContentRecord = verifiedRulesWithRecords.put(SchemaRuleKey.from(schemaRule), new SchemaRecord(record));
                if (previousContentRecord != null) {
                    this.reporter.forSchema(record).duplicateRuleContent(previousContentRecord);
                }
                if (schemaRule instanceof IndexDescriptor) {
                    IndexDescriptor rule2 = (IndexDescriptor)schemaRule;
                    if (!rule2.isUnique() || !rule2.getOwningConstraintId().isPresent() || (previousObligation = (ConstraintObligation)constraintObligations.put(rule2.getOwningConstraintId().getAsLong(), (Object)new ConstraintObligation(new SchemaRecord(record), rule2.getIndexType()))) == null) continue;
                    this.reporter.forSchema(record).duplicateObligation(((ConstraintObligation)previousObligation).schemaRecord());
                    continue;
                }
                if (!(schemaRule instanceof ConstraintDescriptor) || !(rule = (ConstraintDescriptor)schemaRule).enforcesUniqueness() || (previousObligation = (SchemaRecord)indexObligations.put(rule.asIndexBackedConstraint().ownedIndexId(), (Object)new SchemaRecord(record))) == null) continue;
                this.reporter.forSchema(record).duplicateObligation((SchemaRecord)previousObligation);
                continue;
            }
            catch (MalformedSchemaRuleException malformedSchemaRuleException) {
                // empty catch block
            }
        }
    }

    private void performSchemaCheck(long highId, RecordReader<SchemaRecord> reader, MutableLongObjectMap<SchemaRecord> indexObligations, MutableLongObjectMap<ConstraintObligation> constraintObligations, SchemaStorage schemaStorage, MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties, MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedNodePropertyTypes, MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedRelationshipPropertyTypes, StoreCursors storeCursors, CursorContext cursorContext) {
        SchemaRecord record = reader.record();
        BasicSchemaCheck basicSchemaCheck = new BasicSchemaCheck(record, storeCursors);
        MandatoryPropertiesCollector mandatoryPropertiesCollector = new MandatoryPropertiesCollector(mandatoryNodeProperties, mandatoryRelationshipProperties);
        AllowedTypesCollector allowedTypesCollector = new AllowedTypesCollector(allowedNodePropertyTypes, allowedRelationshipPropertyTypes);
        IntObjectHashMap<Value> propertyValues = new IntObjectHashMap<Value>();
        try (SafePropertyChainReader propertyReader = new SafePropertyChainReader(this.context, cursorContext, true);){
            for (long id = (long)this.schemaStore.getNumberOfReservedLowIds(); id < highId && !this.context.isCancelled(); ++id) {
                try {
                    Object obligation;
                    reader.read(id);
                    if (!record.inUse()) continue;
                    propertyValues = RecordLoading.lightReplace(propertyValues);
                    boolean propertyChainIsOk = propertyReader.read((MutableIntObjectMap<Value>)propertyValues, record, this.reporter::forSchema, storeCursors);
                    if (!propertyChainIsOk) {
                        this.reporter.forSchema(record).malformedSchemaRule();
                        continue;
                    }
                    SchemaRule schemaRule = schemaStorage.loadSingleSchemaRule(id, storeCursors, this.context.memoryTracker);
                    basicSchemaCheck.check(schemaRule.schema());
                    if (schemaRule instanceof IndexDescriptor) {
                        IndexDescriptor rule = (IndexDescriptor)schemaRule;
                        if (rule.isUnique()) {
                            obligation = (SchemaRecord)indexObligations.get(rule.getId());
                            if (obligation == null) {
                                if (rule.getOwningConstraintId().isPresent()) {
                                    this.reporter.forSchema(record).missingObligation(UNIQUENESS_CONSTRAINT);
                                }
                            } else {
                                OptionalLong owningConstraintId = rule.getOwningConstraintId();
                                if (owningConstraintId.isEmpty() || ((AbstractBaseRecord)obligation).getId() != owningConstraintId.getAsLong()) {
                                    this.reporter.forSchema(record).constraintIndexRuleNotReferencingBack((SchemaRecord)obligation);
                                }
                            }
                        }
                        if (this.indexAccessors.notOnlineRules().contains(rule)) {
                            this.reporter.forSchema(record).schemaRuleNotOnline((SchemaRule)rule);
                        }
                        if (!this.indexAccessors.inconsistentRules().contains(rule)) continue;
                        this.reporter.forSchema(record).malformedSchemaRule();
                        continue;
                    }
                    if (schemaRule instanceof ConstraintDescriptor) {
                        ConstraintDescriptor rule = (ConstraintDescriptor)schemaRule;
                        if (rule.enforcesUniqueness()) {
                            obligation = (ConstraintObligation)constraintObligations.get(rule.getId());
                            if (obligation == null) {
                                this.reporter.forSchema(record).missingObligation(CONSTRAINT_INDEX_RULE);
                            } else if (((ConstraintObligation)obligation).schemaRecord().getId() != rule.asIndexBackedConstraint().ownedIndexId()) {
                                this.reporter.forSchema(record).uniquenessConstraintNotReferencingBack(((ConstraintObligation)obligation).schemaRecord());
                            } else if (((ConstraintObligation)obligation).indexType() != rule.asIndexBackedConstraint().indexType()) {
                                this.reporter.forSchema(record).uniquenessConstraintReferencingIndexOfWrongType(((ConstraintObligation)obligation).schemaRecord());
                            }
                        }
                        if (rule.enforcesPropertyExistence()) {
                            mandatoryPropertiesCollector.collect(rule.schema());
                        }
                        if (!rule.enforcesPropertyType()) continue;
                        allowedTypesCollector.collect(rule.asPropertyTypeConstraint());
                        continue;
                    }
                    this.reporter.forSchema(record).unsupportedSchemaRuleType(null);
                    continue;
                }
                catch (MalformedSchemaRuleException e) {
                    this.reporter.forSchema(record).malformedSchemaRule();
                }
            }
        }
    }

    private void checkTokens() throws Exception {
        this.execution.run(this.getClass().getSimpleName() + "-checkTokens", () -> SchemaChecker.checkTokens(this.neoStores.getLabelTokenStore(), this.reporter::forLabelName, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.LABEL_NAME, (DynamicRecord)dynamicRecord), this.context.contextFactory, this.context.memoryTracker), () -> SchemaChecker.checkTokens(this.neoStores.getRelationshipTypeTokenStore(), this.reporter::forRelationshipTypeName, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.RELATIONSHIP_TYPE_NAME, (DynamicRecord)dynamicRecord), this.context.contextFactory, this.context.memoryTracker), () -> SchemaChecker.checkTokens(this.neoStores.getPropertyKeyTokenStore(), this.reporter::forPropertyKey, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.PROPERTY_KEY_NAME, (DynamicRecord)dynamicRecord), this.context.contextFactory, this.context.memoryTracker));
    }

    private static <R extends TokenRecord> void checkTokens(TokenStore<R> store, Function<R, ConsistencyReport.NameConsistencyReport> report, Function<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> dynamicRecordReport, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        DynamicStringStore nameStore = store.getNameStore();
        DynamicRecord nameRecord = (DynamicRecord)nameStore.newRecord();
        long highId = store.getIdGenerator().getHighId();
        LongHashSet seenNameRecordIds = new LongHashSet();
        int blockSize = store.getNameStore().getRecordDataSize();
        try (CursorContext cursorContext = contextFactory.create(CONSISTENCY_TOKEN_CHECKER_TAG);
             RecordReader tokenReader = new RecordReader(store, true, cursorContext, memoryTracker);
             RecordReader<DynamicRecord> nameReader = new RecordReader<DynamicRecord>(store.getNameStore(), false, cursorContext, memoryTracker);){
            for (long id = 0L; id < highId; ++id) {
                TokenRecord record = (TokenRecord)tokenReader.read(id);
                if (!record.inUse() || Record.NULL_REFERENCE.is(record.getNameId())) continue;
                seenNameRecordIds = RecordLoading.lightReplace(seenNameRecordIds);
                RecordLoading.safeLoadDynamicRecordChain(r -> {}, nameReader, (MutableLongSet)seenNameRecordIds, record.getNameId(), blockSize, (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply(nameRecord)).circularReferenceNext((DynamicRecord)r), (i, r) -> ((ConsistencyReport.NameConsistencyReport)report.apply(record)).nameBlockNotInUse(nameRecord), (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply(nameRecord)).nextNotInUse((DynamicRecord)r), (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).emptyBlock(), r -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).recordNotFullReferencesNext(), r -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).invalidLength());
            }
        }
    }

    static Function<AbstractBaseRecord, String> moreDescriptiveRecordToStrings(NeoStores neoStores, TokenHolders tokenHolders, MemoryTracker memoryTracker) {
        return record -> {
            Object result = record.toString();
            if (record instanceof SchemaRecord) {
                try (CachedStoreCursors storeCursors = new CachedStoreCursors(neoStores, CursorContext.NULL_CONTEXT);){
                    SchemaRule schemaRule = SchemaStore.readSchemaRule((SchemaRecord)record, neoStores.getPropertyStore(), tokenHolders, (StoreCursors)storeCursors, memoryTracker);
                    result = (String)result + " (" + schemaRule.userDescription((TokenNameLookup)tokenHolders) + ")";
                }
                catch (Exception e) {
                    result = (String)result + " (schema user description not available due to: " + String.valueOf(e) + ")";
                }
            }
            return result;
        };
    }

    private record ConstraintObligation(SchemaRecord schemaRecord, IndexType indexType) {
    }

    private final class BasicSchemaCheck {
        private final SchemaRecord record;
        private final StoreCursors storeCursors;

        BasicSchemaCheck(SchemaRecord record, StoreCursors storeCursors) {
            this.record = record;
            this.storeCursors = storeCursors;
        }

        public void check(SchemaDescriptor schema) {
            this.checkValidEntityTokensIds(schema);
            this.checkValidPropertyKeyIds(schema);
        }

        private void checkValidEntityTokensIds(SchemaDescriptor schema) {
            switch (schema.entityType()) {
                case NODE: {
                    for (int labelTokenId : schema.getEntityTokenIds()) {
                        RecordLoading.checkValidToken(null, labelTokenId, SchemaChecker.this.tokenHolders.labelTokens(), SchemaChecker.this.neoStores.getLabelTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).labelNotInUse((LabelTokenRecord)token), this.storeCursors, SchemaChecker.this.context.memoryTracker);
                    }
                    break;
                }
                case RELATIONSHIP: {
                    for (int relationshipTypeTokenId : schema.getEntityTokenIds()) {
                        RecordLoading.checkValidToken(null, relationshipTypeTokenId, SchemaChecker.this.tokenHolders.relationshipTypeTokens(), SchemaChecker.this.neoStores.getRelationshipTypeTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token), this.storeCursors, SchemaChecker.this.context.memoryTracker);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Schema with given entity type is not supported: " + String.valueOf(schema.entityType()));
                }
            }
        }

        private void checkValidPropertyKeyIds(SchemaDescriptor schema) {
            for (int propertyKeyId : schema.getPropertyIds()) {
                RecordLoading.checkValidToken(null, propertyKeyId, SchemaChecker.this.tokenHolders.propertyKeyTokens(), SchemaChecker.this.neoStores.getPropertyKeyTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).propertyKeyNotInUse((PropertyKeyTokenRecord)token), this.storeCursors, SchemaChecker.this.context.memoryTracker);
            }
        }
    }

    private static class MandatoryPropertiesCollector {
        private final MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties;
        private final MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties;

        MandatoryPropertiesCollector(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties) {
            this.mandatoryNodeProperties = mandatoryNodeProperties;
            this.mandatoryRelationshipProperties = mandatoryRelationshipProperties;
        }

        public void collect(SchemaDescriptor schema) {
            MutableIntObjectMap<MutableIntSet> targetMap;
            if (schema.isLabelSchemaDescriptor()) {
                targetMap = this.mandatoryNodeProperties;
            } else if (schema.isRelationshipTypeSchemaDescriptor()) {
                targetMap = this.mandatoryRelationshipProperties;
            } else {
                return;
            }
            for (int entityToken : schema.getEntityTokenIds()) {
                MutableIntSet keys = (MutableIntSet)targetMap.getIfAbsentPut(entityToken, IntHashSet::new);
                keys.addAll(schema.getPropertyIds());
            }
        }
    }

    private static class AllowedTypesCollector {
        private final MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedNodePropertyTypes;
        private final MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedRelationshipPropertyTypes;

        AllowedTypesCollector(MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedNodePropertyTypes, MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> allowedRelationshipPropertyTypes) {
            this.allowedNodePropertyTypes = allowedNodePropertyTypes;
            this.allowedRelationshipPropertyTypes = allowedRelationshipPropertyTypes;
        }

        public void collect(TypeConstraintDescriptor constraintDescriptor) {
            MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>> targetMap;
            SchemaDescriptor schema = constraintDescriptor.schema();
            if (schema.isLabelSchemaDescriptor()) {
                targetMap = this.allowedNodePropertyTypes;
            } else if (schema.isRelationshipTypeSchemaDescriptor()) {
                targetMap = this.allowedRelationshipPropertyTypes;
            } else {
                return;
            }
            for (int entityToken : schema.getEntityTokenIds()) {
                MutableIntObjectMap allowedTypesByPropertyKey = (MutableIntObjectMap)targetMap.getIfAbsentPut(entityToken, IntObjectHashMap::new);
                allowedTypesByPropertyKey.put(schema.getPropertyId(), (Object)constraintDescriptor.propertyType());
            }
        }
    }
}

