/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.Arrays;
import java.util.function.Function;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SchemaComplianceChecker
implements AutoCloseable {
    private final CheckerContext context;
    private final IntObjectMap<? extends IntSet> mandatoryProperties;
    private final IntObjectMap<? extends IntObjectMap<PropertyTypeSet>> allowedTypes;
    private final IndexAccessors.IndexReaders indexReaders;
    private final Iterable<IndexDescriptor> indexes;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private IntHashSet reportedMissingMandatoryPropertyKeys = new IntHashSet();
    private IntHashSet reportedTypeViolationPropertyKeys = new IntHashSet();

    SchemaComplianceChecker(CheckerContext context, IntObjectMap<? extends IntSet> mandatoryProperties, IntObjectMap<? extends IntObjectMap<PropertyTypeSet>> allowedTypes, Iterable<IndexDescriptor> indexes, CursorContext cursorContext, StoreCursors storeCursors) {
        this.context = context;
        this.mandatoryProperties = mandatoryProperties;
        this.allowedTypes = allowedTypes;
        this.indexReaders = context.indexAccessors.readers();
        this.indexes = indexes;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
    }

    <ENTITY extends PrimitiveRecord> void checkExistenceAndTypeConstraints(ENTITY entity, int[] entityTokens, IntObjectMap<Value> values, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        if (entityTokens.length > 0) {
            this.checkExistenceAndTypeConstraints(entity, values, entityTokens, reportSupplier);
        }
    }

    <ENTITY extends PrimitiveRecord> void checkCorrectlyIndexed(ENTITY entity, int[] entityTokens, IntObjectMap<Value> values, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        for (IndexDescriptor indexRule : this.indexes) {
            Value[] valueArray = RecordLoading.entityIntersectionWithSchema(entityTokens, values, indexRule);
            if (valueArray == null) continue;
            ValueIndexReader reader = this.indexReaders.reader(indexRule);
            if (indexRule.isUnique()) {
                this.verifyIndexedUniquely(entity, valueArray, indexRule, reader, reportSupplier);
                continue;
            }
            long count = reader.countIndexedEntities(entity.getId(), this.cursorContext, indexRule.schema().getPropertyIds(), valueArray);
            this.reportIncorrectIndexCount(entity, valueArray, indexRule, count, reportSupplier);
        }
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.indexReaders});
    }

    private <ENTITY extends PrimitiveRecord> void verifyIndexedUniquely(ENTITY entity, Value[] propertyValues, IndexDescriptor indexRule, ValueIndexReader reader, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        long nodeId = entity.getId();
        PropertyIndexQuery[] query = SchemaComplianceChecker.seek(indexRule.schema(), propertyValues);
        LongIterator indexedNodeIds = SchemaComplianceChecker.queryIndexOrEmpty(reader, query);
        long count = 0L;
        while (indexedNodeIds.hasNext()) {
            long indexedNodeId = indexedNodeIds.next();
            if (nodeId == indexedNodeId) {
                ++count;
                continue;
            }
            reportSupplier.apply(entity).uniqueIndexNotUnique(indexRule, Values.asObjects((Value[])propertyValues), indexedNodeId);
        }
        this.reportIncorrectIndexCount(entity, propertyValues, indexRule, count, reportSupplier);
    }

    private static PropertyIndexQuery[] seek(SchemaDescriptor schema, Value[] propertyValues) {
        int[] propertyIds = schema.getPropertyIds();
        assert (propertyIds.length == propertyValues.length);
        PropertyIndexQuery[] query = new PropertyIndexQuery[propertyValues.length];
        for (int i = 0; i < query.length; ++i) {
            query[i] = PropertyIndexQuery.exact((int)propertyIds[i], (Object)propertyValues[i]);
        }
        return query;
    }

    private static LongIterator queryIndexOrEmpty(ValueIndexReader reader, PropertyIndexQuery[] query) {
        try {
            NodeValueIterator indexedNodeIds = new NodeValueIterator();
            reader.query((IndexProgressor.EntityValueClient)indexedNodeIds, QueryContext.NULL_CONTEXT, CursorContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), query);
            return indexedNodeIds;
        }
        catch (IndexNotApplicableKernelException e) {
            throw new RuntimeException(String.format("Consistency checking error: index provider does not support exact query %s", Arrays.toString(query)), e);
        }
    }

    private <ENTITY extends PrimitiveRecord> void reportIncorrectIndexCount(ENTITY entity, Value[] propertyValues, IndexDescriptor indexRule, long count, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reportSupplier) {
        if (count == 0L && SchemaComplianceChecker.areValuesSupportedByIndex(indexRule, propertyValues)) {
            reportSupplier.apply(this.context.recordLoader.entity(entity, this.storeCursors, this.context.memoryTracker)).notIndexed(indexRule, Values.asObjects((Value[])propertyValues));
        } else if (count != 1L) {
            reportSupplier.apply(this.context.recordLoader.entity(entity, this.storeCursors, this.context.memoryTracker)).indexedMultipleTimes(indexRule, Values.asObjects((Value[])propertyValues), count);
        }
    }

    private <ENTITY extends PrimitiveRecord> void checkExistenceAndTypeConstraints(ENTITY entity, IntObjectMap<Value> seenProperties, int[] entityTokenIds, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reporter) {
        if (this.mandatoryProperties.isEmpty() && this.allowedTypes.isEmpty()) {
            return;
        }
        this.reportedMissingMandatoryPropertyKeys = RecordLoading.lightReplace(this.reportedMissingMandatoryPropertyKeys);
        this.reportedTypeViolationPropertyKeys = RecordLoading.lightReplace(this.reportedTypeViolationPropertyKeys);
        int[] nArray = entityTokenIds;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            IntObjectMap allowedTypesByPropertyKey;
            long entityToken = nArray[i];
            int token = Math.toIntExact(entityToken);
            IntSet mandatoryPropertyKeysForEntityToken = (IntSet)this.mandatoryProperties.get(token);
            if (mandatoryPropertyKeysForEntityToken != null) {
                this.checkPropertyExistence(entity, seenProperties, reporter, mandatoryPropertyKeysForEntityToken);
            }
            if ((allowedTypesByPropertyKey = (IntObjectMap)this.allowedTypes.get(token)) == null) continue;
            this.checkPropertyTypes(entity, seenProperties, reporter, (IntObjectMap<PropertyTypeSet>)allowedTypesByPropertyKey);
        }
    }

    private <ENTITY extends PrimitiveRecord> void checkPropertyExistence(ENTITY entity, IntObjectMap<Value> seenProperties, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reporter, IntSet mandatoryPropertyKeysForEntityToken) {
        IntIterator iterator = mandatoryPropertyKeysForEntityToken.intIterator();
        while (iterator.hasNext()) {
            int mandatoryPropertyKeyForEntityToken = iterator.next();
            if (seenProperties.containsKey(mandatoryPropertyKeyForEntityToken) || !this.reportedMissingMandatoryPropertyKeys.add(mandatoryPropertyKeyForEntityToken)) continue;
            reporter.apply(entity).missingMandatoryProperty(mandatoryPropertyKeyForEntityToken);
        }
    }

    private <ENTITY extends PrimitiveRecord> void checkPropertyTypes(ENTITY entity, IntObjectMap<Value> seenProperties, Function<ENTITY, ConsistencyReport.PrimitiveConsistencyReport> reporter, IntObjectMap<PropertyTypeSet> allowedTypesByPropertyKey) {
        for (IntObjectPair property : allowedTypesByPropertyKey.keyValuesView()) {
            int propertyKey = property.getOne();
            PropertyTypeSet allowedTypes = (PropertyTypeSet)property.getTwo();
            Value propertyValue = (Value)seenProperties.get(propertyKey);
            if (propertyValue == null || !TypeRepresentation.disallows((PropertyTypeSet)allowedTypes, (Value)propertyValue) || !this.reportedTypeViolationPropertyKeys.add(propertyKey)) continue;
            reporter.apply(entity).typeConstraintViolation(propertyKey);
        }
    }

    static boolean areValuesSupportedByIndex(IndexDescriptor index, Value ... values) {
        return values != null && index.getCapability().areValuesAccepted(values);
    }
}

