/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Arrays;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.util.BitUtils;

public class ByteArrayBitsManipulator {
    public static final int MAX_BYTES = 11;
    private static final int MAX_BITS = 88;
    public static final int MAX_SLOT_BITS = 40;
    static final long MAX_SLOT_VALUE = 0xFFFFFFFFFFL;
    private final Slot[] slots;

    public ByteArrayBitsManipulator(int ... slotsAndTheirBitCounts) {
        this.slots = ByteArrayBitsManipulator.intoSlots(slotsAndTheirBitCounts);
    }

    private static Slot[] intoSlots(int[] slotsAndTheirSizes) {
        Slot[] slots = new Slot[slotsAndTheirSizes.length];
        int bitCursor = 0;
        for (int i = 0; i < slotsAndTheirSizes.length; ++i) {
            int bits = slotsAndTheirSizes[i];
            if (bits > 1 && bitCursor % 8 != 0) {
                throw new IllegalArgumentException("Larger slots, i.e. size > 1 needs to be placed at the beginning of a byte");
            }
            if (bits > 40) {
                throw new IllegalArgumentException("Too large slot " + bits + ", biggest allowed 40");
            }
            slots[i] = new Slot(bits, bitCursor);
            bitCursor += bits;
        }
        if (bitCursor > 88) {
            throw new IllegalArgumentException("Max number of bits is 88");
        }
        return slots;
    }

    public void set(ByteArray array, long index, int slotIndex, long value) {
        this.slot(slotIndex).set(array, index, value);
    }

    public long get(ByteArray array, long index, int slotIndex) {
        return this.slot(slotIndex).get(array, index);
    }

    private Slot slot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.slots.length) {
            throw new IllegalArgumentException("Invalid slot " + slotIndex + ", I've got " + String.valueOf(this));
        }
        return this.slots[slotIndex];
    }

    public String toString() {
        return Arrays.toString(this.slots);
    }

    private static class Slot {
        private final int byteOffset;
        private final int bitOffset;
        private final int bitCount;
        private final long mask;
        private final int fbMask;

        Slot(int bits, int absoluteBitOffset) {
            this.byteOffset = absoluteBitOffset / 8;
            this.bitOffset = absoluteBitOffset % 8;
            this.bitCount = bits;
            this.mask = (1L << bits) - 1L;
            this.fbMask = 1 << this.bitOffset;
        }

        public long get(ByteArray array, long index) {
            if (this.bitCount == 1) {
                int field = array.getByte(index, this.byteOffset) & 0xFF;
                boolean bitIsSet = (field & this.fbMask) != 0;
                return bitIsSet ? -1L : 0L;
            }
            if (this.bitCount == 16) {
                long raw = (long)array.getShort(index, this.byteOffset) & this.mask;
                return raw == this.mask ? -1L : raw;
            }
            long field = array.get5ByteLong(index, this.byteOffset);
            long raw = field & this.mask;
            return raw == this.mask ? -1L : raw;
        }

        public void set(ByteArray array, long index, long value) {
            if (value < -1L || value > this.mask) {
                throw new IllegalStateException("Invalid value " + value + ", max is " + this.mask);
            }
            if (this.bitCount == 1) {
                int field = array.getByte(index, this.byteOffset) & 0xFF;
                int otherBits = field & ~this.fbMask;
                array.setByte(index, this.byteOffset, (byte)((long)otherBits | value << this.bitOffset));
            } else if (this.bitCount == 16) {
                array.setShort(index, this.byteOffset, (short)value);
            } else {
                long field = array.get5ByteLong(index, this.byteOffset);
                long otherBits = field & (this.mask ^ 0xFFFFFFFFFFFFFFFFL);
                array.set5ByteLong(index, this.byteOffset, value | otherBits);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + BitUtils.numbersToBitString((long[])new long[]{this.mask << this.bitOffset}) + "]";
        }
    }
}

