/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.neo4j.consistency.checking.IdAssigningThreadLocal;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.PackedMultiFieldCache;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.memory.MemoryTracker;

public class DefaultCacheAccess
implements CacheAccess {
    private final IdAssigningThreadLocal<CacheAccess.Client> clients = new IdAssigningThreadLocal<CacheAccess.Client>(){

        @Override
        protected CacheAccess.Client initialValue(int id) {
            return new DefaultClient(id);
        }
    };
    private final PackedMultiFieldCache cache;
    private long pivotId;

    public static ByteArray defaultByteArray(long highNodeId, MemoryTracker memoryTracker) {
        return NumberArrayFactories.AUTO_WITHOUT_SWAP.newByteArray(highNodeId, new byte[11], memoryTracker);
    }

    public DefaultCacheAccess(ByteArray array) {
        this.cache = new PackedMultiFieldCache(array, 40, 1);
    }

    @Override
    public CacheAccess.Client client() {
        return (CacheAccess.Client)this.clients.get();
    }

    @Override
    public void clearCache() {
        this.cache.clearParallel(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public void setCacheSlotSizes(int ... slotSizes) {
        this.cache.setSlotSizes(slotSizes);
    }

    @Override
    public void setCacheSlotSizesAndClear(int ... slotSizes) {
        this.cache.setSlotSizes(slotSizes);
        this.cache.clearParallel(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public void setPivotId(long pivotId) {
        this.pivotId = pivotId;
    }

    private long translate(long id) {
        return id - this.pivotId;
    }

    private class DefaultClient
    implements CacheAccess.Client {
        private final int threadIndex;

        DefaultClient(int threadIndex) {
            this.threadIndex = threadIndex;
        }

        @Override
        public long getFromCache(long id, int slot) {
            return DefaultCacheAccess.this.cache.get(DefaultCacheAccess.this.translate(id), slot);
        }

        @Override
        public boolean getBooleanFromCache(long id, int slot) {
            return DefaultCacheAccess.this.cache.get(DefaultCacheAccess.this.translate(id), slot) != 0L;
        }

        @Override
        public void putToCache(long id, long ... values) {
            DefaultCacheAccess.this.cache.put(DefaultCacheAccess.this.translate(id), values);
        }

        @Override
        public void putToCacheSingle(long id, int slot, long value) {
            DefaultCacheAccess.this.cache.put(DefaultCacheAccess.this.translate(id), slot, value);
        }

        public String toString() {
            return "Client[" + this.threadIndex + "]";
        }
    }
}

