/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.RelationshipGroupCache;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.memory.MemoryTracker;

public class CountGroupsStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private final RelationshipGroupCache cache;

    public CountGroupsStep(StageControl control, Configuration config, RelationshipGroupCache groupCache, CursorContextFactory contextFactory, StatsProvider ... additionalStatsProviders) {
        super(control, "COUNT", config, 1, contextFactory, additionalStatsProviders);
        this.cache = groupCache;
    }

    protected void process(RelationshipGroupRecord[] batch, BatchSender sender, CursorContext cursorContext, MemoryTracker memoryTracker) {
        for (RelationshipGroupRecord record : batch) {
            if (!record.inUse()) continue;
            this.cache.incrementGroupCount(record.getOwningNode());
        }
    }
}

