/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.batchimport.BatchingIdGetter;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.SchemaMonitor;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class EntityImporter
extends InputEntityVisitor.Adapter {
    private static final String ENTITY_IMPORTER_TAG = "entityImporter";
    private final TokenHolder propertyKeyTokenRepository;
    private final PropertyStore propertyStore;
    private final PropertyRecord propertyRecord;
    private final PageCursor propertyUpdateCursor;
    protected final StoreCursors storeCursors;
    protected final StoreCursors tempStoreCursors;
    protected final String storeFormat;
    private PropertyBlock[] propertyBlocks = new PropertyBlock[100];
    private int propertyBlocksCursor;
    private final BatchingIdGetter propertyIds;
    private final BatchingIdGetter stringPropertyIds;
    private final BatchingIdGetter arrayPropertyIds;
    protected final DataImporter.Monitor monitor;
    protected final MemoryTracker memoryTracker;
    protected final SchemaMonitor schemaMonitor;
    private long propertyCount;
    protected int entityPropertyCount;
    private boolean hasPropertyId;
    private long propertyId;
    private final DynamicRecordAllocator dynamicStringRecordAllocator;
    private final DynamicRecordAllocator dynamicArrayRecordAllocator;
    protected final CursorContext cursorContext;

    EntityImporter(BatchingNeoStores stores, DataImporter.Monitor monitor, CursorContextFactory contextFactory, MemoryTracker memoryTracker, SchemaMonitor schemaMonitor) {
        this.cursorContext = contextFactory.create(ENTITY_IMPORTER_TAG);
        this.storeCursors = new CachedStoreCursors(stores.getNeoStores(), this.cursorContext);
        this.tempStoreCursors = new CachedStoreCursors(stores.getTemporaryNeoStores(), this.cursorContext);
        this.propertyStore = stores.getPropertyStore();
        this.propertyKeyTokenRepository = stores.getTokenHolders().propertyKeyTokens();
        this.monitor = monitor;
        this.memoryTracker = memoryTracker;
        this.schemaMonitor = schemaMonitor;
        for (int i = 0; i < this.propertyBlocks.length; ++i) {
            this.propertyBlocks[i] = new PropertyBlock();
        }
        this.propertyRecord = this.propertyStore.newRecord();
        this.propertyIds = EntityImporter.batchingIdGetter(this.propertyStore);
        this.stringPropertyIds = EntityImporter.batchingIdGetter(this.propertyStore.getStringStore());
        this.dynamicStringRecordAllocator = new StandardDynamicRecordAllocator((IdSequence)this.stringPropertyIds, this.propertyStore.getStringStore().getRecordDataSize());
        this.arrayPropertyIds = EntityImporter.batchingIdGetter(this.propertyStore.getArrayStore());
        this.dynamicArrayRecordAllocator = new StandardDynamicRecordAllocator((IdSequence)this.arrayPropertyIds, this.propertyStore.getStringStore().getRecordDataSize());
        this.propertyUpdateCursor = this.propertyStore.openPageCursorForWriting(0L, this.cursorContext);
        this.storeFormat = (String)stores.getNeo4jConfig().get(GraphDatabaseSettings.db_format);
    }

    static BatchingIdGetter batchingIdGetter(CommonAbstractStore<? extends AbstractBaseRecord, ?> store) {
        return new BatchingIdGetter(store.getIdGenerator(), store.getRecordsPerPage());
    }

    public boolean property(String key, Object value, boolean identifier) {
        assert (!this.hasPropertyId);
        try {
            return this.property(this.propertyKeyTokenRepository.getOrCreateId(key), value, identifier);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean property(int propertyKeyId, Object value, boolean identifier) {
        assert (!this.hasPropertyId);
        this.encodeProperty(this.nextPropertyBlock(), propertyKeyId, value);
        ++this.entityPropertyCount;
        this.schemaMonitor.property(propertyKeyId, value, identifier);
        return true;
    }

    public boolean propertyId(long nextProp) {
        assert (!this.hasPropertyId);
        this.hasPropertyId = true;
        this.propertyId = nextProp;
        return true;
    }

    public void reset() {
        this.propertyBlocksCursor = 0;
        this.hasPropertyId = false;
        this.propertyCount += (long)this.entityPropertyCount;
        this.entityPropertyCount = 0;
    }

    private PropertyBlock nextPropertyBlock() {
        if (this.propertyBlocksCursor == this.propertyBlocks.length) {
            this.propertyBlocks = Arrays.copyOf(this.propertyBlocks, this.propertyBlocksCursor * 2);
            for (int i = this.propertyBlocksCursor; i < this.propertyBlocks.length; ++i) {
                this.propertyBlocks[i] = new PropertyBlock();
            }
        }
        return this.propertyBlocks[this.propertyBlocksCursor++];
    }

    private void encodeProperty(PropertyBlock block, int key, Object property) {
        Value value = property instanceof Value ? (Value)property : Values.of((Object)property);
        PropertyStore.encodeValue(block, key, value, this.dynamicStringRecordAllocator, this.dynamicArrayRecordAllocator, this.cursorContext, this.memoryTracker, this.storeFormat);
    }

    protected Map<String, Object> namedProperties(IntObjectMap<Value> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        properties.forEachKeyValue((IntObjectProcedure & Serializable)(keyId, value) -> {
            try {
                result.put(this.propertyKeyTokenRepository.getTokenById(keyId).name(), value.asObjectCopy());
            }
            catch (TokenNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    long createAndWritePropertyChain(CursorContext cursorContext) {
        if (this.hasPropertyId) {
            return this.propertyId;
        }
        if (this.propertyBlocksCursor == 0) {
            return Record.NO_NEXT_PROPERTY.longValue();
        }
        PropertyRecord currentRecord = this.propertyRecord(this.propertyIds.nextId(cursorContext));
        long firstRecordId = currentRecord.getId();
        for (int i = 0; i < this.propertyBlocksCursor; ++i) {
            PropertyBlock block = this.propertyBlocks[i];
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                long nextPropertyId = this.propertyIds.nextId(cursorContext);
                long prevId = currentRecord.getId();
                currentRecord.setNextProp(nextPropertyId);
                this.propertyStore.updateRecord(currentRecord, IdUpdateListener.IGNORE, this.propertyUpdateCursor, cursorContext, this.storeCursors);
                currentRecord = this.propertyRecord(nextPropertyId);
                currentRecord.setPrevProp(prevId);
            }
            currentRecord.addPropertyBlock(block);
        }
        if (currentRecord.size() > 0) {
            this.propertyStore.updateRecord(currentRecord, IdUpdateListener.IGNORE, this.propertyUpdateCursor, cursorContext, this.storeCursors);
        }
        return firstRecordId;
    }

    protected abstract PrimitiveRecord primitiveRecord();

    private PropertyRecord propertyRecord(long nextPropertyId) {
        this.propertyRecord.clear();
        this.propertyRecord.setInUse(true);
        this.propertyRecord.setId(nextPropertyId);
        this.primitiveRecord().setIdTo(this.propertyRecord);
        this.propertyRecord.setCreated();
        return this.propertyRecord;
    }

    public boolean applicationMode(ApplicationMode mode) {
        if (mode != ApplicationMode.CREATE) {
            throw new UnsupportedOperationException("Only supports creating new entities");
        }
        return true;
    }

    public void close() {
        this.monitor.propertiesImported(this.propertyCount);
        this.propertyUpdateCursor.close();
        this.storeCursors.close();
        this.tempStoreCursors.close();
    }

    void freeUnusedIds() {
        this.propertyIds.markUnusedIdsAsDeleted(this.cursorContext);
        this.stringPropertyIds.markUnusedIdsAsDeleted(this.cursorContext);
        this.arrayPropertyIds.markUnusedIdsAsDeleted(this.cursorContext);
    }

    static void freeUnusedId(CommonAbstractStore<?, ?> store, long id, CursorContext cursorContext) {
        try (IdGenerator.TransactionalMarker marker = store.getIdGenerator().transactionalMarker(cursorContext);){
            marker.markDeleted(id);
        }
    }
}

