/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.batchimport.BatchingIdGetter;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.EntityImporter;
import org.neo4j.internal.batchimport.SchemaMonitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.KeyCollisionException;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProviders;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeImporter
extends EntityImporter {
    private final TokenHolder labelTokenRepository;
    private final NodeStore nodeStore;
    private final Collector badCollector;
    private final NodeRecord nodeRecord;
    private final IdMapper idMapper;
    private final IdMapper.Setter idMapperSetter;
    private final BatchingIdGetter nodeIds;
    private final PropertyStore idPropertyStore;
    private final PropertyRecord idPropertyRecord;
    private final PropertyBlock idPropertyBlock = new PropertyBlock();
    private final PageCursor nodeUpdateCursor;
    private final PageCursor idPropertyUpdateCursor;
    private final Set<String> labels = new HashSet<String>();
    private final DynamicAllocatorProvider allocatorProvider;
    private long nodeCount;
    private long highestId = -1L;
    private boolean hasLabelField;
    private Object inputId;
    private Group group;
    private boolean hasExternallyChosenIds;

    NodeImporter(BatchingNeoStores stores, IdMapper idMapper, DataImporter.Monitor monitor, Collector badCollector, CursorContextFactory contextFactory, MemoryTracker memoryTracker, SchemaMonitor schemaMonitor) {
        super(stores, monitor, contextFactory, memoryTracker, schemaMonitor);
        this.labelTokenRepository = stores.getTokenHolders().labelTokens();
        this.idMapper = idMapper;
        this.idMapperSetter = idMapper.newSetter();
        this.nodeStore = stores.getNodeStore();
        this.badCollector = badCollector;
        this.nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        this.nodeIds = NodeImporter.batchingIdGetter(this.nodeStore);
        this.idPropertyStore = stores.getTemporaryPropertyStore();
        this.idPropertyRecord = this.idPropertyStore.newRecord();
        this.nodeUpdateCursor = this.nodeStore.openPageCursorForWriting(0L, this.cursorContext);
        this.idPropertyUpdateCursor = this.idPropertyStore.openPageCursorForWriting(0L, this.cursorContext);
        this.allocatorProvider = DynamicAllocatorProviders.nonTransactionalAllocator(stores.getNeoStores());
        this.nodeRecord.setInUse(true);
    }

    public boolean id(long id) {
        this.nodeRecord.setId(id);
        this.highestId = Long.max(this.highestId, id);
        this.hasExternallyChosenIds = true;
        return true;
    }

    public boolean id(Object id, Group group) {
        return this.assignId(id, group, (IdSequence)this.nodeIds);
    }

    public boolean id(Object id, Group group, IdSequence idSequence) {
        this.hasExternallyChosenIds = true;
        return this.assignId(id, group, idSequence);
    }

    private boolean assignId(Object id, Group group, IdSequence idSequence) {
        this.inputId = id;
        this.group = group;
        long nodeId = idSequence.nextId(this.cursorContext);
        this.nodeRecord.setId(nodeId);
        this.highestId = Long.max(this.highestId, nodeId);
        if (id != null) {
            PropertyStore.encodeValue(this.idPropertyBlock, 0, Values.of((Object)id), this.allocatorProvider.allocator(StoreType.PROPERTY_STRING), this.allocatorProvider.allocator(StoreType.PROPERTY_ARRAY), this.cursorContext, this.memoryTracker, this.storeFormat);
            this.idPropertyRecord.addPropertyBlock(this.idPropertyBlock);
            this.idPropertyRecord.setId(nodeId);
            this.idPropertyRecord.setInUse(true);
            this.idPropertyStore.updateRecord(this.idPropertyRecord, IdUpdateListener.IGNORE, this.idPropertyUpdateCursor, this.cursorContext, this.tempStoreCursors);
            this.idPropertyRecord.clear();
        }
        return true;
    }

    public boolean labels(String[] labels) {
        assert (!this.hasLabelField);
        Collections.addAll(this.labels, labels);
        return true;
    }

    public boolean labelField(long labelField) {
        this.hasLabelField = true;
        this.nodeRecord.setLabelField(labelField, Collections.emptyList());
        return true;
    }

    public void endOfEntity() {
        if (this.nodeRecord.getId() == Record.NULL_REFERENCE.longValue()) {
            this.nodeRecord.setId(this.nodeIds.nextId(this.cursorContext));
        }
        if (!this.hasLabelField && !this.labels.isEmpty()) {
            String[] labelsArray = this.labels.toArray(new String[0]);
            int[] labelIdsInts = new int[labelsArray.length];
            try {
                this.labelTokenRepository.getOrCreateIds(labelsArray, labelIdsInts);
                Arrays.sort(labelIdsInts);
                this.schemaMonitor.entityTokens(labelIdsInts);
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
            InlineNodeLabels.putSorted(this.nodeRecord, labelIdsInts, null, this.allocatorProvider.allocator(StoreType.NODE_LABEL), this.cursorContext, this.storeCursors, this.memoryTracker);
            this.labels.clear();
        }
        try {
            if (this.schemaMonitor.endOfEntity(this.nodeRecord.getId(), SchemaMonitor.NO_EXISTING_PROPERTY_KEYS_LOOKUP, (entityId, tokens, properties, constraintDescription) -> this.badCollector.collectEntityViolatingConstraint(this.inputId, entityId, this.namedProperties((IntObjectMap<Value>)properties), constraintDescription, EntityType.NODE))) {
                if (this.inputId != null) {
                    this.idMapperSetter.put(this.inputId, this.nodeRecord.getId(), this.group);
                }
                this.nodeRecord.setNextProp(this.createAndWritePropertyChain(this.cursorContext));
                this.nodeRecord.setInUse(true);
                this.nodeStore.updateRecord(this.nodeRecord, IdUpdateListener.IGNORE, this.nodeUpdateCursor, this.cursorContext, this.storeCursors);
                ++this.nodeCount;
            } else {
                NodeImporter.freeUnusedId(this.nodeStore, this.nodeRecord.getId(), this.cursorContext);
            }
        }
        catch (KeyCollisionException e) {
            this.badCollector.collectDuplicateNode(this.inputId, Record.NULL_REFERENCE.longValue(), this.group);
            NodeImporter.freeUnusedId(this.nodeStore, this.nodeRecord.getId(), this.cursorContext);
        }
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.nodeRecord.clear();
        this.nodeRecord.setId(Record.NULL_REFERENCE.longValue());
        this.hasLabelField = false;
        this.labels.clear();
        this.inputId = null;
        this.group = null;
    }

    @Override
    protected PrimitiveRecord primitiveRecord() {
        return this.nodeRecord;
    }

    @Override
    public void close() {
        super.close();
        this.monitor.nodesImported(this.nodeCount);
        this.nodeStore.getIdGenerator().setHighestPossibleIdInUse(this.highestId);
        this.nodeUpdateCursor.close();
        this.idPropertyUpdateCursor.close();
        this.cursorContext.close();
        if (this.hasExternallyChosenIds) {
            this.monitor.noteExternallyChosenNodeIds();
        }
    }

    @Override
    void freeUnusedIds() {
        super.freeUnusedIds();
        this.nodeIds.markUnusedIdsAsDeleted(this.cursorContext);
    }
}

