/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Supplier;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeInputIdPropertyLookup
implements PropertyValueLookup {
    private final PropertyStore propertyStore;
    private final Supplier<StoreCursors> storeCursors;

    NodeInputIdPropertyLookup(PropertyStore propertyStore, Supplier<StoreCursors> storeCursors) {
        this.propertyStore = propertyStore;
        this.storeCursors = storeCursors;
    }

    public PropertyValueLookup.Lookup newLookup(final boolean readOnly) {
        final StoreCursors cursors = this.storeCursors.get();
        final PropertyRecord propertyRecord = this.propertyStore.newRecord();
        return new PropertyValueLookup.Lookup(){

            public Object lookupProperty(long nodeId, MemoryTracker memoryTracker) {
                if (readOnly) {
                    return this.lookup(nodeId, propertyRecord, cursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR), memoryTracker, cursors);
                }
                try (PageCursor cursor = cursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);){
                    Object object = this.lookup(nodeId, propertyRecord, cursor, memoryTracker, cursors);
                    return object;
                }
            }

            private Object lookup(long nodeId, PropertyRecord propertyRecord2, PageCursor cursor, MemoryTracker memoryTracker, StoreCursors cursors2) {
                NodeInputIdPropertyLookup.this.propertyStore.getRecordByCursor(nodeId, propertyRecord2, RecordLoad.CHECK, cursor, memoryTracker);
                if (!propertyRecord2.inUse()) {
                    return null;
                }
                return ((PropertyBlock)Iterables.first(propertyRecord2.propertyBlocks())).newPropertyValue(NodeInputIdPropertyLookup.this.propertyStore, cursors2, memoryTracker).asObject();
            }

            public void close() {
                cursors.close();
            }
        };
    }
}

