/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.ReadGroupRecordsByCacheStep;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.UpdateRecordsStep;
import org.neo4j.internal.batchimport.cache.legacy.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.store.StorePrepareIdSequence;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipGroupStage
extends Stage {
    public static final String NAME = "RelationshipGroup";

    RelationshipGroupStage(String topic, Configuration config, RecordStore<RelationshipGroupRecord> store, NodeRelationshipCache cache, CursorContextFactory contextFactory, Function<CursorContext, StoreCursors> storeCursorsCreator) {
        super(NAME, topic, config, 0);
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterator.forwards((long)0L, (long)cache.highNodeId(), (Configuration)config), 10));
        this.add((Step)new ReadGroupRecordsByCacheStep(this.control(), config, store, cache, contextFactory));
        this.add((Step)new UpdateRecordsStep<RelationshipGroupRecord>(this.control(), config, store, new StorePrepareIdSequence(), contextFactory, storeCursorsCreator, RecordCursorTypes.GROUP_CURSOR));
    }
}

