/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.common.EntityType;
import org.neo4j.internal.recordstorage.CommandVisitor;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.PropertyRecordChange;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommand;
import org.neo4j.string.Mask;
import org.neo4j.token.api.TokenIdPrettyPrinter;

public abstract class Command
implements StorageCommand {
    private static final int RECOVERY_LOCK_TYPE_PROPERTY = 0;
    private static final int RECOVERY_LOCK_TYPE_PROPERTY_DYNAMIC = 1;
    private static final int RECOVERY_LOCK_TYPE_NODE_LABEL_DYNAMIC = 2;
    private static final int RECOVERY_LOCK_TYPE_RELATIONSHIP_GROUP = 3;
    public static final int RECOVERY_LOCK_TYPE_SCHEMA_RULE = 4;
    public static final int RECOVERY_LOCK_TYPE_SCHEMA_BOUNDARY = 5;
    protected final LogCommandSerialization serialization;
    private int keyHash;
    private long key;
    private Mode mode;

    public Command(LogCommandSerialization serialization) {
        this.serialization = serialization;
    }

    protected final void setup(long key, Mode mode) {
        this.mode = mode;
        this.keyHash = (int)(key >>> 32 ^ key);
        this.key = key;
    }

    public KernelVersion kernelVersion() {
        return this.serialization.kernelVersion();
    }

    public int hashCode() {
        return this.keyHash;
    }

    public final String toString() {
        return this.toString(Mask.NO);
    }

    public abstract String toString(Mask var1);

    public long getKey() {
        return this.key;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass().equals(this.getClass()) && this.getKey() == ((Command)o).getKey();
    }

    public abstract boolean handle(CommandVisitor var1) throws IOException;

    public void lockForRecovery(LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
    }

    protected void takeSchemaBoundaryLockForRecovery(LockService lockService, LockGroup lockGroup, EntityType entityType, LockType lockType) {
        lockGroup.add(lockService.acquireCustomLock(5, (long)entityType.ordinal(), lockType));
    }

    protected static String beforeAndAfterToString(AbstractBaseRecord before, AbstractBaseRecord after, Mask mask) {
        return String.format("\t-%s%n\t+%s", before.toString(mask), after.toString(mask));
    }

    public static enum Mode {
        CREATE,
        UPDATE,
        DELETE;


        public static Mode fromRecordState(boolean created, boolean inUse) {
            if (!inUse) {
                return DELETE;
            }
            if (created) {
                return CREATE;
            }
            return UPDATE;
        }

        public static Mode fromRecordState(AbstractBaseRecord record) {
            return Mode.fromRecordState(record.isCreated(), record.inUse());
        }
    }

    public static class RecordEnrichmentCommand
    extends Command
    implements EnrichmentCommand {
        private final Enrichment enrichment;

        public RecordEnrichmentCommand(LogCommandSerialization serialization, Enrichment enrichment) {
            super(serialization);
            this.enrichment = Objects.requireNonNull(enrichment);
            this.setup();
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeEnrichmentCommand(channel, this);
        }

        public Enrichment enrichment() {
            return this.enrichment;
        }

        @Override
        public String toString(Mask mask) {
            return "RecordEnrichmentCommand[" + this.enrichment.metadata().toString(mask) + "]";
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return false;
        }

        private void setup() {
            this.setup(this.enrichment.metadata().lastCommittedTx(), Mode.CREATE);
        }
    }

    public static class GroupDegreeCommand
    extends Command {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(GroupDegreeCommand.class);
        private final long groupId;
        private final RelationshipDirection direction;
        private final long delta;

        public GroupDegreeCommand(LogCommandSerialization serialization, long groupId, RelationshipDirection direction, long delta) {
            super(serialization);
            this.setup(GroupDegreeCommand.combinedKeyOnGroupAndDirection(groupId, direction), Mode.UPDATE);
            this.groupId = groupId;
            this.direction = direction;
            this.delta = delta;
        }

        @Override
        public String toString(Mask mask) {
            return String.format("GroupDegree[(group:%s, %s) %s %d]", this.groupId, this.direction, this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitGroupDegreeCommand(this);
        }

        public long groupId() {
            return this.groupId;
        }

        public RelationshipDirection direction() {
            return this.direction;
        }

        public long delta() {
            return this.delta;
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeGroupDegreeCommand(channel, this);
        }

        public static long combinedKeyOnGroupAndDirection(long groupId, RelationshipDirection direction) {
            return groupId << 2 | (long)direction.id();
        }

        public static long groupIdFromCombinedKey(long key) {
            return key >> 2;
        }

        public static RelationshipDirection directionFromCombinedKey(long key) {
            return RelationshipDirection.ofId((int)((int)(key & 3L)));
        }
    }

    public static class RelationshipCountsCommand
    extends Command {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipCountsCommand.class);
        private final int startLabelId;
        private final int typeId;
        private final int endLabelId;
        private final long delta;

        public RelationshipCountsCommand(LogCommandSerialization serialization, int startLabelId, int typeId, int endLabelId, long delta) {
            super(serialization);
            this.setup(typeId, Mode.UPDATE);
            this.startLabelId = startLabelId;
            this.typeId = typeId;
            this.endLabelId = endLabelId;
            this.delta = delta;
        }

        @Override
        public String toString(Mask mask) {
            return String.format("UpdateCounts[(%s)-%s->(%s) %s %d]", TokenIdPrettyPrinter.label((int)this.startLabelId), TokenIdPrettyPrinter.relationshipType((int)this.typeId), TokenIdPrettyPrinter.label((int)this.endLabelId), this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipCountsCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeRelationshipCountsCommand(channel, this);
        }

        public int startLabelId() {
            return this.startLabelId;
        }

        public int typeId() {
            return this.typeId;
        }

        public int endLabelId() {
            return this.endLabelId;
        }

        public long delta() {
            return this.delta;
        }
    }

    public static class NodeCountsCommand
    extends Command {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeCountsCommand.class);
        private final int labelId;
        private final long delta;

        public NodeCountsCommand(LogCommandSerialization serialization, int labelId, long delta) {
            super(serialization);
            this.setup(labelId, Mode.UPDATE);
            this.labelId = labelId;
            this.delta = delta;
        }

        @Override
        public String toString(Mask mask) {
            return String.format("UpdateCounts[(%s) %s %d]", TokenIdPrettyPrinter.label((int)this.labelId), this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitNodeCountsCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeNodeCountsCommand(channel, this);
        }

        public int labelId() {
            return this.labelId;
        }

        public long delta() {
            return this.delta;
        }
    }

    public static class SchemaRuleCommand
    extends BaseCommand<SchemaRecord> {
        private final SchemaRule schemaRule;
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(SchemaRuleCommand.class);

        public SchemaRuleCommand(LogCommandSerialization serialization, SchemaRecord recordBefore, SchemaRecord recordAfter, SchemaRule schemaRule) {
            super(serialization, recordBefore, recordAfter);
            this.schemaRule = schemaRule;
        }

        @Override
        public String toString(Mask mask) {
            String beforeAndAfterRecords = super.toString(mask);
            if (this.schemaRule != null) {
                return beforeAndAfterRecords + " : " + this.schemaRule.toString(mask);
            }
            return beforeAndAfterRecords;
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitSchemaRuleCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeSchemaRuleCommand(channel, this);
        }

        @Override
        public void lockForRecovery(LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
            this.takeSchemaBoundaryLockForRecovery(lockService, lockGroup, this.schemaRule.schema().entityType(), LockType.EXCLUSIVE);
        }

        public SchemaRule getSchemaRule() {
            return this.schemaRule;
        }
    }

    public static class LabelTokenCommand
    extends TokenCommand<LabelTokenRecord> {
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(LabelTokenCommand.class);

        public LabelTokenCommand(LogCommandSerialization serialization, LabelTokenRecord before, LabelTokenRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitLabelTokenCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeLabelTokenCommand(channel, this);
        }
    }

    public static class RelationshipTypeTokenCommand
    extends TokenCommand<RelationshipTypeTokenRecord> {
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipTypeTokenCommand.class);

        public RelationshipTypeTokenCommand(LogCommandSerialization serialization, RelationshipTypeTokenRecord before, RelationshipTypeTokenRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipTypeTokenCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeRelationshipTypeTokenCommand(channel, this);
        }
    }

    public static class PropertyKeyTokenCommand
    extends TokenCommand<PropertyKeyTokenRecord> {
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(PropertyKeyTokenCommand.class);

        public PropertyKeyTokenCommand(LogCommandSerialization serialization, PropertyKeyTokenRecord before, PropertyKeyTokenRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitPropertyKeyTokenCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writePropertyKeyTokenCommand(channel, this);
        }
    }

    public static abstract class TokenCommand<RECORD extends TokenRecord>
    extends BaseCommand<RECORD>
    implements StorageCommand.TokenCommand {
        public TokenCommand(LogCommandSerialization serialization, RECORD before, RECORD after) {
            super(serialization, before, after);
        }

        public int tokenId() {
            return Math.toIntExact(this.getKey());
        }

        public boolean isInternal() {
            return ((TokenRecord)this.getAfter()).isInternal();
        }
    }

    public static class PropertyCommand
    extends BaseCommand<PropertyRecord>
    implements PropertyRecordChange {
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(PropertyCommand.class);

        public PropertyCommand(LogCommandSerialization serialization, PropertyRecord before, PropertyRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitPropertyCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            switch (this.getMode().ordinal()) {
                case 0: {
                    this.serialization.writeCreatedPropertyCommand(channel, this);
                    break;
                }
                case 2: {
                    this.serialization.writeDeletedPropertyCommand(channel, this);
                    break;
                }
                case 1: {
                    this.serialization.writePropertyCommand(channel, this);
                }
            }
        }

        public long getEntityId() {
            return ((PropertyRecord)this.after).isNodeSet() ? ((PropertyRecord)this.after).getNodeId() : ((PropertyRecord)this.after).getRelId();
        }

        public long getNodeId() {
            return ((PropertyRecord)this.after).getNodeId();
        }

        public long getRelId() {
            return ((PropertyRecord)this.after).getRelId();
        }

        public long getSchemaRuleId() {
            return ((PropertyRecord)this.after).getSchemaRuleId();
        }

        @Override
        public void lockForRecovery(LockService lockService, LockGroup locks, TransactionApplicationMode mode) {
            if (((PropertyRecord)this.after).isNodeSet()) {
                locks.add(lockService.acquireNodeLock(this.getNodeId(), LockType.EXCLUSIVE));
            } else if (((PropertyRecord)this.after).isRelSet()) {
                locks.add(lockService.acquireRelationshipLock(this.getRelId(), LockType.EXCLUSIVE));
            } else if (((PropertyRecord)this.after).isSchemaSet()) {
                locks.add(lockService.acquireCustomLock(4, this.getSchemaRuleId(), LockType.EXCLUSIVE));
            }
            PropertyRecord record = (PropertyRecord)this.record(mode);
            for (DynamicRecord deletedRecord : record.getDeletedRecords()) {
                locks.add(lockService.acquireCustomLock(1, deletedRecord.getId(), LockType.EXCLUSIVE));
            }
            for (PropertyBlock block : record.propertyBlocks()) {
                for (DynamicRecord valueRecord : block.getValueRecords()) {
                    locks.add(lockService.acquireCustomLock(1, valueRecord.getId(), LockType.EXCLUSIVE));
                }
            }
            if (this.getMode() == Mode.CREATE || this.getMode() == Mode.DELETE) {
                locks.add(lockService.acquireCustomLock(0, ((PropertyRecord)this.after).getId(), LockType.EXCLUSIVE));
            }
        }
    }

    public static class MetaDataCommand
    extends BaseCommand<MetaDataRecord>
    implements StorageCommand.VersionUpgradeCommand {
        MetaDataCommand(LogCommandSerialization serialization, MetaDataRecord before, MetaDataRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitMetaDataCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeMetaDataCommand(channel, this);
        }
    }

    public static class RelationshipGroupCommand
    extends BaseCommand<RelationshipGroupRecord> {
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipGroupCommand.class);

        public RelationshipGroupCommand(LogCommandSerialization serialization, RelationshipGroupRecord before, RelationshipGroupRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipGroupCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            this.serialization.writeRelationshipGroupCommand(channel, this);
        }

        @Override
        public void lockForRecovery(LockService lockService, LockGroup locks, TransactionApplicationMode mode) {
            locks.add(lockService.acquireNodeLock(((RelationshipGroupRecord)this.after).getOwningNode(), LockType.EXCLUSIVE));
            if (this.getMode() == Mode.CREATE || this.getMode() == Mode.DELETE) {
                locks.add(lockService.acquireCustomLock(3, ((RelationshipGroupRecord)this.after).getId(), LockType.EXCLUSIVE));
            }
        }
    }

    public static class RelationshipCommand
    extends BaseCommand<RelationshipRecord> {
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipCommand.class);

        public RelationshipCommand(LogCommandSerialization serialization, RelationshipRecord before, RelationshipRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            switch (this.getMode().ordinal()) {
                case 0: {
                    this.serialization.writeCreatedRelationshipCommand(channel, this);
                    break;
                }
                case 2: {
                    this.serialization.writeDeletedRelationshipCommand(channel, this);
                    break;
                }
                case 1: {
                    this.serialization.writeRelationshipCommand(channel, this);
                }
            }
        }

        @Override
        public void lockForRecovery(LockService lockService, LockGroup locks, TransactionApplicationMode mode) {
            this.takeSchemaBoundaryLockForRecovery(lockService, locks, EntityType.RELATIONSHIP, LockType.SHARED);
            locks.add(lockService.acquireRelationshipLock(this.getKey(), LockType.EXCLUSIVE));
        }
    }

    public static class NodeCommand
    extends BaseCommand<NodeRecord> {
        static final long HEAP_SIZE = HeapEstimator.shallowSizeOfInstance(NodeCommand.class);

        public NodeCommand(LogCommandSerialization serialization, NodeRecord before, NodeRecord after) {
            super(serialization, before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitNodeCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            switch (this.getMode().ordinal()) {
                case 0: {
                    this.serialization.writeCreatedNodeCommand(channel, this);
                    break;
                }
                case 2: {
                    this.serialization.writeDeletedNodeCommand(channel, this);
                    break;
                }
                case 1: {
                    this.serialization.writeNodeCommand(channel, this);
                }
            }
        }

        @Override
        public void lockForRecovery(LockService lockService, LockGroup locks, TransactionApplicationMode mode) {
            this.takeSchemaBoundaryLockForRecovery(lockService, locks, EntityType.NODE, LockType.SHARED);
            locks.add(lockService.acquireNodeLock(this.getKey(), LockType.EXCLUSIVE));
            for (DynamicRecord dynamicLabelRecord : ((NodeRecord)this.record(mode)).getDynamicLabelRecords()) {
                locks.add(lockService.acquireCustomLock(2, dynamicLabelRecord.getId(), LockType.EXCLUSIVE));
            }
        }
    }

    public static abstract class BaseCommand<RECORD extends AbstractBaseRecord>
    extends Command {
        protected final RECORD before;
        protected final RECORD after;

        public BaseCommand(LogCommandSerialization serialization, RECORD before, RECORD after) {
            super(serialization);
            this.setup(((AbstractBaseRecord)after).getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
        }

        @Override
        public String toString(Mask mask) {
            return BaseCommand.beforeAndAfterToString(this.before, this.after, mask);
        }

        public RECORD getBefore() {
            return this.before;
        }

        public RECORD getAfter() {
            return this.after;
        }

        RECORD record(TransactionApplicationMode mode) {
            return mode.isReverseStep() ? this.before : this.after;
        }
    }
}

