/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_2;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_3_D3;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaRuleMapifier;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.string.UTF8;
import org.neo4j.util.BitUtils;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

class LogCommandSerializationV5_0
extends LogCommandSerializationV4_3_D3 {
    static final LogCommandSerializationV5_0 INSTANCE = new LogCommandSerializationV5_0(KernelVersion.V5_0);
    static final LogCommandSerializationV5_0 V5_7_INSTANCE = new LogCommandSerializationV5_0(KernelVersion.V5_7);

    LogCommandSerializationV5_0(KernelVersion kernelVersion) {
        super(kernelVersion);
    }

    @Override
    protected Command readPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        PropertyKeyTokenRecord before = LogCommandSerializationV5_0.readPropertyKeyTokenRecord(id, channel);
        PropertyKeyTokenRecord after = LogCommandSerializationV5_0.readPropertyKeyTokenRecord(id, channel);
        return new Command.PropertyKeyTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static PropertyKeyTokenRecord readPropertyKeyTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean createdInTx = BitUtils.bitFlag((int)flags, (int)2);
        boolean internal = BitUtils.bitFlag((int)flags, (int)32);
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setInternal(internal);
        record.setCreated(createdInTx);
        record.setPropertyCount(channel.getInt());
        record.setNameId(channel.getInt());
        LogCommandSerializationV5_0.readDynamicRecords(channel, record::addNameRecord);
        return record;
    }

    @Override
    public void writePropertyKeyTokenCommand(WritableChannel channel, Command.PropertyKeyTokenCommand command) throws IOException {
        channel.put((byte)5);
        channel.putInt(((PropertyKeyTokenRecord)command.getAfter()).getIntId());
        LogCommandSerializationV5_0.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)command.getBefore());
        LogCommandSerializationV5_0.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)command.getAfter());
    }

    private static void writePropertyKeyTokenRecord(WritableChannel channel, PropertyKeyTokenRecord record) throws IOException {
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.isInternal(), (int)32));
        channel.put(flags);
        channel.putInt(record.getPropertyCount());
        channel.putInt(record.getNameId());
        if (record.isLight()) {
            channel.putInt(0);
        } else {
            LogCommandSerializationV5_0.writeDynamicRecords(channel, record.getNameRecords());
        }
    }

    @Override
    protected Command readLabelTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        LabelTokenRecord before = LogCommandSerializationV5_0.readLabelTokenRecord(id, channel);
        LabelTokenRecord after = LogCommandSerializationV5_0.readLabelTokenRecord(id, channel);
        return new Command.LabelTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static LabelTokenRecord readLabelTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean createdInTx = BitUtils.bitFlag((int)flags, (int)2);
        boolean internal = BitUtils.bitFlag((int)flags, (int)32);
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setInternal(internal);
        record.setCreated(createdInTx);
        record.setNameId(channel.getInt());
        LogCommandSerializationV5_0.readDynamicRecords(channel, record::addNameRecord);
        return record;
    }

    @Override
    public void writeLabelTokenCommand(WritableChannel channel, Command.LabelTokenCommand command) throws IOException {
        channel.put((byte)8);
        channel.putInt(((LabelTokenRecord)command.getAfter()).getIntId());
        LogCommandSerializationV5_0.writeLabelTokenRecord(channel, (LabelTokenRecord)command.getBefore());
        LogCommandSerializationV5_0.writeLabelTokenRecord(channel, (LabelTokenRecord)command.getAfter());
    }

    private static void writeLabelTokenRecord(WritableChannel channel, LabelTokenRecord record) throws IOException {
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.isInternal(), (int)32));
        channel.put(flags).putInt(record.getNameId());
        LogCommandSerializationV5_0.writeDynamicRecords(channel, record.getNameRecords());
    }

    @Override
    protected Command readRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        RelationshipTypeTokenRecord before = LogCommandSerializationV5_0.readRelationshipTypeTokenRecord(id, channel);
        RelationshipTypeTokenRecord after = LogCommandSerializationV5_0.readRelationshipTypeTokenRecord(id, channel);
        return new Command.RelationshipTypeTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipTypeTokenRecord readRelationshipTypeTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean createdInTx = BitUtils.bitFlag((int)flags, (int)2);
        boolean internal = BitUtils.bitFlag((int)flags, (int)32);
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setInternal(internal);
        record.setCreated(createdInTx);
        record.setNameId(channel.getInt());
        LogCommandSerializationV5_0.readDynamicRecords(channel, record::addNameRecord);
        return record;
    }

    @Override
    public void writeRelationshipTypeTokenCommand(WritableChannel channel, Command.RelationshipTypeTokenCommand command) throws IOException {
        channel.put((byte)4);
        channel.putInt(((RelationshipTypeTokenRecord)command.getAfter()).getIntId());
        LogCommandSerializationV5_0.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)command.getBefore());
        LogCommandSerializationV5_0.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)command.getAfter());
    }

    private static void writeRelationshipTypeTokenRecord(WritableChannel channel, RelationshipTypeTokenRecord record) throws IOException {
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.isInternal(), (int)32));
        channel.put(flags);
        channel.putInt(record.getNameId());
        LogCommandSerializationV5_0.writeDynamicRecords(channel, record.getNameRecords());
    }

    @Override
    protected Command readSchemaRuleCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        byte schemaRulePresence = channel.get();
        boolean hasSchemaRule = schemaRulePresence == 1;
        SchemaRecord before = LogCommandSerializationV5_0.readSchemaRecord(id, channel);
        SchemaRecord after = LogCommandSerializationV5_0.readSchemaRecord(id, channel);
        SchemaRule schemaRule = null;
        if (hasSchemaRule) {
            schemaRule = LogCommandSerializationV5_0.readSchemaRule(id, channel);
        }
        return new Command.SchemaRuleCommand(this, before, after, schemaRule);
    }

    private static SchemaRecord readSchemaRecord(long id, ReadableChannel channel) throws IOException {
        SchemaRecord schemaRecord = new SchemaRecord(id);
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean createdInTx = BitUtils.bitFlag((int)flags, (int)2);
        schemaRecord.setInUse(inUse);
        if (inUse) {
            byte schemaFlags = channel.get();
            schemaRecord.setConstraint(BitUtils.bitFlag((byte)schemaFlags, (byte)1));
            schemaRecord.setNextProp(channel.getLong());
        }
        schemaRecord.setCreated(createdInTx);
        return schemaRecord;
    }

    static SchemaRule readSchemaRule(long id, ReadableChannel channel) throws IOException {
        Map<String, Value> ruleMap = LogCommandSerializationV5_0.readStringValueMap(channel);
        try {
            return SchemaRuleMapifier.unmapifySchemaRule((long)id, ruleMap);
        }
        catch (MalformedSchemaRuleException e) {
            throw new IOException("Failed to create a schema rule from string-value map: " + String.valueOf(ruleMap), e);
        }
    }

    @Override
    public void writeSchemaRuleCommand(WritableChannel channel, Command.SchemaRuleCommand command) throws IOException {
        channel.put((byte)18);
        channel.putLong(((SchemaRecord)command.getBefore()).getId());
        SchemaRule schemaRule = command.getSchemaRule();
        boolean hasSchemaRule = schemaRule != null;
        channel.put(hasSchemaRule ? (byte)1 : 0);
        LogCommandSerializationV5_0.writeSchemaRecord(channel, (SchemaRecord)command.getBefore());
        LogCommandSerializationV5_0.writeSchemaRecord(channel, (SchemaRecord)command.getAfter());
        if (hasSchemaRule) {
            LogCommandSerializationV5_0.writeSchemaRule(channel, schemaRule);
        }
    }

    private static void writeSchemaRecord(WritableChannel channel, SchemaRecord record) throws IOException {
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2));
        channel.put(flags);
        if (record.inUse()) {
            byte schemaFlags = BitUtils.bitFlag((boolean)record.isConstraint(), (byte)1);
            channel.put(schemaFlags);
            channel.putLong(record.getNextProp());
        }
    }

    private static void writeSchemaRule(WritableChannel channel, SchemaRule schemaRule) throws IOException {
        Map ruleMap = SchemaRuleMapifier.mapifySchemaRule((SchemaRule)schemaRule);
        LogCommandSerializationV5_0.writeStringValueMap(channel, ruleMap);
    }

    private static void writeStringValueMap(WritableChannel channel, Map<String, Value> ruleMap) throws IOException {
        channel.putInt(ruleMap.size());
        for (Map.Entry<String, Value> entry : ruleMap.entrySet()) {
            LogCommandSerializationV5_0.writeMapKeyByteArray(channel, UTF8.encode((String)entry.getKey()));
            LogCommandSerializationV5_0.writeMapValue(channel, entry.getValue());
        }
    }

    private static void writeMapKeyByteArray(WritableChannel channel, byte[] bytes) throws IOException {
        channel.putInt(bytes.length);
        channel.put(bytes, bytes.length);
    }

    private static void writeMapValue(final WritableChannel channel, Value value) throws IOException {
        value.writeTo((ValueWriter)new ValueWriter<IOException>(){
            private boolean arrayContext;

            public void writeNull() throws IOException {
                throw new IOException("Cannot write null entry value in schema record map representation.");
            }

            public void writeBoolean(boolean value) throws IOException {
                if (value) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.BOOL_LITERAL_TRUE.type());
                } else {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.BOOL_LITERAL_FALSE.type());
                }
            }

            public void writeInteger(byte value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.BYTE.type());
                }
                channel.put(value);
            }

            public void writeInteger(short value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.SHORT.type());
                }
                channel.putShort(value);
            }

            public void writeInteger(int value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.INT.type());
                }
                channel.putInt(value);
            }

            public void writeInteger(long value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.LONG.type());
                }
                channel.putLong(value);
            }

            public void writeFloatingPoint(float value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.FLOAT.type());
                }
                channel.putFloat(value);
            }

            public void writeFloatingPoint(double value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.DOUBLE.type());
                }
                channel.putDouble(value);
            }

            public void writeString(String value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.STRING.type());
                }
                byte[] bytes = UTF8.encode((String)value);
                channel.putInt(bytes.length);
                channel.put(bytes, bytes.length);
            }

            public void writeString(char value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(LogCommandSerializationV4_2.SchemaMapValueType.CHAR.type());
                }
                channel.putInt((int)value);
            }

            public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IOException {
                this.arrayContext = true;
                channel.put(LogCommandSerializationV4_2.SchemaMapValueType.ARRAY.type());
                channel.putInt(size);
                channel.put(LogCommandSerializationV4_2.SchemaMapValueType.map(arrayType).type());
            }

            public void endArray() {
                this.arrayContext = false;
            }

            public void writeByteArray(byte[] value) throws IOException {
                this.beginArray(value.length, ValueWriter.ArrayType.BYTE);
                for (byte b : value) {
                    this.writeInteger(b);
                }
                this.endArray();
            }

            public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IOException {
                throw new IOException("Point is not a supported schema map value type.");
            }

            public void writeDuration(long months, long days, long seconds, int nanos) throws IOException {
                throw new IOException("Duration is not a supported schema map value type.");
            }

            public void writeDate(LocalDate localDate) throws IOException {
                throw new IOException("Date is not a supported schema map value type.");
            }

            public void writeLocalTime(LocalTime localTime) throws IOException {
                throw new IOException("LocalTime is not a supported schema map value type.");
            }

            public void writeTime(OffsetTime offsetTime) throws IOException {
                throw new IOException("OffsetTime is not a supported schema map value type.");
            }

            public void writeLocalDateTime(LocalDateTime localDateTime) throws IOException {
                throw new IOException("LocalDateTime is not a supported schema map value type.");
            }

            public void writeDateTime(ZonedDateTime zonedDateTime) throws IOException {
                throw new IOException("DateTime is not a supported schema map value type.");
            }

            public void writeInt8Vector(byte[] values) throws IOException {
                throw new IOException("Vector is not a supported schema map value type.");
            }

            public void writeInt16Vector(short[] values) throws IOException {
                throw new IOException("Vector is not a supported schema map value type.");
            }

            public void writeInt32Vector(int[] values) throws IOException {
                throw new IOException("Vector is not a supported schema map value type.");
            }

            public void writeInt64Vector(long[] values) throws IOException {
                throw new IOException("Vector is not a supported schema map value type.");
            }

            public void writeFloat32Vector(float[] values) throws IOException {
                throw new IOException("Vector is not a supported schema map value type.");
            }

            public void writeFloat64Vector(double[] values) throws IOException {
                throw new IOException("Vector is not a supported schema map value type.");
            }
        });
    }

    @Override
    protected Command readPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord before = LogCommandSerializationV5_0.readPropertyRecord(id, channel);
        PropertyRecord after = LogCommandSerializationV5_0.readPropertyRecord(id, channel);
        return new Command.PropertyCommand((LogCommandSerialization)this, before, after);
    }

    static PropertyRecord readPropertyRecord(long id, ReadableChannel channel) throws IOException {
        PropertyRecord record = new PropertyRecord(id);
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = BitUtils.bitFlag((int)flags, (int)2);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        boolean nodeProperty = BitUtils.bitFlag((int)flags, (int)64);
        boolean relProperty = BitUtils.bitFlag((int)flags, (int)128);
        record.setInUse(inUse);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        record.setCreated(isCreated);
        long nextProp = channel.getLong();
        long prevProp = channel.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        long primitiveId = channel.getLong();
        LogCommandSerializationV5_0.setPropertyRecordOwner(record, nodeProperty, relProperty, primitiveId);
        int nrPropBlocks = channel.get();
        assert (nrPropBlocks >= 0);
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = LogCommandSerializationV5_0.readPropertyBlock(channel);
            record.addPropertyBlock(block);
        }
        LogCommandSerializationV5_0.readDynamicRecords(channel, record::addDeletedRecord);
        if (record.inUse() != record.numberOfProperties() > 0) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + String.valueOf(record));
        }
        return record;
    }

    private static void setPropertyRecordOwner(PropertyRecord record, boolean nodeProperty, boolean relProperty, long primitiveId) {
        assert (!nodeProperty || !relProperty);
        if (primitiveId != -1L) {
            if (nodeProperty) {
                record.setNodeId(primitiveId);
            } else if (relProperty) {
                record.setRelId(primitiveId);
            } else {
                record.setSchemaRuleId(primitiveId);
            }
        }
    }

    private static PropertyBlock readPropertyBlock(ReadableChannel channel) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        byte blockSize = channel.get();
        long[] blocks = LogCommandSerializationV5_0.readLongs(channel, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (blocks.length == 0 || PropertyType.getPropertyTypeOrThrow(blocks[0]).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + String.valueOf((Object)PropertyType.getPropertyTypeOrThrow(blocks[0]));
        toReturn.setValueBlocks(blocks);
        LogCommandSerializationV5_0.readDynamicRecordList(channel, toReturn::setValueRecords);
        return toReturn;
    }

    @Override
    public void writePropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        channel.put((byte)2);
        channel.putLong(((PropertyRecord)command.getAfter()).getId());
        LogCommandSerializationV5_0.writePropertyRecord(channel, (PropertyRecord)command.getBefore());
        LogCommandSerializationV5_0.writePropertyRecord(channel, (PropertyRecord)command.getAfter());
    }

    static void writePropertyRecord(WritableChannel channel, PropertyRecord record) throws IOException {
        assert (!record.hasSecondaryUnitId()) : "secondary units are not supported for property records";
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.isUseFixedReferences(), (int)16), (int)BitUtils.bitFlag((boolean)record.isNodeSet(), (int)64), (int)BitUtils.bitFlag((boolean)record.isRelSet(), (int)128));
        channel.put(flags);
        channel.putLong(record.getNextProp()).putLong(record.getPrevProp());
        long entityId = record.getEntityId();
        channel.putLong(entityId);
        int numberOfProperties = record.numberOfProperties();
        channel.put((byte)numberOfProperties);
        PropertyBlock[] blocks = record.propertyBlocksArray();
        for (int i = 0; i < numberOfProperties; ++i) {
            PropertyBlock block = blocks[i];
            assert (block.getSize() > 0) : String.valueOf(record) + " has incorrect size";
            LogCommandSerializationV5_0.writePropertyBlock(channel, block);
        }
        LogCommandSerializationV5_0.writeDynamicRecords(channel, record.getDeletedRecords());
    }

    private static void writePropertyBlock(WritableChannel channel, PropertyBlock block) throws IOException {
        long[] propBlockValues;
        byte blockSize = (byte)block.getSize();
        assert (blockSize > 0) : blockSize + " is not a valid block size value";
        channel.put(blockSize);
        for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
            channel.putLong(propBlockValue);
        }
        if (block.isLight()) {
            channel.putInt(0);
        } else {
            LogCommandSerializationV5_0.writeDynamicRecords(channel, block.getValueRecords());
        }
    }

    @Override
    public void writeNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        channel.put((byte)1);
        channel.putLong(((NodeRecord)command.getAfter()).getId());
        LogCommandSerializationV5_0.writeNodeRecord(channel, (NodeRecord)command.getBefore());
        LogCommandSerializationV5_0.writeNodeRecord(channel, (NodeRecord)command.getAfter());
    }

    static void writeNodeRecord(WritableChannel channel, NodeRecord record) throws IOException {
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)BitUtils.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)BitUtils.bitFlag((boolean)record.isUseFixedReferences(), (int)16), (int)BitUtils.bitFlag((boolean)record.isSecondaryUnitCreated(), (int)32));
        channel.put(flags);
        if (record.inUse()) {
            channel.put(record.isDense() ? (byte)1 : 0);
            channel.putLong(record.getNextRel()).putLong(record.getNextProp());
            channel.putLong(record.getLabelField());
        }
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
        LogCommandSerializationV5_0.writeDynamicRecords(channel, record.getDynamicLabelRecords());
    }

    @Override
    protected Command readNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord before = LogCommandSerializationV5_0.readNodeRecord(id, channel);
        NodeRecord after = LogCommandSerializationV5_0.readNodeRecord(id, channel);
        return new Command.NodeCommand((LogCommandSerialization)this, before, after);
    }

    static NodeRecord readNodeRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = BitUtils.bitFlag((int)flags, (int)2);
        boolean requiresSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        boolean secondaryUnitCreated = BitUtils.bitFlag((int)flags, (int)32);
        NodeRecord record = new NodeRecord(id);
        if (inUse) {
            boolean dense = channel.get() == 1;
            long nextRel = channel.getLong();
            long nextProp = channel.getLong();
            long labelField = channel.getLong();
            record.initialize(true, nextProp, dense, nextRel, labelField);
        }
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setRequiresSecondaryUnit(requiresSecondaryUnit);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        record.setSecondaryUnitCreated(secondaryUnitCreated);
        LogCommandSerializationV5_0.readDynamicRecordList(channel, dlr -> record.setLabelField(record.getLabelField(), (List<DynamicRecord>)dlr));
        record.setCreated(isCreated);
        return record;
    }

    @Override
    public void writeRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        channel.put((byte)3);
        channel.putLong(((RelationshipRecord)command.getAfter()).getId());
        LogCommandSerializationV5_0.writeRelationshipRecord(channel, (RelationshipRecord)command.getBefore());
        LogCommandSerializationV5_0.writeRelationshipRecord(channel, (RelationshipRecord)command.getAfter());
    }

    static void writeRelationshipRecord(WritableChannel channel, RelationshipRecord record) throws IOException {
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)BitUtils.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)BitUtils.bitFlag((boolean)record.isUseFixedReferences(), (int)16), (int)BitUtils.bitFlag((boolean)record.isSecondaryUnitCreated(), (int)32));
        channel.put(flags);
        if (record.inUse()) {
            channel.putLong(record.getFirstNode()).putLong(record.getSecondNode()).putInt(record.getType()).putLong(record.getFirstPrevRel()).putLong(record.getFirstNextRel()).putLong(record.getSecondPrevRel()).putLong(record.getSecondNextRel()).putLong(record.getNextProp());
            byte extraByte = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.isFirstInFirstChain(), (byte)1), (int)BitUtils.bitFlag((boolean)record.isFirstInSecondChain(), (byte)2));
            channel.put(extraByte);
        } else {
            channel.putInt(record.getType());
        }
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
    }

    @Override
    protected Command readRelationshipCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipRecord before = LogCommandSerializationV5_0.readRelationshipRecord(id, channel);
        RelationshipRecord after = LogCommandSerializationV5_0.readRelationshipRecord(id, channel);
        return new Command.RelationshipCommand((LogCommandSerialization)this, before, after);
    }

    static RelationshipRecord readRelationshipRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = BitUtils.bitFlag((int)flags, (int)2);
        boolean requiresSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        boolean secondaryUnitCreated = BitUtils.bitFlag((int)flags, (int)32);
        RelationshipRecord record = new RelationshipRecord(id);
        if (inUse) {
            record.setInUse(true);
            record.setLinks(channel.getLong(), channel.getLong(), channel.getInt());
            record.setFirstPrevRel(channel.getLong());
            record.setFirstNextRel(channel.getLong());
            record.setSecondPrevRel(channel.getLong());
            record.setSecondNextRel(channel.getLong());
            record.setNextProp(channel.getLong());
            byte extraByte = channel.get();
            record.setFirstInFirstChain(BitUtils.bitFlag((byte)extraByte, (byte)1));
            record.setFirstInSecondChain(BitUtils.bitFlag((byte)extraByte, (byte)2));
        } else {
            record.setLinks(-1L, -1L, channel.getInt());
            record.setInUse(false);
        }
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setRequiresSecondaryUnit(requiresSecondaryUnit);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        record.setSecondaryUnitCreated(secondaryUnitCreated);
        record.setCreated(isCreated);
        return record;
    }

    @Override
    public void writeRelationshipGroupCommand(WritableChannel channel, Command.RelationshipGroupCommand command) throws IOException {
        channel.put((byte)9);
        channel.putLong(((RelationshipGroupRecord)command.getAfter()).getId());
        LogCommandSerializationV5_0.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)command.getBefore());
        LogCommandSerializationV5_0.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)command.getAfter());
    }

    private static void writeRelationshipGroupRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
        byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)BitUtils.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)BitUtils.bitFlag((boolean)record.isUseFixedReferences(), (int)16), (int)BitUtils.bitFlag((boolean)record.isSecondaryUnitCreated(), (int)32));
        channel.put(flags);
        channel.putInt(record.getType());
        channel.putLong(record.getNext());
        channel.putLong(record.getFirstOut());
        channel.putLong(record.getFirstIn());
        channel.putLong(record.getFirstLoop());
        channel.putLong(record.getOwningNode());
        byte externalDegreesFlags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)record.hasExternalDegreesOut(), (byte)1), (int)BitUtils.bitFlag((boolean)record.hasExternalDegreesIn(), (byte)2), (int)BitUtils.bitFlag((boolean)record.hasExternalDegreesLoop(), (byte)4));
        channel.put(externalDegreesFlags);
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
    }

    @Override
    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV5_0.readRelationshipGroupRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV5_0.readRelationshipGroupRecord(id, channel);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = BitUtils.bitFlag((int)flags, (int)2);
        boolean requireSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        boolean secondaryUnitCreated = BitUtils.bitFlag((int)flags, (int)32);
        int type = channel.getInt();
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        byte externalDegreesFlags = channel.get();
        boolean hasExternalDegreesOut = BitUtils.bitFlag((byte)externalDegreesFlags, (byte)1);
        boolean hasExternalDegreesIn = BitUtils.bitFlag((byte)externalDegreesFlags, (byte)2);
        boolean hasExternalDegreesLoop = BitUtils.bitFlag((byte)externalDegreesFlags, (byte)4);
        record.setHasExternalDegreesOut(hasExternalDegreesOut);
        record.setHasExternalDegreesIn(hasExternalDegreesIn);
        record.setHasExternalDegreesLoop(hasExternalDegreesLoop);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        record.setSecondaryUnitCreated(secondaryUnitCreated);
        record.setCreated(isCreated);
        return record;
    }

    @Override
    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    public void writeMetaDataCommand(WritableChannel channel, Command.MetaDataCommand command) throws IOException {
        channel.put((byte)19);
        channel.putLong(command.getKey());
        LogCommandSerializationV5_0.writeMetaDataRecord(channel, (MetaDataRecord)command.getBefore());
        LogCommandSerializationV5_0.writeMetaDataRecord(channel, (MetaDataRecord)command.getAfter());
    }

    private static void writeMetaDataRecord(WritableChannel channel, MetaDataRecord record) throws IOException {
        byte flags = BitUtils.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue());
        channel.put(flags);
        channel.putLong(record.getValue());
    }

    @Override
    public void writeGroupDegreeCommand(WritableChannel channel, Command.GroupDegreeCommand command) throws IOException {
        channel.put((byte)20);
        channel.putLong(command.getKey());
        channel.putLong(command.delta());
    }

    @Override
    public void writeNodeCountsCommand(WritableChannel channel, Command.NodeCountsCommand command) throws IOException {
        channel.put((byte)17);
        channel.putInt(command.labelId()).putLong(command.delta());
    }

    @Override
    public void writeRelationshipCountsCommand(WritableChannel channel, Command.RelationshipCountsCommand command) throws IOException {
        channel.put((byte)16);
        channel.putInt(command.startLabelId()).putInt(command.typeId()).putInt(command.endLabelId()).putLong(command.delta());
    }

    private static void writeDynamicRecords(WritableChannel channel, List<DynamicRecord> records) throws IOException {
        int size = records.size();
        channel.putInt(size);
        for (int i = 0; i < size; ++i) {
            LogCommandSerializationV5_0.writeDynamicRecord(channel, records.get(i));
        }
    }

    private static void writeDynamicRecord(WritableChannel channel, DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte flags = BitUtils.bitFlags((int)BitUtils.bitFlag((boolean)true, (byte)Record.IN_USE.byteValue()), (int)BitUtils.bitFlag((boolean)record.isCreated(), (int)2), (int)BitUtils.bitFlag((boolean)record.isStartRecord(), (int)32));
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(flags).putInt(record.getLength()).putLong(record.getNextBlock());
            byte[] data = record.getData();
            assert (data != null);
            channel.put(data, data.length);
        } else {
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(Record.NOT_IN_USE.byteValue());
        }
    }

    private static DynamicRecord readDynamicRecord(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        assert (id >= 0L) : id + " is not a valid dynamic record id";
        int type = channel.getInt();
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean created = BitUtils.bitFlag((int)flags, (int)2);
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord(BitUtils.bitFlag((int)flags, (int)32));
            record.setCreated(created);
            int nrOfBytes = channel.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = channel.getLong();
            assert (nextBlock >= 0L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            byte[] data = new byte[nrOfBytes];
            channel.get(data, nrOfBytes);
            record.setData(data);
        }
        return record;
    }

    private static void readDynamicRecords(ReadableChannel channel, Consumer<DynamicRecord> recordConsumer) throws IOException {
        int numberOfRecords;
        assert (numberOfRecords >= 0);
        for (numberOfRecords = channel.getInt(); numberOfRecords > 0; --numberOfRecords) {
            DynamicRecord read = LogCommandSerializationV5_0.readDynamicRecord(channel);
            recordConsumer.accept(read);
        }
    }

    private static void readDynamicRecordList(ReadableChannel channel, Consumer<List<DynamicRecord>> recordConsumer) throws IOException {
        int numberOfRecords;
        assert (numberOfRecords >= 0);
        if (numberOfRecords > 0) {
            ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>(numberOfRecords);
            for (numberOfRecords = channel.getInt(); numberOfRecords > 0; --numberOfRecords) {
                records.add(LogCommandSerializationV5_0.readDynamicRecord(channel));
            }
            recordConsumer.accept(records);
        }
    }

    private static long[] readLongs(ReadableChannel channel, int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = channel.getLong();
        }
        return result;
    }

    @Override
    public void writeDeletedNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        this.writeNodeCommand(channel, command);
    }

    @Override
    public void writeCreatedNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        this.writeNodeCommand(channel, command);
    }

    @Override
    public void writeCreatedRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        this.writeRelationshipCommand(channel, command);
    }

    @Override
    public void writeDeletedRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        this.writeRelationshipCommand(channel, command);
    }

    @Override
    public void writeCreatedPropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        this.writePropertyCommand(channel, command);
    }

    @Override
    public void writeDeletedPropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        this.writePropertyCommand(channel, command);
    }
}

