/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.SimpleDegreeStoreTransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;

class MultiversionDegreeStoreTransactionApplierFactory
implements TransactionApplierFactory {
    private final TransactionApplicationMode mode;
    private final RelationshipGroupDegreesStore groupDegreesStore;

    MultiversionDegreeStoreTransactionApplierFactory(TransactionApplicationMode mode, RelationshipGroupDegreesStore groupDegreesStore) {
        this.mode = mode;
        this.groupDegreesStore = groupDegreesStore;
    }

    @Override
    public TransactionApplier startTx(StorageEngineTransaction transaction, BatchContext batchContext) {
        return switch (this.mode) {
            case TransactionApplicationMode.REVERSE_RECOVERY, TransactionApplicationMode.MVCC_INCOMPLETE_REVERSE_RECOVERY -> new SimpleDegreeStoreTransactionApplier(() -> this.groupDegreesStore.reverseRecoveryUpdater(transaction.transactionId(), transaction.cursorContext()));
            case TransactionApplicationMode.MVCC_ROLLBACK -> new SimpleDegreeStoreTransactionApplier(() -> this.groupDegreesStore.rollbackUpdater(transaction.transactionId(), transaction.cursorContext()));
            default -> new SimpleDegreeStoreTransactionApplier(() -> this.groupDegreesStore.updater(transaction.transactionId(), transaction.commandBatch().isLast(), transaction.cursorContext()));
        };
    }
}

