/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.io.pagecache.prefetch.PagePrefetcher;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class PrefetchingTransactionApplier
extends TransactionApplier.Adapter {
    private final NeoStores neoStores;
    private final PagePrefetcher prefetcher;
    private final MutableLongSet[] checkedPages;

    public PrefetchingTransactionApplier(NeoStores neoStores, PagePrefetcher prefetcher) {
        this.neoStores = neoStores;
        this.prefetcher = prefetcher;
        this.checkedPages = new MutableLongSet[StoreType.STORE_TYPES.length];
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.track(command, StoreType.NODE);
        this.track(((NodeRecord)command.getAfter()).getDynamicLabelRecords(), StoreType.NODE_LABEL);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.track(command, StoreType.RELATIONSHIP);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        this.track(command, StoreType.PROPERTY);
        for (PropertyBlock block : ((PropertyRecord)command.getAfter()).propertyBlocks()) {
            switch (block.getType()) {
                case STRING: {
                    this.track(block.getValueRecords(), StoreType.PROPERTY_STRING);
                    break;
                }
                case ARRAY: {
                    this.track(block.getValueRecords(), StoreType.PROPERTY_ARRAY);
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
        this.track(command, StoreType.RELATIONSHIP_GROUP);
        return false;
    }

    private void track(AbstractBaseRecord record, StoreType storeType) {
        this.pagesForStore(storeType).add(RecordPageLocationCalculator.pageIdForRecord(record.getId(), this.neoStores.getRecordStore(storeType).getRecordsPerPage()));
    }

    private MutableLongSet pagesForStore(StoreType storeType) {
        int position = storeType.ordinal();
        MutableLongSet checkedStorePages = this.checkedPages[position];
        if (checkedStorePages == null) {
            this.checkedPages[position] = checkedStorePages = LongSets.mutable.empty();
        }
        return checkedStorePages;
    }

    private <RECORD extends AbstractBaseRecord> void track(Command.BaseCommand<RECORD> command, StoreType storeType) {
        this.track((AbstractBaseRecord)command.getAfter(), storeType);
    }

    private void track(Collection<? extends AbstractBaseRecord> records, StoreType storeType) {
        for (AbstractBaseRecord abstractBaseRecord : records) {
            this.track(abstractBaseRecord, storeType);
        }
    }

    @Override
    public void close() throws IOException {
        for (StoreType storeType : StoreType.STORE_TYPES) {
            int index = storeType.ordinal();
            MutableLongSet pages = this.checkedPages[index];
            if (pages == null) continue;
            this.prefetcher.submit(this.neoStores.getRecordStore(storeType).getStorageFile(), pages.toSortedArray());
        }
    }
}

