/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.internal.recordstorage.Loaders;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RecordChanges;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RecordChangeSet
implements RecordAccessSet {
    private final RecordAccess<NodeRecord, Void> nodeRecords;
    private final RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords;
    private final RecordAccess<RelationshipRecord, Void> relRecords;
    private final RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords;
    private final RecordAccess<SchemaRecord, SchemaRule> schemaRuleChanges;
    private final RecordAccess<PropertyKeyTokenRecord, Void> propertyKeyTokenChanges;
    private final RecordAccess<LabelTokenRecord, Void> labelTokenChanges;
    private final RecordAccess<RelationshipTypeTokenRecord, Void> relationshipTypeTokenChanges;
    private final MutableInt changeCounter = new MutableInt();

    public RecordChangeSet(Loaders loaders, MemoryTracker memoryTracker, RecordAccess.LoadMonitor monitor, StoreCursors storeCursors) {
        this(loaders.nodeLoader(), loaders.propertyLoader(), loaders.relationshipLoader(), loaders.relationshipGroupLoader(), loaders.schemaRuleLoader(), loaders.propertyKeyTokenLoader(), loaders.labelTokenLoader(), loaders.relationshipTypeTokenLoader(), memoryTracker, monitor, storeCursors);
    }

    public RecordChangeSet(RecordAccess.Loader<NodeRecord, Void> nodeLoader, RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader, RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader, RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader, RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader, RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader, RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader, RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader, MemoryTracker memoryTracker, RecordAccess.LoadMonitor monitor, StoreCursors storeCursors) {
        this.nodeRecords = RecordChanges.create(nodeLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
        this.propertyRecords = RecordChanges.create(propertyLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
        this.relRecords = RecordChanges.create(relationshipLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
        this.relGroupRecords = RecordChanges.create(relationshipGroupLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
        this.schemaRuleChanges = RecordChanges.create(schemaRuleLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
        this.propertyKeyTokenChanges = RecordChanges.create(propertyKeyTokenLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
        this.labelTokenChanges = RecordChanges.create(labelTokenLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
        this.relationshipTypeTokenChanges = RecordChanges.create(relationshipTypeTokenLoader, this.changeCounter, memoryTracker, monitor, storeCursors);
    }

    @Override
    public RecordAccess<NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<RelationshipRecord, Void> getRelRecords() {
        return this.relRecords;
    }

    @Override
    public RecordAccess<RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relGroupRecords;
    }

    @Override
    public RecordAccess<SchemaRecord, SchemaRule> getSchemaRuleChanges() {
        return this.schemaRuleChanges;
    }

    @Override
    public RecordAccess<PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenChanges;
    }

    @Override
    public RecordAccess<LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenChanges;
    }

    @Override
    public RecordAccess<RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenChanges;
    }

    @Override
    public int changeSize() {
        return this.changeCounter.intValue();
    }
}

