/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordRelationshipCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipScan;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.string.Mask;

public class RecordRelationshipScanCursor
extends RecordRelationshipCursor
implements StorageRelationshipScanCursor {
    private final StoreCursors storeCursors;
    private final CursorContext cursorContext;
    private long next;
    private long highMark;
    private long nextStoreReference;
    private PageCursor currentCursor;
    private PageCursor singleCursor;
    private PageCursor scanCursor;
    private boolean open;
    private boolean batched;

    RecordRelationshipScanCursor(RelationshipStore relationshipStore, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        super(relationshipStore, cursorContext, memoryTracker);
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
    }

    public void scan() {
        if (this.getId() != -1L) {
            this.resetState();
        }
        this.selectScanCursor();
        this.next = 0L;
        this.highMark = this.relationshipHighMark();
        this.nextStoreReference = -1L;
        this.open = true;
    }

    public void single(long reference) {
        if (this.getId() != -1L) {
            this.resetState();
        }
        this.selectSingleCursor();
        this.next = reference >= 0L ? reference : -1L;
        this.highMark = -1L;
        this.nextStoreReference = -1L;
        this.open = true;
    }

    public void single(long reference, long sourceNodeReference, int type, long targetNodeReference) {
        this.single(reference);
    }

    public boolean scanBatch(AllRelationshipsScan scan, long sizeHint) {
        if (this.getId() != -1L) {
            this.reset();
        }
        this.batched = true;
        this.open = true;
        this.nextStoreReference = -1L;
        return ((RecordRelationshipScan)scan).scanBatch(sizeHint, this);
    }

    boolean scanRange(long start, long stop) {
        long max = this.relationshipHighMark();
        if (start > max) {
            this.reset();
            return false;
        }
        if (start > stop) {
            this.reset();
            return true;
        }
        this.selectScanCursor();
        this.next = start;
        this.highMark = Math.min(stop, max);
        return true;
    }

    public boolean next() {
        if (this.next == -1L) {
            this.resetState();
            return false;
        }
        do {
            if (this.nextStoreReference == this.next) {
                this.relationshipAdvance(this, this.currentCursor);
                ++this.next;
                ++this.nextStoreReference;
            } else {
                this.relationship(this, this.next++, this.currentCursor);
                this.nextStoreReference = this.next;
            }
            if (this.next <= this.highMark) continue;
            if (this.isSingle() || this.batched) {
                this.next = -1L;
                return this.inUse();
            }
            this.highMark = this.relationshipHighMark();
            if (this.next <= this.highMark) continue;
            this.next = -1L;
            return this.inUse();
        } while (!this.inUse());
        return true;
    }

    public void reset() {
        if (this.open) {
            this.open = false;
            this.resetState();
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.next = -1L;
        this.setId(-1L);
    }

    @Override
    public String toString(Mask mask) {
        if (!this.open) {
            return "RelationshipScanCursor[closed state]";
        }
        return "RelationshipScanCursor[id=" + this.getId() + ", open state with: highMark=" + this.highMark + ", next=" + this.next + ", underlying record=" + super.toString(mask) + "]";
    }

    private boolean isSingle() {
        return this.highMark == -1L;
    }

    public void close() {
        if (this.scanCursor != null) {
            this.scanCursor.close();
            this.scanCursor = null;
        }
        this.currentCursor = null;
        this.singleCursor = null;
    }

    private void selectScanCursor() {
        if (this.scanCursor == null) {
            this.scanCursor = this.relationshipStore.openPageCursorForReading(0L, this.cursorContext);
        }
        this.currentCursor = this.scanCursor;
    }

    private void selectSingleCursor() {
        if (this.singleCursor == null) {
            this.singleCursor = this.storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);
        }
        this.currentCursor = this.singleCursor;
    }

    private void relationshipAdvance(RelationshipRecord record, PageCursor pageCursor) {
        this.relationshipStore.nextRecordByCursor(record, this.loadMode.orElse(RecordLoad.CHECK).lenient(), pageCursor, this.memoryTracker);
    }
}

