/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.batchimport.api.AdditionalInitialIds;
import org.neo4j.batchimport.api.BatchImporter;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IncrementalBatchImporter;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.ReadBehaviour;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checker.EntityBasedMemoryLimiter;
import org.neo4j.consistency.checker.RecordStorageConsistencyChecker;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.IncrementalBatchImporterFactory;
import org.neo4j.internal.batchimport.input.LenientStoreInput;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionMonitors;
import org.neo4j.internal.batchimport.staging.SpectrumExecutionMonitor;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleMigrationAccessImpl;
import org.neo4j.internal.recordstorage.SchemaRuleMigrationAccessImplExtended;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.prefetch.PagePrefetcher;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProviders;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LegacyMetadataHandler;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.format.PageCacheOptionsSelector;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersion;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.kernel.impl.transaction.log.EmptyLogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadataFactory;
import org.neo4j.lock.LockService;
import org.neo4j.lock.ResourceType;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.ExceptionHandlerService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.OperationMode;
import org.neo4j.storageengine.StoreIdGenerator;
import org.neo4j.storageengine.VectorStoreCreator;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreFormatLimits;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccessExtended;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.RegisteringCreatingTokenHolder;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokensLoader;

public class RecordStorageEngineFactory
implements StorageEngineFactory {
    public static final String NAME = "record";
    public static final byte ID = 1;

    public String name() {
        return NAME;
    }

    public byte id() {
        return 1;
    }

    public StoreId retrieveStoreId(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) throws IOException {
        String databaseName;
        Path metaDataFile = this.formatSpecificDatabaseLayout(databaseLayout).metadataStore();
        MetaDataStore.FieldAccess fieldAccess = MetaDataStore.getFieldAccess(pageCache, metaDataFile, databaseName = databaseLayout.getDatabaseName(), cursorContext);
        if (fieldAccess.isLegacyFieldValid()) {
            return fieldAccess.readStoreId();
        }
        return LegacyMetadataHandler.readMetadata44FromStore(pageCache, metaDataFile, databaseName, cursorContext).storeId();
    }

    public StoreVersionCheck versionCheck(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, PageCache pageCache, LogService logService, CursorContextFactory contextFactory) {
        return new RecordStoreVersionCheck(pageCache, this.formatSpecificDatabaseLayout(databaseLayout), config);
    }

    public Optional<? extends StoreVersion> versionInformation(StoreVersionIdentifier storeVersionIdentifier) {
        Optional<RecordFormats> maybeRecordFormat = RecordFormatSelector.selectForStoreVersionIdentifier(storeVersionIdentifier);
        return maybeRecordFormat.map(RecordStoreVersion::new);
    }

    public List<StoreMigrationParticipant> migrationParticipants(FileSystemAbstraction fs, Config config, PageCache pageCache, JobScheduler jobScheduler, LogService logService, MemoryTracker memoryTracker, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory, boolean forceBtreeIndexesToRange, long maxOffHeapMemory) {
        BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();
        RecordStorageMigrator recordStorageMigrator = new RecordStorageMigrator(fs, pageCache, pageCacheTracer, config, logService, jobScheduler, contextFactory, batchImporterFactory, memoryTracker, forceBtreeIndexesToRange, maxOffHeapMemory);
        return List.of(recordStorageMigrator);
    }

    public StorageEngine instantiate(FileSystemAbstraction fs, Clock clock, DatabaseLayout databaseLayout, Config config, PageCache pageCache, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, IdGeneratorFactory idGeneratorFactory, DatabaseHealth databaseHealth, InternalLogProvider internalLogProvider, InternalLogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, LogTailMetadata logTailMetadata, MetadataCache metadataCache, MemoryTracker memoryTracker, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, VersionStorage versionStorage, PagePrefetcher pagePrefetcher, StoreIdGenerator storeIdGenerator, DependencyResolver databaseDependencies, ExceptionHandlerService exceptionHandlerService, OperationMode mode, VectorStoreCreator vectorStoreCreator) {
        return new RecordStorageEngine(this.formatSpecificDatabaseLayout(databaseLayout), config, pageCache, fs, internalLogProvider, userLogProvider, tokenHolders, schemaState, constraintSemantics, indexConfigCompleter, lockService, databaseHealth, idGeneratorFactory, recoveryCleanupWorkCollector, memoryTracker, logTailMetadata, metadataCache, contextFactory, pageCacheTracer, versionStorage, pagePrefetcher, storeIdGenerator);
    }

    public List<Path> listStorageFiles(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) throws IOException {
        if (!fileSystem.fileExists(this.formatSpecificDatabaseLayout(databaseLayout).pathForExistsMarker())) {
            throw new IOException("No storage present at " + String.valueOf(databaseLayout) + " on " + String.valueOf(fileSystem));
        }
        return Arrays.stream(RecordDatabaseFile.values()).flatMap(arg_0 -> ((DatabaseLayout)databaseLayout).allFiles(arg_0)).filter(arg_0 -> ((FileSystemAbstraction)fileSystem).fileExists(arg_0)).toList();
    }

    public boolean storageExists(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
        return NeoStores.isStorePresent(fileSystem, this.formatSpecificDatabaseLayout(databaseLayout));
    }

    public Set<String> supportedFormats(boolean includeDevelopmentFormats) {
        return Iterables.stream(RecordFormatSelector.allFormats()).filter(f -> includeDevelopmentFormats || !f.formatUnderDevelopment()).filter(Predicate.not(RecordFormats::onlyForMigration)).map(RecordFormats::name).collect(Collectors.toUnmodifiableSet());
    }

    public boolean isDeprecated(String formatName) {
        return Iterables.stream(RecordFormatSelector.allFormats()).filter(format -> format.getFormatFamily().name().equals(formatName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No format found for " + formatName)).getFormatFamily().isDeprecated();
    }

    public StoreFormatLimits limitsForFormat(String formatName) {
        Optional<RecordFormats> format = Iterables.stream(RecordFormatSelector.allFormats()).filter(formats -> formats.name().equals(formatName)).findFirst();
        return format.orElseThrow(() -> new IllegalStateException("Format is not supported by engine")).idLimits();
    }

    public MetadataProvider transactionMetaDataStore(FileSystemAbstraction fs, DatabaseLayout layout, Config config, PageCache pageCache, DatabaseReadOnlyChecker readOnlyChecker, CursorContextFactory contextFactory, LogTailLogVersionsMetadata logTailMetadata, PageCacheTracer pageCacheTracer) {
        RecordDatabaseLayout databaseLayout = this.formatSpecificDatabaseLayout(layout);
        ScanOnOpenReadOnlyIdGeneratorFactory idGeneratorFactory = readOnlyChecker.isReadOnly() ? new ScanOnOpenReadOnlyIdGeneratorFactory() : new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate(), pageCacheTracer, databaseLayout.getDatabaseName());
        return new StoreFactory((DatabaseLayout)databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, pageCacheTracer, fs, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, readOnlyChecker.isReadOnly(), logTailMetadata, StoreIdGenerator.UNIQUE_ID).openNeoStores(StoreType.META_DATA).getMetaDataStore();
    }

    public Optional<UUID> databaseIdUuid(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) {
        MetaDataStore.FieldAccess fieldAccess = MetaDataStore.getFieldAccess(pageCache, this.formatSpecificDatabaseLayout(databaseLayout).metadataStore(), databaseLayout.getDatabaseName(), cursorContext);
        try {
            return fieldAccess.readDatabaseUUID();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<SchemaRule44> load44SchemaRules(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout layout, CursorContextFactory contextFactory, LogTailLogVersionsMetadata logTailMetadata, MemoryTracker memoryTracker) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<SchemaRule> loadSchemaRules(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout layout, boolean lenient, Function<SchemaRule, SchemaRule> schemaRuleMigration, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TokenHolders loadReadOnlyTokens(FileSystemAbstraction fs, DatabaseLayout layout, Config config, PageCache pageCache, PageCacheTracer pageCacheTracer, boolean lenient, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        RecordDatabaseLayout databaseLayout = this.formatSpecificDatabaseLayout(layout);
        StoreFactory factory = new StoreFactory((DatabaseLayout)databaseLayout, config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), pageCache, pageCacheTracer, fs, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, true, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, StoreIdGenerator.UNIQUE_ID);
        try (NeoStores stores = factory.openNeoStores(StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME);){
            TokenHolders tokenHolders = this.loadReadOnlyTokens(stores, lenient, contextFactory, memoryTracker);
            return tokenHolders;
        }
    }

    public SchemaRuleMigrationAccessExtended schemaRuleMigrationAccess(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout databaseLayout, CursorContextFactory contextFactory, MemoryTracker memoryTracker, LogTailMetadata logTail) throws IOException {
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate(), pageCacheTracer, databaseLayout.getDatabaseName());
        StoreFactory dstFactory = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, pageCacheTracer, fs, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, false, (LogTailLogVersionsMetadata)logTail, StoreIdGenerator.UNIQUE_ID);
        CursorContext cursorContext = contextFactory.create("schemaStoreMigration");
        NeoStores dstStore = dstFactory.openNeoStores(StoreType.SCHEMA, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME);
        dstStore.start(cursorContext);
        try {
            SchemaStore dstSchema = dstStore.getSchemaStore();
            DynamicAllocatorProvider allocatorProvider = DynamicAllocatorProviders.nonTransactionalAllocator(dstStore);
            TokenHolders dstTokenHolders = new TokenHolders((TokenHolder)new RegisteringCreatingTokenHolder(RecordStorageEngineFactory.getPropertyTokenCreator(dstStore, contextFactory, memoryTracker, allocatorProvider), "PropertyKey"), (TokenHolder)new RegisteringCreatingTokenHolder(RecordStorageEngineFactory.getLabelTokenCreator(dstStore, contextFactory, memoryTracker, allocatorProvider), "Label"), (TokenHolder)new RegisteringCreatingTokenHolder(RecordStorageEngineFactory.getRelTypeTokenCreator(dstStore, contextFactory, memoryTracker, allocatorProvider), "RelationshipType"));
            CachedStoreCursors storeCursors = new CachedStoreCursors(dstStore, cursorContext);
            dstTokenHolders.propertyKeyTokens().setInitialTokens(dstStore.getPropertyKeyTokenStore().getTokens((StoreCursors)storeCursors, memoryTracker));
            dstTokenHolders.labelTokens().setInitialTokens(dstStore.getLabelTokenStore().getTokens((StoreCursors)storeCursors, memoryTracker));
            dstTokenHolders.relationshipTypeTokens().setInitialTokens(dstStore.getRelationshipTypeTokenStore().getTokens((StoreCursors)storeCursors, memoryTracker));
            return new SchemaRuleMigrationAccessImplExtended(dstStore, new SchemaStorage(dstSchema, dstTokenHolders, (String)config.get(GraphDatabaseSettings.db_format)), allocatorProvider, cursorContext, memoryTracker, (StoreCursors)storeCursors, dstTokenHolders);
        }
        catch (Throwable e) {
            dstStore.close();
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private TokenHolders loadReadOnlyTokens(NeoStores stores, boolean lenient, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        try (CursorContext cursorContext = contextFactory.create("loadReadOnlyTokens");){
            TokenHolders tokenHolders;
            try (CachedStoreCursors storeCursors = new CachedStoreCursors(stores, cursorContext);){
                stores.start(cursorContext);
                TokensLoader loader = lenient ? StoreTokens.allReadableTokens(stores) : StoreTokens.allTokens(stores);
                CreatingTokenHolder propertyKeys = new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "PropertyKey");
                CreatingTokenHolder labels = new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "Label");
                CreatingTokenHolder relationshipTypes = new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "RelationshipType");
                propertyKeys.setInitialTokens(lenient ? RecordStorageEngineFactory.unique(loader.getPropertyKeyTokens((StoreCursors)storeCursors, memoryTracker)) : loader.getPropertyKeyTokens((StoreCursors)storeCursors, memoryTracker));
                labels.setInitialTokens(lenient ? RecordStorageEngineFactory.unique(loader.getLabelTokens((StoreCursors)storeCursors, memoryTracker)) : loader.getLabelTokens((StoreCursors)storeCursors, memoryTracker));
                relationshipTypes.setInitialTokens(lenient ? RecordStorageEngineFactory.unique(loader.getRelationshipTypeTokens((StoreCursors)storeCursors, memoryTracker)) : loader.getRelationshipTypeTokens((StoreCursors)storeCursors, memoryTracker));
                tokenHolders = new TokenHolders((TokenHolder)propertyKeys, (TokenHolder)labels, (TokenHolder)relationshipTypes);
            }
            return tokenHolders;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static List<NamedToken> unique(List<NamedToken> tokens) {
        if (!tokens.isEmpty()) {
            HashSet<String> names = new HashSet<String>(tokens.size());
            int i = 0;
            while (i < tokens.size()) {
                if (names.add(tokens.get(i).name())) {
                    ++i;
                    continue;
                }
                int lastIndex = tokens.size() - 1;
                NamedToken endToken = tokens.remove(lastIndex);
                if (i >= lastIndex) continue;
                tokens.set(i, endToken);
            }
        }
        return tokens;
    }

    public CommandReaderFactory commandReaderFactory() {
        return RecordStorageCommandReaderFactory.INSTANCE;
    }

    public RecordDatabaseLayout databaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        return RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)databaseName);
    }

    public RecordDatabaseLayout formatSpecificDatabaseLayout(DatabaseLayout plainLayout) {
        if (plainLayout instanceof RecordDatabaseLayout) {
            RecordDatabaseLayout recordLayout = (RecordDatabaseLayout)plainLayout;
            return recordLayout;
        }
        return this.databaseLayout(plainLayout.getNeo4jLayout(), plainLayout.getDatabaseName());
    }

    public StorageFilesState checkStoreFileState(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, KernelVersionProvider kernelVersionProvider, boolean isDirty) {
        RecordDatabaseLayout recordLayout = this.formatSpecificDatabaseLayout(databaseLayout);
        Set storeFiles = Arrays.stream(RecordDatabaseFile.values()).filter(f -> !recordLayout.isRecoverableStore((DatabaseFile)f)).map(arg_0 -> ((RecordDatabaseLayout)recordLayout).file(arg_0)).collect(Collectors.toSet());
        boolean allStoreFilesExist = storeFiles.stream().allMatch(arg_0 -> ((FileSystemAbstraction)fs).fileExists(arg_0));
        if (!allStoreFilesExist) {
            return StorageFilesState.unrecoverableState(storeFiles.stream().filter(file -> !fs.fileExists(file)).toList());
        }
        Set idFiles = Arrays.stream(RecordDatabaseFile.values()).map(arg_0 -> ((RecordDatabaseLayout)recordLayout).idFile(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        boolean allIdFilesExist = idFiles.stream().allMatch(arg_0 -> ((FileSystemAbstraction)fs).fileExists(arg_0));
        if (!allIdFilesExist) {
            return StorageFilesState.recoverableState();
        }
        return StorageFilesState.recoveredState();
    }

    public BatchImporter batchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, boolean overwriteExistingDatabases, PageCacheTracer pageCacheTracer, Configuration config, LogService logService, PrintStream progressOutput, boolean verboseProgressOutput, AdditionalInitialIds additionalInitialIds, Config dbConfig, Monitor monitor, JobScheduler jobScheduler, Collector badCollector, LogFilesInitializer logFilesInitializer, IndexImporterFactory indexImporterFactory, MemoryTracker memoryTracker, CursorContextFactory contextFactory, int numShards, LogTailMetadataFactory logTailMetadataFactory, IndexProvidersAccess indexProvidersAccess) {
        ExecutionMonitor executionMonitor = progressOutput != null ? (verboseProgressOutput ? new SpectrumExecutionMonitor(progressOutput) : ExecutionMonitors.defaultVisible(monitor, progressOutput, System.err)) : ExecutionMonitor.INVISIBLE;
        return BatchImporterFactory.withHighestPriority().instantiate(databaseLayout, fileSystem, pageCacheTracer, config, logService, executionMonitor, additionalInitialIds, (LogTailMetadata)new EmptyLogTailMetadata(dbConfig), dbConfig, monitor, jobScheduler, badCollector, logFilesInitializer, indexImporterFactory, memoryTracker, contextFactory);
    }

    public Input asBatchImporterInput(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, MemoryTracker memoryTracker, ReadBehaviour readBehaviour, boolean compactNodeIdSpace, CursorContextFactory contextFactory, LogTailMetadata logTailMetadata) {
        StoreType[] storesToOpen = (StoreType[])Arrays.stream(StoreType.STORE_TYPES).filter(storeType -> storeType != StoreType.META_DATA).toArray(StoreType[]::new);
        NeoStores neoStores = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), pageCache, pageCacheTracer, fileSystem, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, true, (LogTailLogVersionsMetadata)logTailMetadata, StoreIdGenerator.UNIQUE_ID).openNeoStores(storesToOpen);
        return new LenientStoreInput(neoStores, readBehaviour.decorateTokenHolders(this.loadReadOnlyTokens(neoStores, true, contextFactory, memoryTracker)), compactNodeIdSpace, contextFactory, readBehaviour, memoryTracker);
    }

    public IncrementalBatchImporter incrementalBatchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, Configuration config, LogService logService, PrintStream progressOutput, boolean verboseProgressOutput, AdditionalInitialIds additionalInitialIds, LogTailMetadataFactory logTailMetadataFactory, Config dbConfig, Monitor monitor, JobScheduler jobScheduler, Collector badCollector, LogFilesInitializer logFilesInitializer, IndexImporterFactory indexImporterFactory, MemoryTracker memoryTracker, CursorContextFactory contextFactory, IndexProvidersAccess indexProvidersAccess, int numShards) {
        return IncrementalBatchImporterFactory.withHighestPriority().instantiate(databaseLayout, fileSystem, pageCacheTracer, config, logService, progressOutput, verboseProgressOutput, additionalInitialIds, (ThrowingSupplier<LogTailMetadata, IOException>)((ThrowingSupplier)() -> logTailMetadataFactory.getLogTailMetadata(dbConfig, databaseLayout, (StorageEngineFactory)this)), dbConfig, monitor, jobScheduler, badCollector, logFilesInitializer, indexImporterFactory, memoryTracker, contextFactory, indexProvidersAccess);
    }

    public LockManager createLockManager(Config config, SystemNanoClock clock) {
        return new ForsetiLockManager(config, clock, ResourceType.values());
    }

    public long optimalAvailableConsistencyCheckerMemory(FileSystemAbstraction fs, DatabaseLayout layout, Config config, PageCache pageCache) {
        RecordDatabaseLayout databaseLayout = this.formatSpecificDatabaseLayout(layout);
        CursorContextFactory contextFactory = CursorContextFactory.NULL_CONTEXT_FACTORY;
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate(), false, PageCacheTracer.NULL, layout.getDatabaseName(), true, true);
        try (NeoStores neoStores = new StoreFactory((DatabaseLayout)databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, PageCacheTracer.NULL, fs, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, true, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, StoreIdGenerator.UNIQUE_ID).openNeoStores(StoreType.NODE_LABEL, StoreType.NODE, StoreType.RELATIONSHIP);){
            long highId = Math.max(neoStores.getNodeStore().getIdGenerator().getHighId(), neoStores.getRelationshipStore().getIdGenerator().getHighId());
            long l = 11L * highId;
            return l;
        }
    }

    public void consistencyCheck(FileSystemAbstraction fileSystem, DatabaseLayout layout, Config config, PageCache pageCache, IndexProviderMap indexProviders, InternalLog reportLog, InternalLog verboseLog, ConsistencySummaryStatistics summary, int numberOfThreads, long maxOffHeapCachingMemory, OutputStream progressOutput, boolean verbose, ConsistencyFlags flags, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, LogTailMetadata logTailMetadata, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.ignore(), pageCacheTracer, layout.getDatabaseName());
        try (NeoStores neoStores = new StoreFactory(layout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, pageCacheTracer, fileSystem, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, true, (LogTailLogVersionsMetadata)logTailMetadata, StoreIdGenerator.UNIQUE_ID).openAllNeoStores();){
            neoStores.start(CursorContext.NULL_CONTEXT);
            ProgressMonitorFactory progressMonitorFactory = progressOutput != null ? ProgressMonitorFactory.textual((OutputStream)progressOutput) : ProgressMonitorFactory.NONE;
            try (RecordStorageConsistencyChecker checker = new RecordStorageConsistencyChecker(fileSystem, this.formatSpecificDatabaseLayout(layout), pageCache, neoStores, indexProviders, (IdGeneratorFactory)idGeneratorFactory, summary, progressMonitorFactory, config, numberOfThreads, reportLog, verboseLog, verbose, flags, EntityBasedMemoryLimiter.defaultMemoryLimiter(maxOffHeapCachingMemory), memoryTracker, contextFactory, pageCacheTracer);){
                checker.check();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ImmutableSet<OpenOption> getStoreOpenOptions(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, CursorContextFactory contextFactory) {
        RecordDatabaseLayout recordDatabaseLayout = this.formatSpecificDatabaseLayout(layout);
        RecordFormats recordFormats = RecordFormatSelector.selectForStore(recordDatabaseLayout, fs, pageCache, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory);
        if (recordFormats == null) {
            throw new IllegalStateException("Can't detect open options for empty store");
        }
        return PageCacheOptionsSelector.select(recordFormats);
    }

    public boolean fitsWithinStoreFormatLimits(StoreFormatLimits formatLimits, DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, Config config) {
        return true;
    }

    public int tokenLengthLimit() {
        return Integer.MAX_VALUE;
    }

    public static SchemaRuleMigrationAccess createMigrationTargetSchemaRuleAccess(NeoStores stores, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        SchemaStore dstSchema = stores.getSchemaStore();
        DynamicAllocatorProvider allocatorProvider = DynamicAllocatorProviders.nonTransactionalAllocator(stores);
        TokenCreator propertyKeyTokenCreator = RecordStorageEngineFactory.getPropertyTokenCreator(stores, contextFactory, memoryTracker, allocatorProvider);
        CursorContext cursorContext = contextFactory.create("createMigrationTargetSchemaRuleAccess");
        CachedStoreCursors storeCursors = new CachedStoreCursors(stores, cursorContext);
        TokenHolders dstTokenHolders = RecordStorageEngineFactory.loadTokenHolders(stores, propertyKeyTokenCreator, (StoreCursors)storeCursors, memoryTracker);
        return new SchemaRuleMigrationAccessImpl(stores, new SchemaStorage(dstSchema, dstTokenHolders, (String)stores.getConfig().get(GraphDatabaseSettings.db_format)), allocatorProvider, cursorContext, memoryTracker, (StoreCursors)storeCursors);
    }

    private static TokenCreator getPropertyTokenCreator(NeoStores stores, CursorContextFactory contextFactory, MemoryTracker memoryTracker, DynamicAllocatorProvider allocatorProvider) {
        return RecordStorageEngineFactory.getTokenCreator(stores, stores.getPropertyKeyTokenStore(), StoreType.PROPERTY_KEY_TOKEN_NAME, RecordCursorTypes.DYNAMIC_PROPERTY_KEY_TOKEN_CURSOR, RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR, contextFactory, memoryTracker, allocatorProvider);
    }

    private static TokenCreator getLabelTokenCreator(NeoStores stores, CursorContextFactory contextFactory, MemoryTracker memoryTracker, DynamicAllocatorProvider allocatorProvider) {
        return RecordStorageEngineFactory.getTokenCreator(stores, stores.getLabelTokenStore(), StoreType.LABEL_TOKEN_NAME, RecordCursorTypes.DYNAMIC_LABEL_TOKEN_CURSOR, RecordCursorTypes.LABEL_TOKEN_CURSOR, contextFactory, memoryTracker, allocatorProvider);
    }

    private static TokenCreator getRelTypeTokenCreator(NeoStores stores, CursorContextFactory contextFactory, MemoryTracker memoryTracker, DynamicAllocatorProvider allocatorProvider) {
        return RecordStorageEngineFactory.getTokenCreator(stores, stores.getRelationshipTypeTokenStore(), StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, RecordCursorTypes.DYNAMIC_REL_TYPE_TOKEN_CURSOR, RecordCursorTypes.REL_TYPE_TOKEN_CURSOR, contextFactory, memoryTracker, allocatorProvider);
    }

    private static <T extends TokenRecord, STORE extends TokenStore<T>> TokenCreator getTokenCreator(NeoStores stores, STORE tokenStore, StoreType nameStoreType, CursorType nameStoreCursorType, CursorType storeCursorType, CursorContextFactory contextFactory, MemoryTracker memoryTracker, DynamicAllocatorProvider allocatorProvider) {
        return (name, internal) -> {
            try (CursorContext cursorContext = contextFactory.create("createMigrationTargetSchemaRuleAccess");){
                int n;
                try (CachedStoreCursors storeCursors = new CachedStoreCursors(stores, cursorContext);){
                    DynamicStringStore nameStore = tokenStore.getNameStore();
                    byte[] bytes = PropertyStore.encodeString(name);
                    ArrayList<DynamicRecord> nameRecords = new ArrayList<DynamicRecord>();
                    AbstractDynamicStore.allocateRecordsFromBytes(nameRecords, bytes, allocatorProvider.allocator(nameStoreType), cursorContext, memoryTracker);
                    nameRecords.forEach(record -> nameStore.prepareForCommit(record, (IdSequence)nameStore.getIdGenerator(), cursorContext));
                    try (PageCursor cursor = storeCursors.writeCursor(nameStoreCursorType);){
                        nameRecords.forEach(record -> nameStore.updateRecord(record, cursor, cursorContext, (StoreCursors)storeCursors));
                    }
                    nameRecords.forEach(record -> {
                        long highId = record.getId();
                        nameStore.getIdGenerator().setHighestPossibleIdInUse(highId);
                    });
                    int nameId = ((DynamicRecord)Iterables.first(nameRecords)).getIntId();
                    TokenRecord keyTokenRecord = (TokenRecord)tokenStore.newRecord();
                    long tokenId = tokenStore.getIdGenerator().nextId(cursorContext);
                    keyTokenRecord.setId(tokenId);
                    keyTokenRecord.initialize(true, nameId);
                    keyTokenRecord.setInternal(internal);
                    keyTokenRecord.setCreated();
                    tokenStore.prepareForCommit(keyTokenRecord, (IdSequence)tokenStore.getIdGenerator(), cursorContext);
                    try (PageCursor pageCursor = storeCursors.writeCursor(storeCursorType);){
                        tokenStore.updateRecord(keyTokenRecord, pageCursor, cursorContext, (StoreCursors)storeCursors);
                    }
                    long highId = keyTokenRecord.getId();
                    tokenStore.getIdGenerator().setHighestPossibleIdInUse(highId);
                    n = Math.toIntExact(tokenId);
                }
                return n;
            }
        };
    }

    private static TokenHolders loadTokenHolders(NeoStores stores, TokenCreator propertyKeyTokenCreator, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        RegisteringCreatingTokenHolder propertyKeyTokens = new RegisteringCreatingTokenHolder(propertyKeyTokenCreator, "PropertyKey");
        TokenHolders dstTokenHolders = new TokenHolders((TokenHolder)propertyKeyTokens, StoreTokens.createReadOnlyTokenHolder("Label"), StoreTokens.createReadOnlyTokenHolder("RelationshipType"));
        dstTokenHolders.propertyKeyTokens().setInitialTokens(stores.getPropertyKeyTokenStore().getTokens(storeCursors, memoryTracker));
        return dstTokenHolders;
    }
}

