/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

class RecordStorageLocks
implements StorageLocks {
    private final ResourceLocker locker;

    RecordStorageLocks(ResourceLocker locker) {
        this.locker = locker;
    }

    public void acquireExclusiveNodeLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireExclusive(lockTracer, ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.locker.acquireExclusive(lockTracer, ResourceType.NODE, ids);
    }

    public void releaseExclusiveNodeLock(long ... ids) {
        this.locker.releaseExclusive(ResourceType.NODE, ids);
        this.locker.releaseExclusive(ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, ids);
    }

    public void acquireSharedNodeLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireShared(lockTracer, ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.locker.acquireShared(lockTracer, ResourceType.NODE, ids);
    }

    public void releaseSharedNodeLock(long ... ids) {
        this.locker.releaseShared(ResourceType.NODE, ids);
        this.locker.releaseShared(ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, ids);
    }

    public void acquireExclusiveRelationshipLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP_DELETE, ids);
        this.locker.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP, ids);
    }

    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.locker.releaseExclusive(ResourceType.RELATIONSHIP, ids);
        this.locker.releaseExclusive(ResourceType.RELATIONSHIP_DELETE, ids);
    }

    public void acquireSharedRelationshipLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireShared(lockTracer, ResourceType.RELATIONSHIP_DELETE, ids);
        this.locker.acquireShared(lockTracer, ResourceType.RELATIONSHIP, ids);
    }

    public void releaseSharedRelationshipLock(long ... ids) {
        this.locker.releaseShared(ResourceType.RELATIONSHIP, ids);
        this.locker.releaseShared(ResourceType.RELATIONSHIP_DELETE, ids);
    }

    public void acquireRelationshipCreationLock(LockTracer lockTracer, long sourceNode, long targetNode, boolean sourceNodeAddedInTx, boolean targetNodeAddedInTx) {
        RecordStorageLocks.lockGroupAndDegrees(this.locker, lockTracer, sourceNode, targetNode, sourceNodeAddedInTx, targetNodeAddedInTx);
    }

    public void acquireRelationshipDeletionLock(LockTracer lockTracer, long sourceNode, long targetNode, long relationship, boolean relationshipAddedInTx, boolean sourceNodeAddedInTx, boolean targetNodeAddedInTx) {
        RecordStorageLocks.lockGroupAndDegrees(this.locker, lockTracer, sourceNode, targetNode, sourceNodeAddedInTx, targetNodeAddedInTx);
        this.locker.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP_DELETE, new long[]{relationship});
    }

    public void acquireNodeDeletionLock(ReadableTransactionState txState, LockTracer lockTracer, long node) {
        if (!txState.nodeIsAddedInThisBatch(node)) {
            this.locker.acquireExclusive(lockTracer, ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, new long[]{node});
            this.locker.acquireExclusive(lockTracer, ResourceType.NODE, new long[]{node});
            this.locker.acquireExclusive(lockTracer, ResourceType.DEGREES, new long[]{node});
        }
    }

    public void acquireNodeLabelChangeLock(LockTracer lockTracer, long node, int labelId) {
        this.locker.acquireExclusive(lockTracer, ResourceType.DEGREES, new long[]{node});
    }

    private static void lockGroupAndDegrees(ResourceLocker locker, LockTracer lockTracer, long sourceNode, long targetNode, boolean sourceNodeAddedInTx, boolean targetNodeAddedInTx) {
        long minNode;
        RecordStorageLocks.lockGroupAndDegrees(locker, lockTracer, minNode, (minNode = Math.min(sourceNode, targetNode)) == sourceNode ? sourceNodeAddedInTx : targetNodeAddedInTx);
        if (sourceNode != targetNode) {
            long maxNode;
            RecordStorageLocks.lockGroupAndDegrees(locker, lockTracer, maxNode, (maxNode = Math.max(sourceNode, targetNode)) == sourceNode ? sourceNodeAddedInTx : targetNodeAddedInTx);
        }
    }

    private static void lockGroupAndDegrees(ResourceLocker locker, LockTracer lockTracer, long node, boolean nodeAddedInTx) {
        if (!nodeAddedInTx) {
            locker.acquireShared(lockTracer, ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, new long[]{node});
            locker.acquireShared(lockTracer, ResourceType.DEGREES, new long[]{node});
        }
    }
}

